/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.task.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.gvsig.tools.task.impl.BaseTaskStatus;

public class DefaultTaskStatusManager
implements TaskStatusManager {
    private static final int MAXTASKS_TO_AUTOREMOVE = 15;
    private static long codeCounter = 1L;
    private Map tasksStatus = new LinkedHashMap();
    private ObservableHelper observers = new ObservableHelper();

    @Override
    public synchronized void add(TaskStatus taskStatus) {
        this.tasksStatus.put(taskStatus.getCode(), taskStatus);
        this.update(taskStatus);
    }

    @Override
    public synchronized TaskStatus get(String code) {
        return (TaskStatus)this.tasksStatus.get(code);
    }

    @Override
    public synchronized void remove(String code) {
        TaskStatus st = (TaskStatus)this.tasksStatus.get(code);
        this.tasksStatus.remove(code);
        this.observers.notifyObservers(this, st);
    }

    @Override
    public synchronized void remove(TaskStatus taskStatus) {
        this.tasksStatus.remove(taskStatus.getCode());
        this.observers.notifyObservers(this, taskStatus);
    }

    @Override
    public String getNewCode() {
        return Long.toBinaryString(codeCounter++);
    }

    @Override
    public synchronized Map getAll() {
        return Collections.unmodifiableMap(this.tasksStatus);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.tasksStatus.isEmpty();
    }

    @Override
    public synchronized void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    @Override
    public synchronized void deleteObservers() {
        this.observers.deleteObservers();
    }

    @Override
    public synchronized void update(TaskStatus taskstatus) {
        if (taskstatus != null && this.tasksStatus.get(taskstatus.getCode()) == null) {
            return;
        }
        this.observers.notifyObservers(this, taskstatus);
        if (taskstatus != null && !taskstatus.isRunning() && taskstatus instanceof SimpleTaskStatus && ((SimpleTaskStatus)taskstatus).getAutoRemove() && this.tasksStatus.size() > 15) {
            this.tasksStatus.remove(((SimpleTaskStatus)taskstatus).getCode());
        }
    }

    @Override
    public SimpleTaskStatus creteDefaultSimpleTaskStatus(String tittle) {
        return this.createDefaultSimpleTaskStatus(tittle);
    }

    @Override
    public SimpleTaskStatus createDefaultSimpleTaskStatus(String title) {
        return new BaseTaskStatus(title);
    }

    @Override
    public synchronized TaskStatus getRunningTaskStatusMostRecent() {
        TaskStatus mostRecent = null;
        for (TaskStatus current : this.tasksStatus.values()) {
            if (!current.isRunning() || mostRecent != null && current.getLastModification().compareTo(mostRecent.getLastModification()) <= 0) continue;
            mostRecent = current;
        }
        return mostRecent;
    }
}

