/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.simplehttpserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;
import org.gvsig.simplehttpserver.SimpleServer;
import org.gvsig.simplehttpserver.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHandler.class);
    private final SimpleServer server;

    public HttpHandler(SimpleServer server) {
        this.server = server;
    }

    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer();
    }

    public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
        HttpResponse response = httpexchange.getResponse();
        this.handleInternal(request, response, context);
        httpexchange.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer(response));
    }

    private void handleInternal(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        Object entity;
        Object ret;
        String target_uri;
        InputStream contents = null;
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!method.equals("GET")) {
            if (method.equals("POST")) {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntity httpEntity = ((HttpEntityEnclosingRequest)request).getEntity();
                    contents = httpEntity.getContent();
                }
            } else {
                this.server.log(1, "Method not supported, Only GET/POST supported.");
                throw new MethodNotSupportedException(method + " method not supported");
            }
        }
        String target_path = target_uri = request.getRequestLine().getUri();
        List queryparams = null;
        try {
            URL url = this.server.getURL(target_path);
            target_path = url.getPath();
            queryparams = URLEncodedUtils.parse((String)url.getQuery(), (Charset)Charset.forName("UTF-8"));
        }
        catch (Exception url) {
            // empty catch block
        }
        String commandline = URLDecoder.decode(target_path, "UTF-8");
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(StringUtils.split((String)commandline, (char)'/')));
        if (queryparams != null) {
            for (NameValuePair queryparam : queryparams) {
                args.add(queryparam.getName());
                args.add(queryparam.getValue());
            }
        }
        int argc = args.size() - 1;
        Command command = this.server.getCommand(args);
        if (command == null) {
            this.server.log(1, "Command '" + target_uri + "' not found.");
            response.setStatusCode(404);
            NStringEntity entity2 = new NStringEntity("<html><body><h1>Command " + target_uri + " not found</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity2);
            return;
        }
        if (!command.getNumArgs().contains((Object)argc)) {
            this.server.log(1, "Command '" + target_uri + "', invalid number of arguments.");
            response.setStatusCode(400);
            NStringEntity entity3 = new NStringEntity("<html><body><h1>Number of arguments invalid in " + target_uri + "</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity3);
            return;
        }
        try {
            ret = command.call(argc, args, contents);
        }
        catch (Exception ex) {
            LOG.warn("Can't server command '" + target_uri + "'.", (Throwable)ex);
            this.server.log(1, "Command '" + target_uri + "', error " + ex.getMessage() + ".");
            response.setStatusCode(500);
            NStringEntity entity4 = new NStringEntity("<html><body><h1>Error processing " + target_uri + "</h1><p>" + ex.toString() + "</p></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity4);
            return;
        }
        response.setStatusCode(200);
        if (ret == null) {
            this.server.log(1, "Command '" + target_uri + "' return null.");
            response.setStatusCode(500);
            entity = new NStringEntity("<html><body><h1>Process " + target_uri + " return null</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
        } else {
            entity = ret instanceof InputStream ? new InputStreamEntity((InputStream)ret, ContentType.create((String)command.getMimeType(), (String)"UTF-8")) : (ret instanceof byte[] ? new ByteArrayEntity((byte[])ret, ContentType.create((String)command.getMimeType(), (String)"UTF-8")) : new NStringEntity(ret.toString(), ContentType.create((String)command.getMimeType(), (String)"UTF-8")));
        }
        response.setEntity((HttpEntity)entity);
        this.server.log(0, "Command '" + target_uri + "' ok.");
    }
}

