/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.simplehttpserver;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gvsig.simplehttpserver.SimpleServerConfig;
import org.gvsig.simplehttpserver.commands.CommandFactory;
import org.gvsig.simplehttpserver.commands.HelpFactory;
import org.gvsig.tools.util.PropertiesSupportHelper;

public class SimpleServerConfigImpl
implements SimpleServerConfig {
    private int port = 9876;
    private int timeout = 15000;
    private String serverInfo = "Test/1.1";
    private boolean autostart;
    private final PropertyChangeSupport propertyChangeSupport;
    private final Map<String, CommandFactory> commandFactories;
    private final PropertiesSupportHelper propertiesHelper = new PropertiesSupportHelper();

    public SimpleServerConfigImpl() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.commandFactories = new HashMap<String, CommandFactory>();
        HelpFactory factory = new HelpFactory();
        this.commandFactories.put(factory.getName().toLowerCase(), (CommandFactory)factory);
    }

    public int getPort() {
        return this.port;
    }

    public SimpleServerConfig setPort(int port) {
        int oldValue = this.port;
        this.port = port;
        this.propertyChangeSupport.firePropertyChange("port", oldValue, port);
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public SimpleServerConfig setTimeout(int timeout) {
        int oldValue = this.timeout;
        this.timeout = timeout;
        this.propertyChangeSupport.firePropertyChange("timeout", oldValue, timeout);
        return this;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public SimpleServerConfig setServerInfo(String serverInfo) {
        String oldValue = this.serverInfo;
        this.serverInfo = serverInfo;
        this.propertyChangeSupport.firePropertyChange("serverInfo", oldValue, serverInfo);
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Collection<CommandFactory> getCommandFactories() {
        return this.commandFactories.values();
    }

    public SimpleServerConfig addCommandFactory(CommandFactory factory) {
        this.commandFactories.put(factory.getName().toLowerCase(), factory);
        return this;
    }

    public void removeCommandFactory(CommandFactory factory) {
        this.commandFactories.remove(factory.getName());
    }

    public void removeCommandFactory(String name) {
        this.commandFactories.remove(name);
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }
}

