/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.webbrowser.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.webbrowser.WebBrowserPanel;
import org.gvsig.webbrowser.impl.DefaultWebBrowserPanelView;
import org.gvsig.webbrowser.impl.WebBrowserHistoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebBrowserPanel
extends DefaultWebBrowserPanelView
implements WebBrowserPanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultWebBrowserPanel.class);
    protected WebBrowserPanel.WebBrowser browser;

    public DefaultWebBrowserPanel() {
        this.initComponents();
    }

    protected WebBrowserPanel.WebBrowser createBrowserPanel() {
        return new WebBrowserPanel.WebBrowser(){
            private JEditorPane panel = new JEditorPane();
            private WebBrowserHistoryImpl history = new WebBrowserHistoryImpl();

            public void setPage(URL url) throws IOException {
                this.history.go(url);
                this.panel.setPage(url);
            }

            public String getPage() {
                URL url = this.history.get();
                return url.toString();
            }

            public String getTitle() {
                return "";
            }

            public void goPrevious() {
                this.history.previous();
            }

            public void goNext() {
                this.history.next();
            }

            public void find(String text, boolean backwards) {
            }

            public void setContent(String content, String contentType) {
                this.panel.setText(content);
            }

            public JComponent asJComponent() {
                return this.panel;
            }
        };
    }

    protected WebBrowserPanel.WebBrowser getBrowser() {
        return this.browser;
    }

    private void initComponents() {
        this.browser = this.createBrowserPanel();
        JScrollPane scrollPanel = new JScrollPane(this.browser.asJComponent(), 22, 32);
        this.containerBrowser.setLayout(new BorderLayout());
        this.containerBrowser.add((Component)scrollPanel, "Center");
        try {
            this.txtURL.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n') {
                        DefaultWebBrowserPanel.this.setPage(DefaultWebBrowserPanel.this.txtURL.getText());
                    }
                }
            });
            this.txtSearch.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    JTextField jtext = DefaultWebBrowserPanel.this.txtSearch;
                    if (event.getKeyChar() == '\u001b') {
                        jtext.setText("");
                        DefaultWebBrowserPanel.this.find("", true);
                    } else if (event.getKeyChar() == '\n') {
                        DefaultWebBrowserPanel.this.find(jtext.getText(), true);
                    }
                }
            });
            this.btnSearchPrevious.addActionListener(e -> this.find(this.txtSearch.getText(), false));
            this.btnSearchNext.addActionListener(e -> this.find(this.txtSearch.getText(), true));
            this.btnPrevious.addActionListener(e -> this.browser.goPrevious());
            this.btnNext.addActionListener(e -> this.browser.goNext());
            this.setPreferredSize(new Dimension(600, 500));
        }
        catch (Exception ex) {
            LOGGER.warn("Can't initialize browser panel", (Throwable)ex);
        }
    }

    public void find(String text, boolean forward) {
    }

    public void setPage(String url) {
        try {
            this.setPage(new URL(url));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setPage(URL url) {
        this.txtURL.setText(url.toString());
        SwingUtilities.invokeLater(() -> {
            try {
                this.getBrowser().setPage(url);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't load page from url '" + url + "'.", (Throwable)ex);
            }
        });
    }

    public String getPage() {
        return this.getBrowser().getPage();
    }

    public void setContent(String content, String contentType) {
        this.getBrowser().setContent(content, contentType);
    }

    public String getTitle() {
        return this.getBrowser().getTitle();
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public void setStatus(String msg) {
        this.lblStatus.setText(msg);
    }

    public void setURLText(String url) {
        this.txtURL.setText(url);
    }

    public static final void selfRegister() {
        ToolsSwingUtils.registerIcons(DefaultWebBrowserPanel.class, (String)"images", (String)"webbrowser", (String[][])new String[][]{{"webbrowser", "webbrowser-config"}, {"webbrowser", "webbrowser-next"}, {"webbrowser", "webbrowser-previous"}, {"webbrowser", "webbrowser-refresh"}, {"webbrowser", "webbrowser-search"}, {"webbrowser", "webbrowser-search-next"}, {"webbrowser", "webbrowser-search-previous"}});
    }
}

