/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.texteditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.commons.io.FileUtils;
import org.gvsig.texteditor.AbstractJTextEditor;
import org.gvsig.texteditor.TextEditorManager;

public class DefaultJTextEditor
extends AbstractJTextEditor {
    private JTextArea textArea;
    private boolean opened = false;
    private boolean saved = false;
    private File openedFile;
    private UndoManager undo;
    private String mimeType;

    public DefaultJTextEditor(TextEditorManager factory) {
        super(factory);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.addMenuItem(fileMenu, "Open...", e -> this.doOpenFile());
        this.addMenuItem(fileMenu, "Save", e -> this.doSaveFile());
        this.addMenuItem(fileMenu, "Save as...", e -> this.doSaveAsFile());
        this.addMenuItem(fileMenu, "Close", e -> this.doClose());
        JMenu editMenu = new JMenu("Edit");
        this.addMenuItem(editMenu, "Undo", e -> this.doUndo());
        this.addMenuItem(editMenu, "Redo", e -> this.doRedo());
        this.addMenuItem(editMenu, "Select all", e -> this.doSelectAll());
        this.addMenuItem(editMenu, "Cut", e -> this.doCut());
        this.addMenuItem(editMenu, "Copy", e -> this.doCopy());
        this.addMenuItem(editMenu, "Paste", e -> this.doPaste());
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        this.undo = new UndoManager();
        this.textArea.getDocument().addUndoableEditListener(e -> this.undo.addEdit(e.getEdit()));
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)menuBar, "North");
        JScrollPane scroll = new JScrollPane(this.getJTextComponent(), 22, 32);
        this.panel.add((Component)scroll, "Center");
    }

    private void addMenuItem(JMenu menu, String text, ActionListener listener) {
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(listener);
        item.setEnabled(true);
        menu.add(item);
    }

    private void saveFile(File file) {
        try {
            FileUtils.write((File)file, (CharSequence)this.textArea.getText());
            this.saved = true;
        }
        catch (IOException ex) {
            LOGGER.warn("Can't save file (" + Objects.toString(file) + ")", (Throwable)ex);
        }
    }

    private void doOpenFile() {
        JFileChooser open = new JFileChooser();
        open.showOpenDialog(null);
        File file = open.getSelectedFile();
        try {
            this.openedFile = file;
            String s = FileUtils.readFileToString((File)file);
            this.textArea.setText(s);
            this.opened = true;
        }
        catch (IOException ex) {
            LOGGER.warn("Can't open file (" + Objects.toString(file) + ")", (Throwable)ex);
        }
    }

    private void doSaveFile() {
        JFileChooser save = new JFileChooser();
        File file = save.getSelectedFile();
        if (!this.opened && !this.saved) {
            save.showSaveDialog(null);
            if (file.exists()) {
                int confirmationResult = JOptionPane.showConfirmDialog(this.panel, "Replace existing file?");
                if (confirmationResult == 0) {
                    this.saveFile(file);
                }
            } else {
                this.saveFile(file);
            }
        } else {
            try {
                FileUtils.write((File)this.openedFile, (CharSequence)this.textArea.getText());
            }
            catch (IOException ex) {
                LOGGER.warn("Can't save file (" + Objects.toString(file) + ")", (Throwable)ex);
            }
        }
    }

    private void doSaveAsFile() {
        JFileChooser saveAs = new JFileChooser();
        saveAs.showSaveDialog(null);
        File filename = saveAs.getSelectedFile();
        if (filename.exists()) {
            int confirmationResult = JOptionPane.showConfirmDialog(this.panel, "Replace existing file?");
            if (confirmationResult == 0) {
                this.saveFile(filename);
            }
        } else {
            this.saveFile(filename);
        }
    }

    private void doClose() {
        this.panel.setVisible(false);
    }

    private void doUndo() {
        try {
            this.undo.undo();
        }
        catch (CannotUndoException ex) {
            LOGGER.warn("Can't undo", (Throwable)ex);
        }
    }

    private void doRedo() {
        try {
            this.undo.redo();
        }
        catch (CannotUndoException ex) {
            LOGGER.warn("Can't redo", (Throwable)ex);
        }
    }

    private void doSelectAll() {
        this.textArea.selectAll();
    }

    private void doCopy() {
        this.textArea.copy();
    }

    private void doPaste() {
        this.textArea.paste();
    }

    private void doCut() {
        this.textArea.cut();
    }

    public void setMimetype(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimetype() {
        return this.mimeType;
    }

    public void setContents(Object data) {
        if (data instanceof String) {
            this.textArea.setText((String)data);
            return;
        }
        if (data instanceof byte[]) {
            this.textArea.setText(new String((byte[])data));
            return;
        }
        super.setContents(data);
    }

    public byte[] getBytes() {
        return this.textArea.getText().getBytes(StandardCharsets.UTF_8);
    }

    public String getContents() {
        return this.textArea.getText();
    }

    public void clean() {
        this.setContents("");
    }

    public JTextComponent getJTextComponent() {
        if (this.textArea == null) {
            this.textArea = new JTextArea(30, 50);
            this.textArea.setEditable(true);
            Font textFont = new Font("Verdana", 0, 14);
            this.textArea.setFont(textFont);
        }
        return this.textArea;
    }
}

