/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.hexeditor.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

class ByteArrayTransferable
implements Transferable {
    private int offset;
    private byte[] bytes;
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};

    public ByteArrayTransferable(int offset, byte[] bytes) {
        this.offset = offset;
        this.bytes = bytes != null ? (byte[])bytes.clone() : new byte[0];
    }

    public int getLength() {
        return this.bytes.length;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(FLAVORS[0])) {
            return new String(this.bytes);
        }
        if (flavor.equals(FLAVORS[1])) {
            return new StringReader(new String(this.bytes));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < FLAVORS.length; ++i) {
            if (!flavor.equals(FLAVORS[i])) continue;
            return true;
        }
        return false;
    }
}

