/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.hexeditor.swing;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.gvsig.tools.swing.impl.hexeditor.swing.ByteBuffer;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexEditorComponent;

public class HexTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private HexEditorComponent editor;
    private ByteBuffer doc;
    private int bytesPerRow;
    private UndoManager undoManager;
    private String[] columnNames;
    private byte[] bitBuf = new byte[16];
    private char[] dumpColBuf;
    private String[] paddedLowerByteStrVals;
    private String[] byteStrVals;

    public HexTableModel(HexEditorComponent editor) {
        int i;
        this.editor = editor;
        this.doc = new ByteBuffer(16);
        this.bytesPerRow = 16;
        this.undoManager = new UndoManager();
        this.columnNames = new String[17];
        for (i = 0; i < 16; ++i) {
            this.columnNames[i] = "+" + Integer.toHexString(i).toUpperCase();
        }
        this.columnNames[16] = "AsciiDump";
        this.dumpColBuf = new char[16];
        Arrays.fill(this.dumpColBuf, ' ');
        this.byteStrVals = new String[256];
        for (i = 0; i < this.byteStrVals.length; ++i) {
            this.byteStrVals[i] = Integer.toHexString(i);
        }
        this.paddedLowerByteStrVals = new String[16];
        for (i = 0; i < this.paddedLowerByteStrVals.length; ++i) {
            this.paddedLowerByteStrVals[i] = "0" + Integer.toHexString(i);
        }
    }

    public byte getByte(int offset) {
        return this.doc.getByte(offset);
    }

    public int getByteCount() {
        return this.doc.getSize();
    }

    public byte[] getBytes() {
        return this.doc.getBytes();
    }

    public int getBytesPerRow() {
        return this.bytesPerRow;
    }

    @Override
    public int getColumnCount() {
        return this.getBytesPerRow() + 1;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.doc.getSize() / this.bytesPerRow + (this.doc.getSize() % this.bytesPerRow > 0 ? 1 : 0);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == this.bytesPerRow) {
            int pos = this.editor.cellToOffset(row, 0);
            if (pos == -1) {
                return "";
            }
            int count = this.doc.read(pos, this.bitBuf);
            for (int i = 0; i < count; ++i) {
                int ch = this.bitBuf[i];
                if (ch < 32 || ch > 126) {
                    ch = 46;
                }
                this.dumpColBuf[i] = ch;
            }
            return new String(this.dumpColBuf, 0, count);
        }
        int pos = this.editor.cellToOffset(row, col);
        if (pos == -1) {
            return "";
        }
        int b = this.doc.getByte(pos) & 0xFF;
        return b < 16 && this.editor.getPadLowBytes() ? this.paddedLowerByteStrVals[b] : this.byteStrVals[b];
    }

    public boolean redo() {
        boolean canRedo = this.undoManager.canRedo();
        if (canRedo) {
            this.undoManager.redo();
            canRedo = this.undoManager.canRedo();
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
        }
        return canRedo;
    }

    public void removeBytes(int offset, int len) {
        this.replaceBytes(offset, len, null);
    }

    public void replaceBytes(int offset, int len, byte[] bytes) {
        byte[] removed = null;
        if (len > 0) {
            removed = new byte[len];
            this.doc.remove(offset, len, removed);
        }
        byte[] added = null;
        if (bytes != null && bytes.length > 0) {
            this.doc.insertBytes(offset, bytes);
            added = (byte[])bytes.clone();
        }
        if (removed != null || added != null) {
            this.undoManager.addEdit(new BytesReplacedUndoableEdit(offset, removed, added));
            this.fireTableDataChanged();
            int addCount = added == null ? 0 : added.length;
            int remCount = removed == null ? 0 : removed.length;
            this.editor.fireHexEditorEvent(offset, addCount, remCount);
        }
    }

    public void setBytes(String fileName) throws IOException {
        this.doc = new ByteBuffer(fileName);
        this.undoManager.discardAllEdits();
        this.fireTableDataChanged();
        this.editor.fireHexEditorEvent(0, this.doc.getSize(), 0);
    }

    public void setBytes(InputStream in) throws IOException {
        this.doc = new ByteBuffer(in);
        this.undoManager.discardAllEdits();
        this.fireTableDataChanged();
        this.editor.fireHexEditorEvent(0, this.doc.getSize(), 0);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        byte b = (byte)Integer.parseInt((String)value, 16);
        int offset = this.editor.cellToOffset(row, col);
        if (offset > -1) {
            byte old = this.doc.getByte(offset);
            if (old == b) {
                return;
            }
            this.doc.setByte(offset, b);
            this.undoManager.addEdit(new ByteChangedUndoableEdit(offset, old, b));
            this.fireTableCellUpdated(row, col);
            this.fireTableCellUpdated(row, this.bytesPerRow);
            this.editor.fireHexEditorEvent(offset, 1, 1);
        }
    }

    public boolean undo() {
        boolean canUndo = this.undoManager.canUndo();
        if (canUndo) {
            this.undoManager.undo();
            canUndo = this.undoManager.canUndo();
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
        }
        return canUndo;
    }

    private class BytesReplacedUndoableEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private int offs;
        private byte[] removed;
        private byte[] added;

        public BytesReplacedUndoableEdit(int offs, byte[] removed, byte[] added) {
            this.offs = offs;
            this.removed = removed;
            this.added = added;
        }

        @Override
        public void undo() {
            super.undo();
            if (HexTableModel.this.getByteCount() < this.offs) {
                throw new CannotUndoException();
            }
            this.removeAndAdd(this.added, this.removed);
        }

        @Override
        public void redo() {
            super.redo();
            if (HexTableModel.this.getByteCount() < this.offs) {
                throw new CannotRedoException();
            }
            this.removeAndAdd(this.removed, this.added);
        }

        private void removeAndAdd(byte[] toRemove, byte[] toAdd) {
            int remCount = toRemove == null ? 0 : toRemove.length;
            int addCount = toAdd == null ? 0 : toAdd.length;
            HexTableModel.this.doc.remove(this.offs, remCount);
            HexTableModel.this.doc.insertBytes(this.offs, toAdd);
            HexTableModel.this.fireTableDataChanged();
            int endOffs = this.offs;
            if (toAdd != null && toAdd.length > 0) {
                endOffs += toAdd.length - 1;
            }
            HexTableModel.this.editor.setSelectedRange(this.offs, endOffs);
            HexTableModel.this.editor.fireHexEditorEvent(this.offs, addCount, remCount);
        }
    }

    private class ByteChangedUndoableEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private int offs;
        private byte oldVal;
        private byte newVal;

        public ByteChangedUndoableEdit(int offs, byte oldVal, byte newVal) {
            this.offs = offs;
            this.oldVal = oldVal;
            this.newVal = newVal;
        }

        @Override
        public void undo() {
            super.undo();
            if (HexTableModel.this.getByteCount() < this.offs) {
                throw new CannotUndoException();
            }
            this.setValueImpl(this.offs, this.oldVal);
        }

        @Override
        public void redo() {
            super.redo();
            if (HexTableModel.this.getByteCount() < this.offs) {
                throw new CannotRedoException();
            }
            this.setValueImpl(this.offs, this.newVal);
        }

        private void setValueImpl(int offset, byte val) {
            HexTableModel.this.editor.setSelectedRange(offset, offset);
            HexTableModel.this.doc.setByte(offset, val);
            Point p = HexTableModel.this.editor.offsetToCell(offset);
            HexTableModel.this.fireTableCellUpdated(p.x, p.y);
            HexTableModel.this.fireTableCellUpdated(p.x, HexTableModel.this.bytesPerRow);
            HexTableModel.this.editor.fireHexEditorEvent(offset, 1, 1);
        }
    }
}

