/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.threadsafedialogs;

import com.notification.Notification;
import com.notification.NotificationFactory;
import com.notification.manager.SimpleManager;
import com.notification.types.TextNotification;
import com.theme.ThemePackagePresets;
import com.utils.Time;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;
import org.gvsig.tools.swing.api.reminder.DialogReminder;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.task.RunnableWithParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultThreadSafeDialogsManager
implements ThreadSafeDialogsManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultThreadSafeDialogsManager.class);
    private final Component rootComponent;

    public DefaultThreadSafeDialogsManager() {
        this.rootComponent = null;
    }

    public DefaultThreadSafeDialogsManager(Component rootComponent) {
        this.rootComponent = rootComponent;
    }

    protected Component getRootComponent() {
        return this.rootComponent;
    }

    private String translate(String message) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation(message);
    }

    private String translate(String message, String[] args) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation(message, args);
    }

    public int confirmDialog(String message, String title, int optionType, int messageType) {
        return this.confirmDialog(message, title, optionType, messageType, null);
    }

    public void message(String message, int message_type) {
        try {
            NotificationFactory factory = new NotificationFactory(ThemePackagePresets.cleanLight());
            SimpleManager plain = new SimpleManager(NotificationFactory.Location.SOUTHWEST);
            TextNotification notification = factory.buildTextNotification("Message", message);
            notification.setCloseOnClick(true);
            plain.addNotification((Notification)notification, Time.seconds((double)2.0));
        }
        catch (Exception ex) {
            System.out.println("Message: " + message);
        }
    }

    public int confirmDialog(final String message, final String title, final int optionType, final int messageType, final String msgid) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                DialogReminder r = null;
                Object msg = message;
                if (msgid != null) {
                    r = ToolsSwingLocator.getDialogReminderManager().add(msgid);
                    if (r.hasValue()) {
                        this.returnValue = r.getValue();
                        return;
                    }
                    msg = new JMessageWithCheck(message, ToolsLocator.getI18nManager().getTranslation("_Remember_answer_and_do_not_ask_again"));
                }
                this.returnValue = JOptionPane.showConfirmDialog(DefaultThreadSafeDialogsManager.this.getRootComponent(), msg, title, optionType, messageType);
                if (r != null) {
                    if (((JMessageWithCheck)msg).isCheckSelected()) {
                        r.setValue(this.returnValue);
                    } else {
                        r.reset();
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show input dialog '" + message + "'.", (Throwable)e);
            }
        }
        return (Integer)runnable.getReturnValue();
    }

    public String inputDialog(final String message, final String title, final int messageType, final String initialValue) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                this.returnValue = JOptionPane.showInputDialog(DefaultThreadSafeDialogsManager.this.getRootComponent(), DefaultThreadSafeDialogsManager.this.translate(message), DefaultThreadSafeDialogsManager.this.translate(title), messageType, null, null, initialValue);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show input dialog '" + message + "'.", (Throwable)e);
            }
        }
        return (String)runnable.getReturnValue();
    }

    public String inputDialog(final String message, final String title) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                this.returnValue = JOptionPane.showInputDialog(DefaultThreadSafeDialogsManager.this.getRootComponent(), DefaultThreadSafeDialogsManager.this.translate(message), DefaultThreadSafeDialogsManager.this.translate(title), 3, null, null, null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show input dialog '" + message + "'.", (Throwable)e);
            }
        }
        return (String)runnable.getReturnValue();
    }

    public void messageDialog(String message, String title, int messageType) {
        this.messageDialog(message, null, title, messageType);
    }

    public void messageDialog(String message, String[] messageArgs, String title, int messageType) {
        this.messageDialog(message, messageArgs, title, messageType, null);
    }

    public void messageDialog(final String message, final String[] messageArgs, final String title, final int messageType, final String msgid) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultThreadSafeDialogsManager.this.messageDialog(message, messageArgs, title, messageType, msgid);
                    }
                });
            }
            catch (Exception e) {
                logger.warn("Can't show message dialog '" + message + "'.", (Throwable)e);
            }
            return;
        }
        if (message == null) {
            logger.info("message if null, message dialog not show.");
            return;
        }
        DialogReminder r = null;
        Object msg = this.translate(message, messageArgs);
        if (msgid != null) {
            r = ToolsSwingLocator.getDialogReminderManager().add(msgid);
            if (r.hasValue() && ((Boolean)r.getValue()).booleanValue()) {
                return;
            }
            msg = new JMessageWithCheck(this.translate(message, messageArgs), ToolsLocator.getI18nManager().getTranslation("_do_not_show_again"));
        }
        JOptionPane.showMessageDialog(this.getRootComponent(), msg, this.translate(title), messageType);
        if (r != null) {
            if (((JMessageWithCheck)msg).isCheckSelected()) {
                r.setValue((Object)true);
            } else {
                r.reset();
            }
        }
    }

    public Component createComponent(Class<? extends Component> theClass, Object ... parameters) {
        return this.createComponentWithParams(theClass, parameters);
    }

    public Component createComponentWithParams(Class<? extends Component> theClass, Object[] parameters) {
        Component component;
        Constructor<? extends Component> constructor;
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        try {
            constructor = theClass.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                component = constructor.newInstance(parameters);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            RunnableWithParameters runnable = new RunnableWithParameters(parameters){

                public void run() {
                    Constructor cons = constructor;
                    try {
                        this.returnValue = cons.newInstance(this.parameters.toArray());
                    }
                    catch (Exception e) {
                        String msg = "Can't create instance of components, constructor=" + cons.toString() + ", parameters=" + this.parameters.toString() + ".";
                        logger.info(msg, (Throwable)e);
                        throw new IllegalArgumentException(e);
                    }
                }
            };
            SwingUtilities.invokeAndWait((Runnable)runnable);
            component = (Component)runnable.getReturnValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return component;
    }

    public File[] showChooserDialog(final String title, final int type, final int selectionMode, final boolean multiselection, final File initialPath, final FileFilter filter, final boolean fileHidingEnabled) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                int r;
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(title);
                fc.setDialogType(type);
                fc.setFileSelectionMode(selectionMode);
                fc.setMultiSelectionEnabled(multiselection);
                fc.setCurrentDirectory(initialPath);
                fc.setFileFilter(filter);
                fc.setFileHidingEnabled(fileHidingEnabled);
                switch (type) {
                    case 1: {
                        r = fc.showSaveDialog(DefaultThreadSafeDialogsManager.this.getRootComponent());
                        break;
                    }
                    default: {
                        r = fc.showOpenDialog(DefaultThreadSafeDialogsManager.this.getRootComponent());
                    }
                }
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                this.returnValue = fc.isMultiSelectionEnabled() ? fc.getSelectedFiles() : new File[]{fc.getSelectedFile()};
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (File[])runnable.getReturnValue();
    }

    public ImmutablePair<File[], Charset> showChooserDialog(final String title, final int type, final int selectionMode, final boolean multiselection, final File initialPath, final FileFilter filter, final boolean fileHidingEnabled, boolean askCharset) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                int r;
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(title);
                fc.setDialogType(type);
                fc.setFileSelectionMode(selectionMode);
                fc.setMultiSelectionEnabled(multiselection);
                fc.setCurrentDirectory(initialPath);
                fc.setFileFilter(filter);
                fc.setFileHidingEnabled(fileHidingEnabled);
                CharsetPickerController charsetPicker = DefaultThreadSafeDialogsManager.this.setCharsetAccesoryPanel(fc);
                switch (type) {
                    case 1: {
                        r = fc.showSaveDialog(DefaultThreadSafeDialogsManager.this.getRootComponent());
                        break;
                    }
                    default: {
                        r = fc.showOpenDialog(DefaultThreadSafeDialogsManager.this.getRootComponent());
                    }
                }
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                Charset charset = (Charset)charsetPicker.get();
                this.returnValue = fc.isMultiSelectionEnabled() ? new ImmutablePair((Object)fc.getSelectedFiles(), (Object)charset) : new ImmutablePair((Object)new File[]{fc.getSelectedFile()}, (Object)charset);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (ImmutablePair)runnable.getReturnValue();
    }

    public File[] showChooserDialog(final String title, final int type, final int selectionMode, final boolean multiselection, final File initialPath, final FileFilter filter, final boolean fileHidingEnabled, final JComponent accesory) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                int r;
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(title);
                fc.setDialogType(type);
                fc.setFileSelectionMode(selectionMode);
                fc.setMultiSelectionEnabled(multiselection);
                fc.setCurrentDirectory(initialPath);
                fc.setFileFilter(filter);
                fc.setFileHidingEnabled(fileHidingEnabled);
                fc.setAccessory(accesory);
                switch (type) {
                    case 1: {
                        r = fc.showSaveDialog(DefaultThreadSafeDialogsManager.this.getRootComponent());
                        break;
                    }
                    default: {
                        r = fc.showOpenDialog(DefaultThreadSafeDialogsManager.this.getRootComponent());
                    }
                }
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                this.returnValue = fc.isMultiSelectionEnabled() ? fc.getSelectedFiles() : new File[]{fc.getSelectedFile()};
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (File[])runnable.getReturnValue();
    }

    public File[] showOpenDirectoryDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 1, false, initialPath, null, false);
    }

    public File[] showOpenFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 0, false, initialPath, null, false);
    }

    public File[] showSaveFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 1, 0, false, initialPath, null, false);
    }

    private CharsetPickerController setCharsetAccesoryPanel(JFileChooser fc) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel lblLabel = new JLabel(i18n.getTranslation("_Charset"));
        lblLabel.setAlignmentX(0.0f);
        panel.add((Component)lblLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 19, 2, new Insets(1, 2, 1, 2), 0, 0));
        JComboBox cboCharset = new JComboBox();
        panel.add(cboCharset, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 19, 2, new Insets(1, 2, 1, 2), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 19, 1, new Insets(0, 0, 0, 0), 0, 0));
        CharsetPickerController charsetPicker = ToolsSwingLocator.getToolsSwingManager().createCharsetPickerController(lblLabel, cboCharset);
        fc.setAccessory(panel);
        return charsetPicker;
    }

    private static class JMessageWithCheck
    extends JPanel {
        private static final long serialVersionUID = -1902712909850016361L;
        private final JLabel label;
        private final JCheckBox check;

        public JMessageWithCheck(String msg, String msgchk) {
            if (!msg.toLowerCase().trim().startsWith("<html>")) {
                msg = "<html>" + msg.replace("\n", "<br>\n") + "</html>";
            }
            this.label = new JLabel(msg);
            this.check = new JCheckBox(msgchk);
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)this.label, "Center");
            this.add((Component)this.check, "Last");
        }

        public boolean isCheckSelected() {
            return this.check.isSelected();
        }
    }
}

