/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.windowmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.DefaultActionListenerSupport;
import org.gvsig.tools.swing.impl.windowmanager.DefaultDialogView;

public class DefaultDialog
extends DefaultDialogView
implements Dialog {
    private static final long serialVersionUID = -8823659108133528353L;
    protected JComponent contents;
    protected String header1;
    protected String header2;
    protected String title;
    protected int buttons;
    protected int action;
    protected DefaultActionListenerSupport listeners;
    protected Image icon = null;
    protected Image image = null;
    private WindowManager windowManager = null;
    private boolean autoclose;

    public DefaultDialog(JComponent contents, String title, String header, int buttons) {
        this.contents = contents;
        this.title = title;
        this.buttons = buttons;
        this.action = 2;
        this.listeners = new DefaultActionListenerSupport();
        this.autoclose = true;
        this.initComponents();
        this.setButtons(buttons);
        this.setHeaderLabel(header);
    }

    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public JComponent getContents() {
        return this.contents;
    }

    private void initComponents() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.btnAccept.setText(i18nManager.getTranslation("Accept"));
        this.btnCancel.setText(i18nManager.getTranslation("Cancel"));
        this.btnApply.setText(i18nManager.getTranslation("Apply"));
        this.pnlContents.setLayout(new BorderLayout());
        this.pnlContents.add((Component)this.contents, "Center");
        this.contents.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                DefaultDialog.this.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (ComponentListener l : DefaultDialog.this.contents.getComponentListeners()) {
                    l.componentResized(e);
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                for (ComponentListener l : DefaultDialog.this.contents.getComponentListeners()) {
                    l.componentMoved(e);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                for (ComponentListener l : DefaultDialog.this.contents.getComponentListeners()) {
                    l.componentShown(e);
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                for (ComponentListener l : DefaultDialog.this.contents.getComponentListeners()) {
                    l.componentHidden(e);
                }
            }
        });
        this.btnAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultDialog.this.action = 1;
                if (DefaultDialog.this.autoclose) {
                    DefaultDialog.this.setVisible(false);
                }
                DefaultDialog.this.fireActionEvent(new ActionEvent(DefaultDialog.this, 1, "ok"));
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultDialog.this.action = 2;
                if (DefaultDialog.this.autoclose) {
                    DefaultDialog.this.setVisible(false);
                }
                DefaultDialog.this.fireActionEvent(new ActionEvent(DefaultDialog.this, 2, "cancel"));
            }
        });
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultDialog.this.action = 4;
                DefaultDialog.this.fireActionEvent(new ActionEvent(DefaultDialog.this, 4, "apply"));
            }
        });
    }

    public void setHeaderTitle(String header) {
        this.header1 = header;
        if (this.header1 == null) {
            this.lblHeader1.setText("");
            this.lblHeader1.setVisible(false);
        } else {
            this.lblHeader1.setText(this.header1);
            this.lblHeader1.setVisible(true);
        }
    }

    public void setHeaderLabel(String header) {
        this.header2 = header;
        if (this.header2 == null) {
            this.lblHeader2.setText("");
            this.lblHeader2.setVisible(false);
        } else {
            this.lblHeader2.setText(this.header2);
            this.lblHeader2.setVisible(true);
        }
    }

    public void setContents(JComponent contents) {
        this.contents = contents;
        this.pnlContents.removeAll();
        this.pnlContents.add((Component)this.contents, "Center");
    }

    public int getAction() {
        return this.action;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.addActionListener(listener);
    }

    public ActionListener[] getActionListeners() {
        return this.listeners.getActionListeners();
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.removeActionListener(listener);
    }

    public void removeAllActionListener() {
        this.listeners.removeAllActionListener();
    }

    private void fireActionEvent(ActionEvent event) {
        this.listeners.fireActionEvent(event);
    }

    protected WindowManager getWindowManager() {
        if (this.windowManager == null) {
            this.windowManager = ToolsSwingLocator.getWindowManager();
        }
        return this.windowManager;
    }

    public void show(WindowManager.MODE mode) {
        this.show(mode, null);
    }

    public void show(WindowManager.MODE mode, Map<String, Object> props) {
        WindowManager winmgr = this.getWindowManager();
        if (!(winmgr instanceof WindowManager_v2)) {
            winmgr.showWindow((JComponent)this, this.title, mode);
            return;
        }
        if (this.icon != null) {
            HashMap<String, Object> props2 = new HashMap<String, Object>(props);
            props2.put("icon", this.icon);
            ((WindowManager_v2)winmgr).showWindow((JComponent)this, this.title, mode, props2);
        } else {
            ((WindowManager_v2)winmgr).showWindow((JComponent)this, this.title, mode, props);
        }
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void setHeaderImage(Image image) {
        this.image = image;
    }

    public void setButtons(int buttons) {
        this.buttons = buttons;
        this.btnAccept.setVisible((this.buttons & 1) == 1);
        this.btnCancel.setVisible((this.buttons & 2) == 2);
        this.btnApply.setVisible((this.buttons & 4) == 4);
    }

    public JButton getButton(int button) {
        switch (button) {
            case 4: {
                return this.btnApply;
            }
            case 1: {
                return this.btnAccept;
            }
            case 2: {
                return this.btnCancel;
            }
        }
        throw new IllegalArgumentException("Button number not allowed (button=" + button + ").");
    }

    public void setButtonLabel(int button, String label) {
        this.getButton(button).setText(label);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setButtonEnabled(int button, boolean enabled) {
        this.getButton(button).setEnabled(enabled);
    }

    public boolean isButtonEnabled(int button) {
        return this.getButton(button).isEnabled();
    }

    public void setAutoclose(boolean autoclose) {
        this.autoclose = autoclose;
    }

    public boolean isAutoclose() {
        return this.autoclose;
    }

    public void hideDialog() {
        this.contents.setVisible(false);
    }
}

