/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.impl.DefaultDynFormFieldDefinition;
import org.gvsig.tools.dynform.impl.DefaultDynFormManager;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.DynStruct_v2;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.impl.DefaultTags;

public class DefaultDynFormDefinition
implements DynFormDefinition {
    private DefaultDynFormManager manager = null;
    private List<DynFormFieldDefinition> fieldsDefinitions = null;
    private String name = null;
    private String label = null;
    private Map groupsOrder = null;
    private Tags tags = new DefaultTags();
    private DynStruct elementsType;

    public DefaultDynFormDefinition(String name, DefaultDynFormManager manager) {
        this.name = name;
        this.label = name;
        this.manager = manager;
        this.fieldsDefinitions = new ArrayList<DynFormFieldDefinition>();
        this.groupsOrder = new HashMap();
    }

    public DefaultDynFormDefinition(DynStruct struct, DefaultDynFormManager manager) {
        this(struct.getName(), manager);
        DynField[] fields;
        for (DynField field : fields = struct.getDynFields()) {
            this.add(field);
        }
        if (struct instanceof DynStruct_v2) {
            this.setLabel(((DynStruct_v2)struct).getLabel());
            this.getTags().add(((DynStruct_v2)struct).getTags());
        }
        this.setElementsType(struct);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getGroupOrder(String group) {
        return (Integer)this.groupsOrder.get(group);
    }

    public void setGroupOrder(String group, int order) {
        this.groupsOrder.put(group, new Integer(order));
    }

    public DynFormFieldDefinition add(DynField definition) {
        DefaultDynFormFieldDefinition x = new DefaultDynFormFieldDefinition(this.manager, definition);
        this.fieldsDefinitions.add(x);
        Collections.sort(this.fieldsDefinitions, new Comparator<DynField>(){

            @Override
            public int compare(DynField o1, DynField o2) {
                return o1.getOder() - o2.getOder();
            }
        });
        return x;
    }

    public String getName() {
        return this.name;
    }

    public void add(DynStruct definition) {
        DynField[] fields = definition.getDynFields();
        for (int i = 0; i < fields.length; ++i) {
            this.add(fields[i]);
        }
    }

    public DynFormFieldDefinition get(String name) {
        for (DynFormFieldDefinition def : this.fieldsDefinitions) {
            if (!def.getName().equalsIgnoreCase(name)) continue;
            return def;
        }
        return null;
    }

    public DynFormFieldDefinition get(int index) {
        return this.fieldsDefinitions.get(index);
    }

    public int size() {
        return this.fieldsDefinitions.size();
    }

    public void remove(String name) {
        Iterator<DynFormFieldDefinition> it = this.fieldsDefinitions.iterator();
        while (it.hasNext()) {
            DynFormFieldDefinition def = it.next();
            if (!def.getName().equalsIgnoreCase(name)) continue;
            it.remove();
        }
    }

    public List getGroups() {
        HashSet<String> groups = new HashSet<String>();
        for (DynFormFieldDefinition def : this.fieldsDefinitions) {
            String group = def.getGroup();
            groups.add(group);
            if (this.groupsOrder.containsKey(group)) continue;
            if (StringUtils.isEmpty((CharSequence)group)) {
                this.setGroupOrder(group, -1);
                continue;
            }
            this.setGroupOrder(group, def.getOder());
        }
        ArrayList<String> r = new ArrayList<String>();
        r.addAll(groups);
        Collections.sort(r, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer order1 = (Integer)DefaultDynFormDefinition.this.groupsOrder.get(o1);
                Integer order2 = (Integer)DefaultDynFormDefinition.this.groupsOrder.get(o2);
                return order1.compareTo(order2);
            }
        });
        return r;
    }

    public List getSubgroups(String group) {
        if (group == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet<String> subgroups = new HashSet<String>();
        for (DynFormFieldDefinition def : this.fieldsDefinitions) {
            if (!group.equalsIgnoreCase(def.getGroup())) continue;
            subgroups.add(def.getSubgroup());
        }
        ArrayList<String> r = new ArrayList<String>();
        r.addAll(subgroups);
        Collections.sort(r);
        return r;
    }

    public List getDefinitions() {
        ArrayList<DynFormFieldDefinition> r = new ArrayList<DynFormFieldDefinition>();
        for (DynFormFieldDefinition def : this.fieldsDefinitions) {
            r.add(def);
        }
        Collections.sort(r, new Comparator(){

            public int compare(Object o1, Object o2) {
                DynFormFieldDefinition def1 = (DynFormFieldDefinition)o1;
                DynFormFieldDefinition def2 = (DynFormFieldDefinition)o2;
                if (def1.getOder() == def2.getOder()) {
                    if (def1.getLabel() != null && def2.getLabel() != null) {
                        return def1.getLabel().compareToIgnoreCase(def2.getLabel());
                    }
                    return 0;
                }
                return def1.getOder() > def2.getOder() ? 1 : -1;
            }
        });
        return r;
    }

    public List getDefinitions(String group) {
        ArrayList<DynFormFieldDefinition> r = new ArrayList<DynFormFieldDefinition>();
        for (DynFormFieldDefinition def : this.fieldsDefinitions) {
            if (group == null) {
                if (def.getGroup() != null) continue;
                r.add(def);
                continue;
            }
            if (!group.equalsIgnoreCase(def.getGroup())) continue;
            r.add(def);
        }
        Collections.sort(r, new Comparator(){

            public int compare(Object o1, Object o2) {
                DynFormFieldDefinition def1 = (DynFormFieldDefinition)o1;
                DynFormFieldDefinition def2 = (DynFormFieldDefinition)o2;
                if (def1.getOder() == def2.getOder()) {
                    return ObjectUtils.compare((Comparable)((Object)def1.getLabel()), (Comparable)((Object)def2.getLabel()));
                }
                return def1.getOder() > def2.getOder() ? 1 : -1;
            }
        });
        return r;
    }

    public List getDefinitions(String group, String subgroup) {
        ArrayList<DynFormFieldDefinition> r = new ArrayList<DynFormFieldDefinition>();
        for (DynFormFieldDefinition def : this.fieldsDefinitions) {
            if (!group.equalsIgnoreCase(def.getGroup()) || !subgroup.equalsIgnoreCase(def.getSubgroup())) continue;
            r.add(def);
        }
        Collections.sort(r, new Comparator(){

            public int compare(Object o1, Object o2) {
                DynFormFieldDefinition def1 = (DynFormFieldDefinition)o1;
                DynFormFieldDefinition def2 = (DynFormFieldDefinition)o2;
                if (def1.getOder() == def2.getOder()) {
                    return def1.getLabel().compareToIgnoreCase(def2.getLabel());
                }
                return def1.getOder() > def2.getOder() ? 1 : -1;
            }
        });
        return r;
    }

    public Tags getTags() {
        return this.tags;
    }

    public DynObject createElement() {
        return ToolsLocator.getDynObjectManager().createDynObject(this.elementsType);
    }

    public void setElementsType(DynStruct struct) {
        this.elementsType = struct;
    }

    public DynStruct getElementsType() {
        return this.elementsType;
    }

    public Iterator<DynFormFieldDefinition> iterator() {
        return this.fieldsDefinitions.iterator();
    }
}

