/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.accessories.bookmarks;

import com.googlecode.vfsjfilechooser2.accessories.bookmarks.TitledURLEntry;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

final class BookmarksWriter {
    private Writer writer;

    private void startAttribute(String name, String value) throws IOException {
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write(" =");
        this.writer.write("\"");
        this.writer.write(value);
        this.writer.write("\"");
    }

    private void startTag(String name) throws IOException {
        this.writer.write("<" + name + ">");
    }

    private void startNewLine() throws IOException {
        this.writer.write("\n");
    }

    private void endTag(String tagName) throws IOException {
        this.writer.write("</" + tagName + ">");
    }

    private void writeData(List<TitledURLEntry> entries) throws IOException {
        this.startTag("entries");
        Iterator<TitledURLEntry> it = entries.iterator();
        while (it.hasNext()) {
            TitledURLEntry entry = it.next();
            if (entry == null || entry.getTitle() == null || entry.getTitle().length() == 0) {
                it.remove();
            }
            this.startNewLine();
            this.writer.write("<entry");
            this.startAttribute("title", entry.getTitle());
            this.startAttribute("url", entry.getURL());
            this.writer.write("/>");
        }
        this.startNewLine();
        this.endTag("entries");
    }

    public void writeToFile(List<TitledURLEntry> entries, File bookmarksFile) throws IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        if (entries == null || bookmarksFile == null) {
            throw new NullPointerException();
        }
        String write_type = "b1";
        if (write_type.equals("")) {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(bookmarksFile), "UTF-8"));
            this.writeData(entries);
            this.writer.flush();
            this.writer.close();
        } else if (write_type.equals("b1")) {
            this.writer = new StringWriter();
            this.writeData(entries);
            byte[] out = this.writer.toString().getBytes();
            byte[] raw = new byte[16];
            raw[0] = 1;
            raw[2] = 23;
            raw[3] = 24;
            raw[4] = 2;
            raw[5] = 99;
            raw[6] = -56;
            raw[7] = -54;
            raw[8] = -47;
            raw[9] = -57;
            raw[10] = -75;
            raw[11] = -1;
            raw[12] = 33;
            raw[13] = -46;
            raw[14] = -42;
            raw[15] = -40;
            SecretKeySpec skeyspec = new SecretKeySpec(raw, "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, skeyspec);
            byte[] encrypted = cipher.doFinal(out);
            BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(bookmarksFile), "UTF-8"));
            writer2.write("b1");
            writer2.write(Util.byteArraytoHexString(encrypted));
            writer2.flush();
            writer2.close();
        } else {
            System.out.println("FATAL ERROR -- BookmarksWriter.java  unknown write style");
            System.exit(10);
        }
    }
}

