/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.MessageEvent;
import org.gvsig.andami.messages.NotificationListener;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;

public class ConsolaFrame
extends JPanel
implements IWindow,
SingletonWindow,
NotificationListener {
    private StringBuffer info = new StringBuffer();
    private StringBuffer warn = new StringBuffer();
    private StringBuffer error = new StringBuffer();
    private StringBuffer all = new StringBuffer();
    private JEditorPane textoInfos;
    private JEditorPane textoWarnings;
    private JEditorPane textoErrores;
    private JEditorPane textoAll;
    private static final String marcaInfo = "font size='3' color='#000000'";
    private static final String marcaWarning = "font size='3' color='#800000'";
    private static final String marcaError = "font size='3' color='#FF0000'";
    private JTabbedPane tabs;
    private JPanel panelErrores;

    public ConsolaFrame() {
        this.setSize(400, 325);
        this.textoInfos = new JEditorPane();
        this.textoInfos.setEditable(false);
        this.textoInfos.setContentType("text/html");
        this.textoWarnings = new JEditorPane();
        this.textoWarnings.setEditable(false);
        this.textoWarnings.setContentType("text/html");
        this.textoErrores = new JEditorPane();
        this.textoErrores.setEditable(false);
        this.textoErrores.setContentType("text/html");
        this.textoAll = new JEditorPane();
        this.textoAll.setEditable(false);
        this.textoAll.setContentType("text/html");
        JScrollPane scroll = new JScrollPane(this.textoAll);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(32);
        JPanel panelAll = new JPanel(new BorderLayout());
        panelAll.add((Component)scroll, "Center");
        scroll = new JScrollPane(this.textoInfos);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(32);
        JPanel panelInfos = new JPanel(new BorderLayout());
        panelInfos.add((Component)scroll, "Center");
        scroll = new JScrollPane(this.textoWarnings);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(32);
        JPanel panelWarnings = new JPanel(new BorderLayout());
        panelWarnings.add((Component)scroll, "Center");
        scroll = new JScrollPane(this.textoErrores);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(32);
        this.panelErrores = new JPanel(new BorderLayout());
        this.panelErrores.add((Component)scroll, "Center");
        this.tabs = new JTabbedPane();
        this.tabs.addTab(PluginServices.getText((Object)this, (String)"todos"), panelAll);
        this.tabs.addTab(PluginServices.getText((Object)this, (String)"info"), panelInfos);
        this.tabs.addTab(PluginServices.getText((Object)this, (String)"warnings"), panelWarnings);
        this.tabs.addTab(PluginServices.getText((Object)this, (String)"errores"), this.panelErrores);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
    }

    private void rellenar(String[] contenido, JEditorPane control, StringBuffer buffer, String marca) {
        String content = "";
        for (int i = 0; i < contenido.length; ++i) {
            content = content + "<" + marca + ">" + contenido[i] + "</" + marca + "><br/";
        }
        buffer.append(content);
        control.setContentType("text/html");
        control.setText(content);
    }

    private static String dumpStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        StackTraceElement[] stes = t.getStackTrace();
        String todo = "<font size='3' color='#800000'>" + t.getClass().getName() + ": " + t.getLocalizedMessage() + "<" + marcaWarning + ">" + "<br/";
        for (int i = 0; i < stes.length; ++i) {
            todo = todo + "<font size='3' color='#800000'>&nbsp;&nbsp;&nbsp;&nbsp;" + stes[i].toString() + "<br/";
        }
        if (t.getCause() != null) {
            todo = todo + ConsolaFrame.dumpStackTrace(t.getCause());
        }
        return todo;
    }

    private void recortarbuffers() {
        if (this.error.length() > 61440) {
            this.error.delete(0, 30720);
        }
        if (this.warn.length() > 61440) {
            this.warn.delete(0, 30720);
        }
        if (this.info.length() > 61440) {
            this.info.delete(0, 30720);
        }
        if (this.all.length() > 61440) {
            this.all.delete(0, 30720);
        }
    }

    public void errorEvent(MessageEvent e) {
        for (int i = 0; i < e.getMessages().length; ++i) {
            String traza = ConsolaFrame.dumpStackTrace(e.getExceptions()[i]);
            this.error.append("<font size='3' color='#FF0000'>" + e.getMessages()[i] + "</" + marcaError + "><br/" + traza);
            this.all.append("<font size='3' color='#FF0000'>" + e.getMessages()[i] + "</" + marcaError + "><br/" + traza);
        }
        this.recortarbuffers();
        this.textoErrores.setText(this.error.toString());
        this.textoAll.setText(this.all.toString());
        this.tabs.setSelectedComponent(this.panelErrores);
    }

    public void warningEvent(MessageEvent e) {
        for (int i = 0; i < e.getMessages().length; ++i) {
            String traza = ConsolaFrame.dumpStackTrace(e.getExceptions()[i]);
            this.warn.append("<font size='3' color='#800000'>" + e.getMessages()[i] + "</" + marcaWarning + "><br/" + traza);
            this.all.append("<font size='3' color='#800000'>" + e.getMessages()[i] + "</" + marcaWarning + "><br/" + traza);
        }
        this.recortarbuffers();
        this.textoWarnings.setText(this.warn.toString());
        this.textoAll.setText(this.all.toString());
    }

    public void infoEvent(MessageEvent e) {
        for (int i = 0; i < e.getMessages().length; ++i) {
            String traza = ConsolaFrame.dumpStackTrace(e.getExceptions()[i]);
            this.info.append("<font size='3' color='#000000'>" + e.getMessages()[i] + "</" + marcaInfo + "><br/" + traza);
            this.all.append("<font size='3' color='#000000'>" + e.getMessages()[i] + "</" + marcaInfo + "><br/" + traza);
        }
        this.recortarbuffers();
        this.textoInfos.setText(this.info.toString());
        this.textoAll.setText(this.all.toString());
    }

    public Object getWindowModel() {
        return "consola";
    }

    public WindowInfo getWindowInfo() {
        WindowInfo info = new WindowInfo(23);
        info.setTitle(PluginServices.getText((Object)this, (String)"titulo_consola"));
        return info;
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }
}

