/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.actioninfo.impl;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.andami.actioninfo.ActionInfoStatusCache;
import org.gvsig.andami.plugins.ExtensionHelper;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;

public class DefaultActionInfoStatusCache
implements ActionInfoStatusCache {
    private SimpleIdentityManager identityManager;
    private Map<IExtension, Status> extensions = null;
    private Map<ActionInfo, Status> actions = null;

    public DefaultActionInfoStatusCache() {
        this.clear();
    }

    @Override
    public void clear() {
        this.extensions = new HashMap<IExtension, Status>();
        this.actions = new HashMap<ActionInfo, Status>();
    }

    private SimpleIdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = ToolsLocator.getIdentityManager();
        }
        return this.identityManager;
    }

    private SimpleIdentity getCurrentUser() {
        return this.getIdentityManager().getCurrentIdentity();
    }

    @Override
    public boolean isEnabled(ActionInfo action) {
        Status status;
        if (!this.getCurrentUser().isAuthorized(action.getName())) {
            return false;
        }
        if (this.getActionInfoManager().isAllDisabled()) {
            return false;
        }
        if (!action.isActive()) {
            return false;
        }
        IExtension extension = action.getExtension();
        if (extension == null) {
            return false;
        }
        if (ExtensionHelper.canQueryByAction(extension)) {
            status = this.actions.get(action);
            if (status == null) {
                status = new Status();
                this.actions.put(action, status);
            }
            if (status.isEnabled == null) {
                status.isEnabled = action.isEnabled();
            }
        } else {
            status = this.extensions.get(extension);
            if (status == null) {
                status = new Status();
                this.extensions.put(extension, status);
            }
            if (status.isEnabled == null) {
                status.isEnabled = extension.isEnabled();
            }
        }
        return status.isEnabled;
    }

    @Override
    public boolean isVisible(ActionInfo action) {
        Status status;
        if (!this.getCurrentUser().isAuthorized(action.getName())) {
            return false;
        }
        if (!action.isActive()) {
            return false;
        }
        IExtension extension = action.getExtension();
        if (extension == null) {
            return false;
        }
        if (ExtensionHelper.canQueryByAction(extension)) {
            status = this.actions.get(action);
            if (status == null) {
                status = new Status();
                this.actions.put(action, status);
            }
            if (status.isVisible == null) {
                status.isVisible = action.isVisible();
            }
        } else {
            status = this.extensions.get(extension);
            if (status == null) {
                status = new Status();
                this.extensions.put(extension, status);
            }
            if (status.isVisible == null) {
                status.isVisible = extension.isVisible();
            }
        }
        return status.isVisible;
    }

    private ActionInfoManager getActionInfoManager() {
        return PluginsLocator.getActionInfoManager();
    }

    private class Status {
        Boolean isEnabled = null;
        Boolean isVisible = null;

        private Status() {
        }
    }
}

