/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.help;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.help.HelpSet;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.gvsig.andami.help.AndamiHelpPanel;
import org.gvsig.andami.help.HelpPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Help {
    private static Help help = null;
    private HelpSet mainHS = null;
    private ArrayList resources = new ArrayList();
    private ArrayList helps = new ArrayList();
    private HelpPanel window = null;

    public static Help getHelp() {
        if (help == null) {
            help = new Help();
        }
        return help;
    }

    private Logger log() {
        return LoggerFactory.getLogger((String)"org.gvsig");
    }

    public void show() {
        this.log().info("show()");
        this.show(null);
    }

    public void show(String id) {
        try {
            this.log().info("show(id) id=" + id);
            this.initHelp();
            try {
                this.window.showWindow(id);
            }
            catch (NullPointerException e) {
                this.window = new AndamiHelpPanel(this.mainHS, id);
                this.window.showWindow();
            }
        }
        catch (Exception ex) {
            this.log().error("Se ha producido un error mostrando la ventana de ayuda.", (Throwable)ex);
        }
    }

    public void enableHelp(JComponent comp, String id) {
        try {
            this.initHelp();
            comp.registerKeyboardAction(new DisplayHelpFromFocus(id), KeyStroke.getKeyStroke(112, 0), 1);
        }
        catch (Exception except) {
            this.log().error("ID: " + id + " erronea");
        }
    }

    public boolean addResource(String path) {
        URL url = null;
        try {
            url = new File(path).toURL();
        }
        catch (MalformedURLException e) {
            return false;
        }
        this.resources.add(url);
        return true;
    }

    public boolean addHelp(String helpName) {
        this.helps.add(helpName);
        return true;
    }

    private void initHelp() {
        if (this.mainHS != null) {
            return;
        }
        URL[] urls = new URL[this.resources.size()];
        int i = 0;
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            urls[i++] = (URL)it.next();
        }
        ArrayList<HelpSet> helpSets = new ArrayList<HelpSet>();
        for (String name : this.helps) {
            String lang = Locale.getDefault().getLanguage();
            HelpSet hs = this.createHelpSet(urls, name + "/" + lang + "/help.hs");
            if (hs == null) {
                lang = "en";
                hs = this.createHelpSet(urls, name + "/" + lang + "/help.hs");
            }
            if (hs == null) continue;
            helpSets.add(hs);
        }
        Iterator it2 = helpSets.iterator();
        if (!it2.hasNext()) {
            return;
        }
        this.mainHS = (HelpSet)it2.next();
        while (it2.hasNext()) {
            try {
                this.mainHS.add((HelpSet)it2.next());
            }
            catch (Exception ex) {
                this.log().error(ex.toString());
            }
        }
    }

    private HelpSet createHelpSet(URL[] resources, String hsName) {
        HelpSet hs = null;
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        URL url = HelpSet.findHelpSet((ClassLoader)(loader = new URLClassLoader(resources, loader)), (String)hsName);
        if (url == null) {
            this.log().error(MessageFormat.format("No se ha encontrado el helpset ''{0}''.", hsName));
            return null;
        }
        this.log().info("createHelpSet:  url=" + url);
        try {
            hs = new HelpSet(null, url);
        }
        catch (Exception ex) {
            this.log().error(MessageFormat.format("No se ha podido cargar el helpset desde ''{0}''.", url), (Throwable)ex);
            return null;
        }
        return hs;
    }

    public class DisplayHelpFromFocus
    implements ActionListener {
        private String id = null;

        public DisplayHelpFromFocus(String id) {
            Help.this.log().info("DisplayHelpFromFocus(id) id=" + id);
            this.id = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Help.getHelp().show(this.id);
        }
    }
}

