/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.gvsig.andami.Arguments;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.Utilities;
import org.gvsig.andami.config.generate.AndamiConfig;
import org.gvsig.andami.config.generate.Plugin;
import org.gvsig.andami.firewall.FirewallConfiguration;
import org.gvsig.andami.impl.DesktopApi;
import org.gvsig.andami.impl.UnsavedDataException;
import org.gvsig.andami.plugins.ExclusiveUIExtension;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.plugins.PluginClassLoader;
import org.gvsig.andami.plugins.status.IExtensionStatus;
import org.gvsig.andami.plugins.status.IUnsavedData;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.packageutils.PackageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginsManager
implements PluginsManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultPluginsManager.class);
    private List<File> pluginsFolders = null;
    private List<Task> startupTasks = new ArrayList<Task>();
    private List<Task> shutdownTasks = new ArrayList<Task>();

    @Override
    public ExclusiveUIExtension getExclusiveUIExtension() {
        return PluginServices.getExclusiveUIExtension();
    }

    @Override
    public IExtension getExtension(Class<? extends IExtension> extension) {
        return PluginServices.getExtension(extension);
    }

    @Override
    public IExtension getExtension(String extension) {
        return Launcher.getExtensionByName(extension);
    }

    @Override
    public Iterator<IExtension> getExtensions() {
        return PluginServices.getExtensions();
    }

    @Override
    public PluginServices getPlugin(Class<? extends IExtension> extension) {
        if (!(extension.getClassLoader() instanceof PluginClassLoader)) {
            return null;
        }
        String pluginName = ((PluginClassLoader)extension.getClassLoader()).getPluginName();
        return this.getPlugin(pluginName);
    }

    @Override
    public PluginServices getPlugin(Object obj) {
        if (obj instanceof Extension) {
            return ((Extension)obj).getPlugin();
        }
        if (obj instanceof IExtension) {
            Class<?> klass = obj.getClass();
            return this.getPlugin(klass);
        }
        ClassLoader loader = obj.getClass().getClassLoader();
        if (loader instanceof PluginClassLoader) {
            String pluginName = ((PluginClassLoader)loader).getPluginName();
            return this.getPlugin(pluginName);
        }
        return null;
    }

    @Override
    public PluginServices getPlugin(String pluginName) {
        return Launcher.getPluginServices(pluginName);
    }

    @Override
    public File getPluginHomeFolder(String pluginName) {
        File folder = FileUtils.getFile((File)this.getApplicationHomeFolder(), (String[])new String[]{"plugins", pluginName});
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    @Override
    public PackageInfo getPackageInfo(Class<? extends IExtension> extension) {
        PackageManager pkgmgr = ToolsLocator.getPackageManager();
        File pinfo_file = new File(this.getPlugin(extension).getPluginDirectory(), "package.info");
        org.gvsig.tools.packageutils.PackageInfo packageInfo = null;
        try {
            packageInfo = pkgmgr.createPackageInfo(pinfo_file);
        }
        catch (Exception e) {
            logger.info("Error while reading package info file from " + pinfo_file.toString(), (Throwable)e);
        }
        return packageInfo;
    }

    @Override
    public PackageInfo getPackageInfo(String pluginName) {
        PackageManager pkgmgr = ToolsLocator.getPackageManager();
        File pinfo_file = new File(this.getPlugin(pluginName).getPluginDirectory(), "package.info");
        org.gvsig.tools.packageutils.PackageInfo packageInfo = null;
        try {
            packageInfo = pkgmgr.createPackageInfo(pinfo_file);
        }
        catch (Exception e) {
            logger.info("Error while reading package info file from " + pinfo_file.toString(), (Throwable)e);
        }
        return packageInfo;
    }

    @Override
    public PackageInfo getPackageInfo() {
        PackageManager pkgmgr = ToolsLocator.getPackageManager();
        File pinfo_file = new File(this.getApplicationFolder(), "package.info");
        org.gvsig.tools.packageutils.PackageInfo packageInfo = null;
        try {
            packageInfo = pkgmgr.createPackageInfo(pinfo_file);
        }
        catch (Exception e) {
            logger.info("Error while reading package info file from " + pinfo_file.toString(), (Throwable)e);
        }
        return packageInfo;
    }

    @Override
    public List<PluginServices> getPlugins() {
        ArrayList<PluginServices> pluginServices = new ArrayList<PluginServices>();
        AndamiConfig config = Launcher.getAndamiConfig();
        Enumeration plugins = config.enumeratePlugin();
        while (plugins.hasMoreElements()) {
            Plugin plugin = (Plugin)plugins.nextElement();
            pluginServices.add(PluginServices.getPluginServices(plugin.getName()));
        }
        return pluginServices;
    }

    @Override
    public void setExclusiveUIExtension(ExclusiveUIExtension extension) {
        PluginServices.setExclusiveUIExtension(extension);
    }

    @Override
    public String getText(Object obj, String msg) {
        return PluginServices.getText(obj, msg);
    }

    @Override
    public String translate(String msg) {
        return Messages.translate((String)msg);
    }

    @Override
    public File getApplicationFolder() {
        return Launcher.getApplicationFolder();
    }

    @Override
    public File getPluginsDirectory() {
        return this.getPluginsFolder();
    }

    @Override
    public File getPluginsFolder() {
        List<File> l = this.getPluginsFolders();
        if (l == null || l.size() < 1) {
            return null;
        }
        return l.get(0);
    }

    @Override
    public List<File> getPluginsFolders() {
        if (this.pluginsFolders != null) {
            return this.pluginsFolders;
        }
        String folderPath = "gvSIG/extensiones";
        if (Launcher.getAndamiConfig() != null && Launcher.getAndamiConfig().getPluginsDirectory() != null) {
            folderPath = Launcher.getAndamiConfig().getPluginsDirectory();
        }
        this.pluginsFolders = new ArrayList<File>();
        File folder = new File(this.getApplicationFolder(), folderPath);
        if (!folder.exists()) {
            try {
                FileUtils.forceMkdir((File)folder);
            }
            catch (IOException ex) {
                logger.warn("The plugins folder '" + folder.getAbsolutePath() + "' don't exist and can't create.", (Throwable)ex);
            }
        }
        this.pluginsFolders.add(folder);
        folder = new File(this.getApplicationHomeFolder(), "installation");
        folder = new File(folder, folderPath);
        if (!folder.exists()) {
            try {
                FileUtils.forceMkdir((File)folder);
            }
            catch (IOException ex) {
                logger.warn("The plugins folder '" + folder.getAbsolutePath() + "' don't exist and can't create.", (Throwable)ex);
            }
        }
        this.pluginsFolders.add(folder);
        return this.pluginsFolders;
    }

    @Override
    public File getInstallFolder() {
        return new File(this.getApplicationFolder(), "install");
    }

    @Override
    public File getApplicationHomeFolder() {
        return Launcher.getApplicationHomeFolder();
    }

    @Override
    public void addStartupTask(String name, Runnable task, boolean in_event_thread, int priority) {
        this.startupTasks.add(new Task("startup", name, task, in_event_thread, priority));
    }

    @Override
    public void addShutdownTask(String name, Runnable task, boolean in_event_thread, int priority) {
        this.shutdownTasks.add(new Task("shutdown", name, task, in_event_thread, priority));
    }

    @Override
    public void executeStartupTasks() {
        logger.info("Executing startup tasks.");
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                Task task;
                int i;
                try {
                    Thread.sleep(3L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Collections.sort(DefaultPluginsManager.this.startupTasks);
                for (i = DefaultPluginsManager.this.startupTasks.size() - 1; i >= 0; --i) {
                    task = (Task)DefaultPluginsManager.this.startupTasks.get(i);
                    logger.info("Task [" + i + "] " + task.priority + ", " + task.name + ", in event thread " + task.in_event_thread);
                }
                for (i = DefaultPluginsManager.this.startupTasks.size() - 1; i >= 0; --i) {
                    task = (Task)DefaultPluginsManager.this.startupTasks.get(i);
                    task.run();
                }
                logger.info("Running startup tasks terminated.");
            }
        });
        th.start();
    }

    @Override
    public void executeShutdownTasks() {
        logger.info("Executing shutdown tasks.");
        Collections.sort(this.shutdownTasks);
        for (int i = this.shutdownTasks.size() - 1; i >= 0; --i) {
            Task task = this.shutdownTasks.get(i);
            task.run();
        }
    }

    @Override
    public File getApplicationI18nFolder() {
        return new File(this.getApplicationFolder(), "i18n");
    }

    @Override
    public FirewallConfiguration getFirewallConfiguration() {
        return (FirewallConfiguration)ToolsLocator.getFirewallManager();
    }

    @Override
    public Version getApplicationVersion() {
        PackageInfo pinfo = this.getPackageInfo();
        Version version = pinfo.getVersion();
        return version;
    }

    @Override
    public List<IUnsavedData> getUnsavedData() {
        ArrayList<IUnsavedData> unsavedDatas = new ArrayList<IUnsavedData>();
        Iterator<IExtension> extensions = this.getExtensions();
        while (extensions.hasNext()) {
            IUnsavedData[] unsavedData;
            IExtension extension = extensions.next();
            IExtensionStatus status = extension.getStatus();
            if (status == null || !status.hasUnsavedData() || (unsavedData = status.getUnsavedData()) == null) continue;
            unsavedDatas.addAll(Arrays.asList(unsavedData));
        }
        return unsavedDatas;
    }

    @Override
    public void saveUnsavedData(List<IUnsavedData> unsavedData) throws UnsavedDataException {
        ArrayList<IUnsavedData> errors = new ArrayList<IUnsavedData>();
        for (IUnsavedData itemUnsavedData : unsavedData) {
            try {
                itemUnsavedData.saveData();
            }
            catch (Exception e) {
                errors.add(itemUnsavedData);
                logger.warn("Can't save '" + itemUnsavedData.getResourceName() + "'.", (Throwable)e);
            }
        }
        if (!errors.isEmpty()) {
            throw new UnsavedDataException(errors);
        }
    }

    @Override
    public String getApplicationName() {
        return Launcher.getApplicationName();
    }

    @Override
    public File getTempFolder() {
        return new File(Utilities.TEMPDIRECTORYPATH);
    }

    @Override
    public File getTempFile(String name) {
        return new File(Utilities.TEMPDIRECTORYPATH, name);
    }

    @Override
    public File getTempFile(String name, String sufix) {
        File tempFolder = new File(Utilities.TEMPDIRECTORYPATH);
        if (!tempFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)tempFolder);
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
        }
        long t = new Date().getTime();
        String fname = String.format("%s-%x%x%s", name, t, sufix);
        return new File(tempFolder, fname);
    }

    @Override
    public boolean desktopBrowse(URI uri) {
        return DesktopApi.browse(uri);
    }

    @Override
    public boolean desktopOpen(File file) {
        return DesktopApi.open(file);
    }

    @Override
    public Arguments getArguments() {
        return Launcher.getArguments();
    }

    private class Task
    implements Comparable,
    Runnable {
        private String type = "";
        private Runnable task = null;
        private boolean in_event_thread = false;
        private int priority = 0;
        private String name = null;

        public Task(String type, String name, Runnable task, boolean in_event_thread, int priority) {
            this.type = type;
            this.in_event_thread = in_event_thread;
            this.task = task;
            this.priority = priority;
            this.name = name;
        }

        public int compareTo(Object t) {
            return this.priority - ((Task)t).priority;
        }

        public boolean equals(Object t) {
            return this.compareTo(t) == 0;
        }

        @Override
        public void run() {
            if (this.in_event_thread && !SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Task.this.run();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException ex) {
                    logger.warn("Errors in execution of " + this.type + " task '" + this.name + "'.", (Throwable)ex);
                }
                return;
            }
            logger.info("Running " + this.type + " task '" + this.name + "' (priority " + this.priority + ").");
            try {
                this.task.run();
                logger.info("Terminated " + this.type + " task '" + this.name + "'.");
            }
            catch (Throwable ex) {
                logger.warn("Errors in execution of " + this.type + " task '" + this.name + "'.", ex);
            }
        }
    }
}

