/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.mdiFrame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.messages.Messages;
import org.gvsig.andami.plugins.config.generate.Label;
import org.gvsig.andami.ui.mdiFrame.JMenuItem;
import org.gvsig.gui.beans.controls.IControl;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.task.JTasksStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewStatusBar
extends JPanel {
    private static final long serialVersionUID = 5575549032728844632L;
    private static Logger logger = LoggerFactory.getLogger(NewStatusBar.class);
    private static final int INFO = 0;
    private static final int WARNING = 1;
    private static final int ERROR = 2;
    private JLabel lblIcon = null;
    private JLabel lblTexto = null;
    private boolean contenidoTemporal;
    private String textoAnterior;
    private int estadoAnterior;
    private int estado;
    private JProgressBar progressBar = null;
    private Map<String, JLabel> idLabel = new HashMap<String, JLabel>();
    private int[] widthlabels = null;
    private Map<String, Component> controls = new HashMap<String, Component>();
    private JPanel controlContainer;
    private JTasksStatus tasksStatus = null;
    private Timer messageTimer;
    private String textoCompleto;

    public NewStatusBar() {
        this.initialize();
    }

    private ImageIcon getImageIcon(String iconName) {
        return IconThemeHelper.getImageIcon(iconName);
    }

    private void initialize() {
        BorderLayout mainLayout = new BorderLayout();
        this.setLayout(mainLayout);
        JPanel panelRight = new JPanel(new FlowLayout(2, 1, 0));
        this.controlContainer = new JPanel(new FlowLayout(2, 1, 0));
        panelRight.add(this.controlContainer);
        panelRight.add((Component)this.getTasksStatus());
        this.lblIcon = new JLabel();
        this.lblTexto = new JLabel();
        this.lblTexto.setAlignmentX(0.0f);
        this.lblTexto.setHorizontalAlignment(2);
        this.lblTexto.setHorizontalTextPosition(2);
        this.lblTexto.setVerticalAlignment(0);
        this.lblTexto.setVerticalTextPosition(0);
        this.lblIcon.setText("");
        this.lblTexto.setCursor(new Cursor(12));
        this.lblTexto.setText(Messages.getString("StatusBar.Aplicacion_iniciada"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new BorderLayout(1, 1));
        panelLeft.add((Component)this.lblIcon, "Before");
        panelLeft.add((Component)this.lblTexto, "Center");
        this.add((Component)panelLeft, "Center");
        this.add((Component)panelRight, "East");
        this.buildMesagePopupMenu();
        this.messageTimer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NewStatusBar.this.clearMessage();
                }
                catch (Throwable ex) {
                    logger.info("Can't clear message", ex);
                }
            }
        });
    }

    public void clearMessage() {
        this.textoCompleto = "";
        this.lblTexto.setText("");
        this.lblIcon.setIcon(null);
        this.lblTexto.paintImmediately(this.lblTexto.getVisibleRect());
        this.lblIcon.paintImmediately(this.lblIcon.getVisibleRect());
        this.estado = 0;
    }

    public void message(final String msg, final int messageType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewStatusBar.this.message(msg, messageType);
                }
            });
            return;
        }
        this.messageTimer.stop();
        if (StringUtils.isBlank((CharSequence)msg)) {
            this.clearMessage();
            return;
        }
        switch (messageType) {
            case 0: {
                this.setErrorText(msg);
                break;
            }
            case 2: {
                this.setWarningText(msg);
                break;
            }
            default: {
                this.setInfoText(msg);
            }
        }
        this.lblTexto.paintImmediately(this.lblTexto.getVisibleRect());
        this.lblIcon.paintImmediately(this.lblIcon.getVisibleRect());
        this.messageTimer.start();
    }

    private void buildMesagePopupMenu() {
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("View details");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                switch (NewStatusBar.this.estado) {
                    default: {
                        JOptionPane.showMessageDialog(NewStatusBar.this.lblTexto, NewStatusBar.this.getStatusText(), "", 1);
                        break;
                    }
                    case 1: {
                        JOptionPane.showMessageDialog(NewStatusBar.this.lblTexto, NewStatusBar.this.getStatusText(), "", 2);
                        break;
                    }
                    case 2: {
                        JOptionPane.showMessageDialog(NewStatusBar.this.lblTexto, NewStatusBar.this.getStatusText(), "", 0);
                    }
                }
            }
        });
        menu.add(item);
        item = new JMenuItem("Clear");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewStatusBar.this.clearMessage();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Cancel");
        menu.add(item);
        this.lblTexto.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.isPopupTrigger() || e.getClickCount() == 1) && (StringUtils.isNotBlank((CharSequence)NewStatusBar.this.getStatusText()) || NewStatusBar.this.estado != 0)) {
                    menu.show(NewStatusBar.this.lblTexto, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    public String getStatusText() {
        return this.textoCompleto;
    }

    public void restaurarTexto() {
        this.contenidoTemporal = false;
        if (this.estadoAnterior == -1) {
            return;
        }
        switch (this.estadoAnterior) {
            case 0: {
                this.setInfoText(this.textoAnterior);
                break;
            }
            case 1: {
                this.setWarningText(this.textoAnterior);
                break;
            }
            case 2: {
                this.setErrorText(this.textoAnterior);
            }
        }
        this.estadoAnterior = -1;
        this.textoAnterior = null;
    }

    public void setInfoTextTemporal(final String texto) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewStatusBar.this.setInfoTextTemporal(texto);
                }
            });
            return;
        }
        if (!this.contenidoTemporal) {
            this.textoAnterior = this.getStatusText();
            this.estadoAnterior = this.estado;
            this.contenidoTemporal = true;
        }
        this.estado = 0;
        this.lblIcon.setIcon(this.getImageIcon("statusbar-info"));
        this.lblTexto.setText(texto);
    }

    public void setWarningTextTemporal(final String texto) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewStatusBar.this.setWarningTextTemporal(texto);
                }
            });
            return;
        }
        if (!this.contenidoTemporal) {
            this.estadoAnterior = this.estado;
            this.textoAnterior = this.getStatusText();
            this.contenidoTemporal = true;
        }
        this.estado = 1;
        this.lblIcon.setIcon(this.getImageIcon("statusbar-warning"));
        this.lblTexto.setText(texto);
    }

    public void setErrorTextTemporal(final String texto) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewStatusBar.this.setErrorTextTemporal(texto);
                }
            });
            return;
        }
        if (!this.contenidoTemporal) {
            this.estadoAnterior = this.estado;
            this.textoAnterior = this.getStatusText();
            this.contenidoTemporal = true;
        }
        this.estado = 2;
        this.lblIcon.setIcon(this.getImageIcon("statusbar-error"));
        this.lblTexto.setText(texto);
    }

    public void setInfoText(final String texto) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewStatusBar.this.setInfoText(texto);
                }
            });
            return;
        }
        if (this.contenidoTemporal) {
            this.textoAnterior = texto;
            this.estadoAnterior = 0;
        } else {
            this.textoCompleto = texto;
            this.lblTexto.setText(this.getFirstTextLine(texto));
            this.lblIcon.setIcon(this.getImageIcon("statusbar-info"));
            this.estado = 0;
        }
    }

    private String getFirstTextLine(String text) {
        if (text == null) {
            return null;
        }
        int n = text.indexOf("\n");
        if (n == -1) {
            return text;
        }
        return text.substring(0, n) + "...";
    }

    public void setWarningText(final String texto) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewStatusBar.this.setWarningText(texto);
                }
            });
            return;
        }
        if (this.contenidoTemporal) {
            this.textoAnterior = texto;
            this.estadoAnterior = 1;
        } else {
            this.textoCompleto = texto;
            this.lblTexto.setText(this.getFirstTextLine(texto));
            this.lblIcon.setIcon(this.getImageIcon("statusbar-warning"));
            this.estado = 1;
        }
    }

    public void setErrorText(final String texto) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewStatusBar.this.setErrorText(texto);
                }
            });
            return;
        }
        if (this.contenidoTemporal) {
            this.textoAnterior = texto;
            this.estadoAnterior = 2;
        } else {
            this.textoCompleto = texto;
            this.lblTexto.setText(this.getFirstTextLine(texto));
            this.lblIcon.setIcon(this.getImageIcon("statusbar-error"));
            this.estado = 2;
        }
    }

    public void setProgress(int p) {
        if (p < 100) {
            this.getProgressBar().setValue(p);
            this.getProgressBar().setVisible(true);
        } else {
            this.getProgressBar().setVisible(false);
        }
        this.getProgressBar().repaint();
    }

    public void setLabelSet(Label[] labels) {
        this.removeAllLabels();
        this.idLabel.clear();
        for (int i = 0; i < labels.length; ++i) {
            JLabel lbl = new JLabel();
            lbl.setBorder(BorderFactory.createBevelBorder(1));
            lbl.setName(labels[i].getId());
            this.controlContainer.add(lbl);
            this.idLabel.put(labels[i].getId(), lbl);
        }
        JLabel[] configlabels = this.idLabel.values().toArray(new JLabel[0]);
        this.widthlabels = new int[configlabels.length];
        for (int i = 0; i < labels.length; ++i) {
            this.widthlabels[i] = configlabels[i].getWidth();
        }
        this.validate();
    }

    public void ajustar() {
        if (this.widthlabels == null) {
            return;
        }
        JLabel[] labels = this.idLabel.values().toArray(new JLabel[0]);
        for (int i = 0; i < labels.length; ++i) {
            JLabel label = labels[i];
            if (label.getText().compareTo("") != 0) {
                label.setVisible(true);
                continue;
            }
            label.setVisible(false);
        }
        this.validate();
    }

    private void removeAllLabels() {
        Component[] controlArray = this.controlContainer.getComponents();
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i] == this.lblIcon || controlArray[i] == this.lblTexto || controlArray[i] instanceof IControl || !(controlArray[i] instanceof JLabel)) continue;
            this.controlContainer.remove(controlArray[i]);
        }
    }

    public void setMessage(final String id, final String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewStatusBar.this.setMessage(id, msg);
                }
            });
            return;
        }
        JLabel lbl = this.idLabel.get(id);
        if (lbl != null) {
            Dimension originalPreferredSize = lbl.getPreferredSize();
            lbl.setText(msg);
            lbl.setPreferredSize(null);
            if (lbl.getPreferredSize().width < originalPreferredSize.width) {
                lbl.setPreferredSize(originalPreferredSize);
            }
        } else {
            try {
                IControl control = (IControl)this.controls.get(id);
                if (control != null) {
                    control.setValue((Object)msg);
                }
            }
            catch (ClassCastException ex) {
                logger.debug("no label called " + id);
            }
        }
        this.ajustar();
    }

    public void setControlValue(String id, String value) {
        IControl control = (IControl)this.controls.get(id);
        if (control != null) {
            control.setValue((Object)value);
        } else {
            logger.debug("NewStatusBar -- no control called " + id);
        }
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setVisible(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(50);
        }
        return this.progressBar;
    }

    private JTasksStatus getTasksStatus() {
        if (this.tasksStatus == null) {
            this.tasksStatus = ToolsSwingLocator.getTaskStatusSwingManager().createJTasksStatus();
            this.tasksStatus.setVisible(true);
        }
        return this.tasksStatus;
    }

    public void setFixedLabelWidth(double d) {
        this.lblTexto.setPreferredSize(new Dimension((int)d, this.lblTexto.getHeight()));
    }

    public void addControl(String id, Component control) {
        if (!this.controls.containsKey(control.getName())) {
            this.controls.put(control.getName(), control);
            this.controlContainer.add(control);
        } else {
            logger.debug("NewStatusBar.addControl -- control 'id' already exists" + id);
        }
    }

    public Component removeControl(String id) {
        try {
            Component component = this.controls.get(id);
            this.controlContainer.remove(component);
            this.controls.remove(id);
            return component;
        }
        catch (ClassCastException ex) {
            logger.debug("NewStatusBar.removeControl -- control " + id + "doesn't exist");
            return null;
        }
    }

    public Component getControl(String id) {
        return this.controls.get(id);
    }
}

