/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.demo;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.css.NormalOutput;
import org.fit.cssbox.css.Output;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StyleImport {
    private Document doc;

    public StyleImport(String urlstring) throws IOException, SAXException {
        DefaultDocumentSource docSource = new DefaultDocumentSource(urlstring);
        DefaultDOMSource parser = new DefaultDOMSource(docSource);
        this.doc = ((DOMSource)parser).parse();
        DOMAnalyzer da = new DOMAnalyzer(this.doc, ((DocumentSource)docSource).getURL());
        da.getStyleSheets();
        da.localizeStyles();
        ((DocumentSource)docSource).close();
    }

    public void dumpTo(OutputStream ostream) {
        NormalOutput out = new NormalOutput(this.doc, false);
        ((Output)out).dumpTo(ostream);
    }

    public void dumpTo(PrintWriter writer) {
        NormalOutput out = new NormalOutput(this.doc, false);
        ((Output)out).dumpTo(writer);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: StyleImport <url> <output_file>");
            System.exit(0);
        }
        try {
            StyleImport si = new StyleImport(args[0]);
            FileOutputStream os = new FileOutputStream(args[1]);
            si.dumpTo(os);
            os.close();
            System.out.println("Done.");
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

