/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.JBrowser;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.Images;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DefaultColumnCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel textLabel;
    private JLabel arrowLabel;
    private JBrowser browser;
    protected Icon expandedIcon = null;
    protected Icon selectedExpandedIcon = null;
    protected Icon focusedSelectedExpandedIcon = null;
    protected Icon expandingIcon = null;
    private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Color TRANSPARENT_COLOR = new Color(0, true);

    public DefaultColumnCellRenderer(JBrowser browser) {
        this.browser = browser;
        this.expandedIcon = UIManager.getIcon("Browser.expandedIcon");
        this.selectedExpandedIcon = UIManager.getIcon("Browser.selectedExpandedIcon");
        this.focusedSelectedExpandedIcon = UIManager.getIcon("Browser.focusedSelectedExpandedIcon");
        if (this.expandedIcon == null) {
            BufferedImage[] iconImages = Images.split(Toolkit.getDefaultToolkit().createImage(DefaultColumnCellRenderer.class.getResource("snowleopard/images/Browser.disclosureIcons.png")), 6, true);
            this.expandedIcon = new ImageIcon(iconImages[0]);
            this.selectedExpandedIcon = new ImageIcon(iconImages[4]);
            this.focusedSelectedExpandedIcon = new ImageIcon(iconImages[2]);
        }
        this.setLayout(new BorderLayout());
        this.textLabel = new LabelRenderer();
        this.arrowLabel = new LabelRenderer();
        this.setOpaque(true);
        this.textLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        this.textLabel.setOpaque(false);
        this.arrowLabel.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        this.arrowLabel.setOpaque(false);
        this.add((Component)this.textLabel, "Center");
        this.arrowLabel.setIcon(this.expandedIcon);
        this.add((Component)this.arrowLabel, "East");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color foreground;
        boolean isFocused = QuaquaUtilities.isFocused(list);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            foreground = !isFocused && UIManager.getColor("List.inactiveSelectionForeground") != null ? UIManager.getColor("List.inactiveSelectionForeground") : list.getSelectionForeground();
            this.textLabel.setForeground(foreground);
            this.arrowLabel.setForeground(foreground);
            this.arrowLabel.setIcon(isFocused ? this.focusedSelectedExpandedIcon : this.selectedExpandedIcon);
        } else {
            this.setBackground(TRANSPARENT_COLOR);
            foreground = list.getForeground();
            this.textLabel.setForeground(foreground);
            this.arrowLabel.setForeground(foreground);
            this.arrowLabel.setIcon(this.expandedIcon);
        }
        this.textLabel.setText(value == null ? "null" : value.toString());
        this.arrowLabel.setVisible(!this.browser.getModel().isLeaf(value));
        this.textLabel.setEnabled(list.isEnabled());
        this.textLabel.setFont(list.getFont());
        Border border = UIManager.getBorder(cellHasFocus ? "List.focusCellHighlightBorder" : "List.cellNoFocusBorder");
        if (border == null) {
            border = DEFAULT_NO_FOCUS_BORDER;
        }
        this.setBorder(border);
        return this;
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    private static class LabelRenderer
    extends JLabel {
        private LabelRenderer() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName != null && propertyName.equals("text")) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public static class UIResource
    extends DefaultColumnCellRenderer
    implements javax.swing.plaf.UIResource {
        public UIResource(JBrowser browser) {
            super(browser);
        }
    }
}

