/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaButtonListener;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Fonts;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import javax.swing.text.View;

public class QuaquaCheckBoxUI
extends BasicCheckBoxUI
implements VisuallyLayoutable {
    private static final QuaquaCheckBoxUI checkboxUI = new QuaquaCheckBoxUI();
    private static final PropertyChangeHandler propertyChangeListener = new PropertyChangeHandler();
    private boolean defaults_initialized = false;
    private static Dimension size = new Dimension();
    private static Rectangle viewR = new Rectangle();
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent b) {
        return checkboxUI;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.defaults_initialized = true;
        }
        QuaquaUtilities.installProperty(b, "opaque", UIManager.get("CheckBox.opaque"));
        b.setRequestFocusEnabled(UIManager.getBoolean("CheckBox.requestFocusEnabled"));
        b.setFocusable(UIManager.getBoolean("CheckBox.focusable"));
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new QuaquaButtonListener(b);
    }

    private boolean isSmall(JComponent c) {
        boolean isSmall = QuaquaUtilities.getSizeVariant(c) == QuaquaUtilities.SizeVariant.SMALL;
        return isSmall;
    }

    public Icon getDefaultIcon(JComponent c) {
        switch (QuaquaUtilities.getSizeVariant(c)) {
            default: {
                return UIManager.getIcon("CheckBox.icon");
            }
            case SMALL: {
                return UIManager.getIcon("CheckBox.smallIcon");
            }
            case MINI: 
        }
        return UIManager.getIcon("CheckBox.miniIcon");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Object oldHints = QuaquaUtilities.beginGraphics((Graphics2D)g);
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Insets i = this.getInsets(b, viewInsets);
        size = b.getSize(size);
        QuaquaCheckBoxUI.viewR.x = i.left;
        QuaquaCheckBoxUI.viewR.y = i.top;
        QuaquaCheckBoxUI.viewR.width = QuaquaCheckBoxUI.size.width - (i.right + QuaquaCheckBoxUI.viewR.x);
        QuaquaCheckBoxUI.viewR.height = QuaquaCheckBoxUI.size.height - (i.bottom + QuaquaCheckBoxUI.viewR.y);
        QuaquaCheckBoxUI.iconR.height = 0;
        QuaquaCheckBoxUI.iconR.width = 0;
        QuaquaCheckBoxUI.iconR.y = 0;
        QuaquaCheckBoxUI.iconR.x = 0;
        QuaquaCheckBoxUI.textR.height = 0;
        QuaquaCheckBoxUI.textR.width = 0;
        QuaquaCheckBoxUI.textR.y = 0;
        QuaquaCheckBoxUI.textR.x = 0;
        Icon altIcon = b.getIcon();
        Object selectedIcon = null;
        Object disabledIcon = null;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(c), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, b.getText() == null ? 0 : Methods.invokeGetter((Object)b, "getIconTextGap", 4));
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, QuaquaCheckBoxUI.size.width, QuaquaCheckBoxUI.size.height);
        }
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, QuaquaCheckBoxUI.iconR.x, QuaquaCheckBoxUI.iconR.y);
        } else {
            Icon defaultIcon = this.getDefaultIcon(c);
            if (defaultIcon != null) {
                defaultIcon.paintIcon(c, g, QuaquaCheckBoxUI.iconR.x, QuaquaCheckBoxUI.iconR.y);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textR);
            } else {
                this.paintText(g, b, textR, text);
                if (b.hasFocus() && b.isFocusPainted() && QuaquaCheckBoxUI.textR.width > 0 && QuaquaCheckBoxUI.textR.height > 0) {
                    this.paintFocus(g, textR, size);
                }
            }
        }
        QuaquaUtilities.endGraphics((Graphics2D)g, oldHints);
        Debug.paint(g, c, this);
    }

    @Override
    protected void paintFocus(Graphics g, Rectangle textRect, Dimension size) {
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = Methods.invokeGetter((Object)b, "getDisplayedMnemonicIndex", -1);
        String style = (String)b.getClientProperty("Quaqua.Label.style");
        if (style != null && style.equals("shadow") && model.isEnabled()) {
            g.setColor(UIManager.getColor("Label.shadowForeground"));
            QuaquaUtilities.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset() + 1);
        }
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
        } else {
            Color c = UIManager.getColor("CheckBox.disabledForeground");
            g.setColor(c != null ? c : b.getForeground());
        }
        QuaquaUtilities.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = this.getDefaultIcon(c);
        }
        Font font = b.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        QuaquaCheckBoxUI.viewR.y = 0;
        QuaquaCheckBoxUI.viewR.x = 0;
        QuaquaCheckBoxUI.viewR.width = Short.MAX_VALUE;
        QuaquaCheckBoxUI.viewR.height = Short.MAX_VALUE;
        QuaquaCheckBoxUI.iconR.height = 0;
        QuaquaCheckBoxUI.iconR.width = 0;
        QuaquaCheckBoxUI.iconR.y = 0;
        QuaquaCheckBoxUI.iconR.x = 0;
        QuaquaCheckBoxUI.textR.height = 0;
        QuaquaCheckBoxUI.textR.width = 0;
        QuaquaCheckBoxUI.textR.y = 0;
        QuaquaCheckBoxUI.textR.x = 0;
        SwingUtilities.layoutCompoundLabel(c, fm, text, buttonIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : Methods.invokeGetter((Object)b, "getIconTextGap", 4));
        int x1 = Math.min(QuaquaCheckBoxUI.iconR.x, QuaquaCheckBoxUI.textR.x);
        int x2 = Math.max(QuaquaCheckBoxUI.iconR.x + QuaquaCheckBoxUI.iconR.width, QuaquaCheckBoxUI.textR.x + QuaquaCheckBoxUI.textR.width);
        int y1 = Math.min(QuaquaCheckBoxUI.iconR.y, QuaquaCheckBoxUI.textR.y);
        int y2 = Math.max(QuaquaCheckBoxUI.iconR.y + QuaquaCheckBoxUI.iconR.height, QuaquaCheckBoxUI.textR.y + QuaquaCheckBoxUI.textR.height);
        int width = x2 - x1;
        int height = y2 - y1;
        viewInsets = this.getInsets(b, viewInsets);
        return new Dimension(width += QuaquaCheckBoxUI.viewInsets.left + QuaquaCheckBoxUI.viewInsets.right, height += QuaquaCheckBoxUI.viewInsets.top + QuaquaCheckBoxUI.viewInsets.bottom);
    }

    private Insets getInsets(AbstractButton b, Insets i) {
        i = b.getInsets(i);
        if (UIManager.getBoolean("CheckBox.enforceVisualMargin")) {
            Insets vmargin = UIManager.getInsets("Component.visualMargin");
            i.left = Math.max(i.left, vmargin.left);
            i.top = Math.max(i.top, vmargin.top);
            i.bottom = Math.max(i.bottom, vmargin.bottom);
            i.right = Math.max(i.right, vmargin.right);
        }
        return i;
    }

    protected String layoutCL(AbstractButton c, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return QuaquaUtilities.layoutCompoundLabel(c, fontMetrics, text, icon, c.getVerticalAlignment(), c.getHorizontalAlignment(), c.getVerticalTextPosition(), c.getHorizontalTextPosition(), viewR, iconR, textR, Methods.invokeGetter((Object)c, "getIconTextGap", 4));
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        Rectangle vb = this.getVisualBounds(c, 2, width, height);
        return vb == null ? -1 : vb.y + vb.height;
    }

    @Override
    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Icon icon;
        Rectangle rect = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return rect;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon icon2 = icon = b.isEnabled() ? b.getIcon() : b.getDisabledIcon();
        if (icon == null) {
            icon = this.getDefaultIcon(b);
        }
        if (icon == null && text == null) {
            return rect;
        }
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets insets = this.getInsets(b, viewInsets);
        QuaquaCheckBoxUI.viewR.x = insets.left;
        QuaquaCheckBoxUI.viewR.y = insets.top;
        QuaquaCheckBoxUI.viewR.width = width - (insets.left + insets.right);
        QuaquaCheckBoxUI.viewR.height = height - (insets.top + insets.bottom);
        QuaquaCheckBoxUI.iconR.height = 0;
        QuaquaCheckBoxUI.iconR.width = 0;
        QuaquaCheckBoxUI.iconR.y = 0;
        QuaquaCheckBoxUI.iconR.x = 0;
        QuaquaCheckBoxUI.textR.height = 0;
        QuaquaCheckBoxUI.textR.width = 0;
        QuaquaCheckBoxUI.textR.y = 0;
        QuaquaCheckBoxUI.textR.x = 0;
        String clippedText = this.layoutCL(b, fm, text, icon, viewR, iconR, textR);
        Rectangle textBounds = Fonts.getPerceivedBounds(text, c.getFont(), c);
        int ascent = fm.getAscent();
        QuaquaCheckBoxUI.textR.y += ascent + textBounds.y;
        QuaquaCheckBoxUI.textR.height = textBounds.height;
        switch (type) {
            case 1: {
                rect = textR.union(iconR);
                break;
            }
            case 2: {
                rect.setBounds(textR);
            }
        }
        return rect;
    }

    public static class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            AbstractButton src = (AbstractButton)evt.getSource();
            if (name.equals("Frame.active") && src.isSelected()) {
                src.repaint();
            } else if (name.equals("JComponent.sizeVariant")) {
                QuaquaUtilities.applySizeVariant(src);
            }
        }
    }
}

