/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class QuaquaDragGestureRecognizer
implements MouseListener,
MouseMotionListener {
    private MouseEvent dndArmedEvent = null;

    private static int getMotionThreshold() {
        return 5;
    }

    public static boolean exceedsMotionTreshold(MouseEvent a, MouseEvent b) {
        if (a == null || b == null) {
            return true;
        }
        int dx = Math.abs(a.getX() - b.getX());
        int dy = Math.abs(a.getY() - b.getY());
        int tr2 = QuaquaDragGestureRecognizer.getMotionThreshold() * QuaquaDragGestureRecognizer.getMotionThreshold();
        return dx * dx > tr2 || dy * dy > tr2;
    }

    public static boolean exceedsCheckTreshold(MouseEvent a, MouseEvent b) {
        if (a == null || b == null) {
            return true;
        }
        int dx = Math.abs(a.getX() - b.getX());
        int dy = Math.abs(a.getY() - b.getY());
        int tr2 = QuaquaDragGestureRecognizer.getMotionThreshold() * QuaquaDragGestureRecognizer.getMotionThreshold();
        return dx * dx > tr2 || dy * dy > tr2;
    }

    protected int mapDragOperationFromModifiers(MouseEvent e) {
        int mods = e.getModifiersEx();
        if ((mods & 0x400) != 1024) {
            return 0;
        }
        JComponent c = this.getComponent(e);
        TransferHandler th = c.getTransferHandler();
        return QuaquaDragGestureRecognizer.convertModifiersToDropAction(mods, th.getSourceActions(c));
    }

    private static int convertModifiersToDropAction(int mods, int sourceActions) {
        int modifierMask = 960;
        if ((mods & modifierMask | 0x40) == 64) {
            if ((sourceActions & 2) != 0) {
                return 2;
            }
            return sourceActions & 1;
        }
        if ((mods & modifierMask) == 512) {
            return sourceActions & 1;
        }
        if ((mods & modifierMask) == 768) {
            return sourceActions & 0x40000000;
        }
        return 0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dndArmedEvent = null;
        if (this.isDragPossible(e) && this.mapDragOperationFromModifiers(e) != 0) {
            this.dndArmedEvent = e;
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dndArmedEvent = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dndArmedEvent != null) {
            e.consume();
            int action = this.mapDragOperationFromModifiers(e);
            if (action == 0) {
                return;
            }
            if (QuaquaDragGestureRecognizer.exceedsMotionTreshold(this.dndArmedEvent, e)) {
                JComponent c = this.getComponent(e);
                TransferHandler th = c.getTransferHandler();
                th.exportAsDrag(c, this.dndArmedEvent, action);
                this.dndArmedEvent = null;
            }
            if (QuaquaDragGestureRecognizer.exceedsCheckTreshold(this.dndArmedEvent, e)) {
                this.dndArmedEvent = null;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private TransferHandler getTransferHandler(MouseEvent e) {
        JComponent c = this.getComponent(e);
        return c == null ? null : c.getTransferHandler();
    }

    protected boolean isDragPossible(MouseEvent e) {
        JComponent c = this.getComponent(e);
        return c == null ? true : c.getTransferHandler() != null;
    }

    protected JComponent getComponent(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof JComponent) {
            JComponent c = (JComponent)src;
            return c;
        }
        return null;
    }
}

