/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import java.io.File;

public class WindowsFileSystemView
extends QuaquaFileSystemView {
    private File computer = new File("\\");
    private File volumesFolder;
    private File desktop;
    private File systemVolume = new File("C:\\");
    private static final boolean DEBUG = false;

    public WindowsFileSystemView() {
        this.volumesFolder = this.getParentDirectory(this.systemVolume);
        this.desktop = new File(this.systemVolume, "WINDOWS\\Desktop");
    }

    @Override
    public File getComputer() {
        return this.computer;
    }

    @Override
    public File getSystemVolume() {
        return this.volumesFolder;
    }

    public File getDesktop() {
        return this.desktop;
    }

    @Override
    public File[] getRoots() {
        return this.getFiles(this.volumesFolder, true);
    }

    @Override
    public boolean isParent(File folder, File file) {
        return this.target.isParent(folder, file);
    }

    @Override
    public File getChild(File parent, String fileName) {
        return this.target.getChild(parent, fileName);
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        return this.target.isFileSystemRoot(dir);
    }

    @Override
    public File getHomeDirectory() {
        return this.target.getHomeDirectory();
    }

    @Override
    public File getDefaultDirectory() {
        return this.target.getDefaultDirectory();
    }

    @Override
    public boolean isRoot(File f) {
        if (f == null || !f.isAbsolute()) {
            return false;
        }
        if (f.equals(this.computer)) {
            return true;
        }
        File[] roots = this.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!roots[i].equals(f)) continue;
            return true;
        }
        return false;
    }
}

