/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.leopard.filechooser;

import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class DarwinLeopardFileSystemView
extends QuaquaFileSystemView {
    private static final File volumesFolder = new File("/Volumes");
    private static final File networkFolder = new File("/Network");
    private static final File computer = new File("/");
    private static File systemVolume;
    private static final HashSet hiddenTopLevelNames;

    @Override
    public File getComputer() {
        return computer;
    }

    @Override
    public File getSystemVolume() {
        if (systemVolume == null) {
            File[] volumes = volumesFolder.listFiles();
            File sys = null;
            for (int i = 0; i < volumes.length; ++i) {
                try {
                    if (!volumes[i].getCanonicalFile().equals(computer)) continue;
                    sys = volumes[i];
                    break;
                }
                catch (IOException e) {
                    continue;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            systemVolume = sys == null ? computer : sys;
        }
        return systemVolume;
    }

    @Override
    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    @Override
    public File getChild(File parent, String fileName) {
        return new File(parent, fileName);
    }

    @Override
    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    static {
        hiddenTopLevelNames = new HashSet();
        String[] names = new String[]{"AppleShare PDS", "automount", "bin", "Cleanup At Startup", "cores", "Desktop DB", "Desktop DF", "dev", "etc", "home", "mach", "mach_kernel", "mach_kernel.ctfsys", "mach.sym", "net", "opt", "private", "sbin", "Temporary Items", "TheVolumeSettingsFolder", "TheFindByContentFolder", "tmp", "Trash", "usr", "var", "Volumes", "\u0003\u0002\u0001Move&Rename"};
        hiddenTopLevelNames.addAll(Arrays.asList(names));
    }
}

