/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.lion;

import ch.randelshofer.quaqua.BrowserPreviewRenderer;
import ch.randelshofer.quaqua.JBrowser;
import ch.randelshofer.quaqua.QuaquaLabelUI;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaTreeUI;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.FileSystemTreeModel;
import ch.randelshofer.quaqua.filechooser.FileTransferHandler;
import ch.randelshofer.quaqua.filechooser.FilenameDocument;
import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import ch.randelshofer.quaqua.filechooser.SubtreeFileChooserUI;
import ch.randelshofer.quaqua.filechooser.SubtreeTreeModel;
import ch.randelshofer.quaqua.leopard.filechooser.LeopardFileRenderer;
import ch.randelshofer.quaqua.lion.filechooser.SidebarTreeModel;
import ch.randelshofer.quaqua.panther.filechooser.FilePreview;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class QuaquaLionFileChooserUI
extends BasicFileChooserUI
implements SubtreeFileChooserUI {
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FileView fileView;
    private FilterComboBoxModel filterComboBoxModel;
    private FileSystemTreeModel model = null;
    private SubtreeTreeModel subtreeModel = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private String newFolderButtonText = null;
    private String newFolderToolTipText = null;
    protected String chooseButtonText = null;
    private String newFolderDialogPrompt;
    private String newFolderDefaultName;
    private String newFolderErrorText;
    private String newFolderExistsErrorText;
    private String newFolderTitleText;
    private static final File computer = FileSystemTreeModel.COMPUTER;
    private SidebarTreeModel sidebarTreeModel;
    private AncestorListener ancestorListener;
    private FileTransferHandler fileTransferHandler;
    private Action newFolderAction = new NewFolderAction();
    private Action approveSelectionAction = new QuaquaApproveSelectionAction();
    private int isAdjusting = 0;
    private KeyStroke[] KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(65, 5), KeyStroke.getKeyStroke(67, 5), KeyStroke.getKeyStroke(68, 4), KeyStroke.getKeyStroke(68, 5), KeyStroke.getKeyStroke(71, 5), KeyStroke.getKeyStroke(72, 5), KeyStroke.getKeyStroke(73, 5), KeyStroke.getKeyStroke(75, 5), KeyStroke.getKeyStroke(85, 5), KeyStroke.getKeyStroke(192, 0), KeyStroke.getKeyStroke(47, 0)};
    private AbstractAction keyListenerAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            File file = null;
            switch (ae.getActionCommand().charAt(0)) {
                case 'd': {
                    file = new File(System.getProperty("user.home") + "/Desktop");
                    break;
                }
                case 'c': {
                    file = new File("/");
                    break;
                }
                case 'h': {
                    file = new File(System.getProperty("user.home"));
                    break;
                }
                case 'k': {
                    file = new File("/Network");
                    break;
                }
                case 'i': {
                    file = null;
                    return;
                }
                case 'a': {
                    file = new File("/Applications");
                    break;
                }
                case '/': 
                case 'g': {
                    file = null;
                    return;
                }
            }
            if (file != null) {
                QuaquaLionFileChooserUI.this.getFileChooser().setSelectedFile(file);
            }
        }
    };
    private JPanel accessoryPanel;
    private JButton approveButton;
    private JBrowser browser;
    private JScrollPane browserScrollPane;
    private JPanel cancelOpenPanel;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JPanel controlsPanel;
    private JComboBox directoryComboBox;
    private JLabel fileNameLabel;
    private JPanel fileNamePanel;
    private JPanel fileNameSpringPanel;
    private JTextField fileNameTextField;
    private JLabel filesOfTypeLabel;
    private JComboBox filterComboBox;
    private JPanel formatPanel;
    private JPanel formatSpringPanel;
    private JPanel mainPanel;
    private JPanel navigationButtonsPanel;
    private JPanel navigationPanel;
    private JPanel navigationSpringPanel;
    private JButton newFolderButton;
    private JSeparator separator;
    private JSplitPane splitPane;
    private JPanel viewsPanel;
    private JTree sidebarTree;
    private JScrollPane sidebarScrollPane;
    static final int space = 10;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaLionFileChooserUI((JFileChooser)c);
    }

    public QuaquaLionFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        this.sidebarTree = new JTree(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 10;
                return d;
            }
        };
        this.fileNamePanel = new JPanel();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.fileNameSpringPanel = new JPanel();
        this.separator = new JSeparator();
        this.mainPanel = new JPanel();
        this.navigationPanel = new JPanel();
        this.navigationButtonsPanel = new JPanel();
        this.directoryComboBox = new JComboBox();
        this.navigationSpringPanel = new JPanel();
        this.splitPane = new JSplitPane();
        this.sidebarScrollPane = new JScrollPane();
        this.viewsPanel = new JPanel();
        this.browserScrollPane = new JScrollPane();
        this.browser = new JBrowser();
        this.controlsPanel = new JPanel();
        this.accessoryPanel = new JPanel();
        this.formatPanel = new JPanel();
        this.filesOfTypeLabel = new JLabel();
        this.filterComboBox = new JComboBox();
        this.formatSpringPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.newFolderButton = new JButton();
        this.cancelOpenPanel = new JPanel();
        this.cancelButton = new JButton();
        this.approveButton = new JButton();
        fc.setLayout(new BorderLayout());
        fc.setBorder(BorderFactory.createEmptyBorder(6, 0, 10, 0));
        this.fileNamePanel.setLayout(new GridBagLayout());
        this.fileNamePanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 1, 0));
        this.fileNameLabel.setHorizontalAlignment(4);
        this.fileNameLabel.setText("Save As:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(7, 0, 0, 6);
        this.fileNamePanel.add((Component)this.fileNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.fileNamePanel.add((Component)this.fileNameTextField, gridBagConstraints);
        this.fileNameSpringPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.fileNamePanel.add((Component)this.fileNameSpringPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.fileNamePanel.add((Component)this.separator, gridBagConstraints);
        fc.add((Component)this.fileNamePanel, "North");
        this.mainPanel.setLayout(new BorderLayout());
        this.navigationPanel.setLayout(new GridBagLayout());
        this.navigationPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 4, 8));
        this.navigationButtonsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.navigationPanel.add((Component)this.navigationButtonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.navigationPanel.add((Component)this.directoryComboBox, gridBagConstraints);
        this.navigationSpringPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.navigationPanel.add((Component)this.navigationSpringPanel, gridBagConstraints);
        this.mainPanel.add((Component)this.navigationPanel, "North");
        this.splitPane.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, new Color(153, 153, 153)));
        this.splitPane.setDividerLocation(134);
        this.splitPane.setDividerSize(1);
        if (UIManager.getColor("FileChooser.splitPaneBackground") != null) {
            this.splitPane.setBackground(UIManager.getColor("FileChooser.splitPaneBackground"));
        }
        this.splitPane.setContinuousLayout(true);
        this.sidebarScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sidebarScrollPane.setHorizontalScrollBarPolicy(31);
        this.sidebarTree.setRootVisible(false);
        this.sidebarTree.setShowsRootHandles(true);
        this.sidebarScrollPane.setViewportView(this.sidebarTree);
        this.splitPane.setLeftComponent(this.sidebarScrollPane);
        this.viewsPanel.setLayout(new CardLayout());
        this.browserScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.browserScrollPane.setViewportView(this.browser);
        this.viewsPanel.add((Component)this.browserScrollPane, "browser");
        this.splitPane.setRightComponent(this.viewsPanel);
        this.mainPanel.add((Component)this.splitPane, "Center");
        fc.add((Component)this.mainPanel, "Center");
        this.controlsPanel.setLayout(new BoxLayout(this.controlsPanel, 1));
        this.accessoryPanel.setLayout(new BorderLayout());
        this.accessoryPanel.setBorder(BorderFactory.createEmptyBorder(6, 8, 0, 8));
        this.controlsPanel.add(this.accessoryPanel);
        this.formatPanel.setLayout(new GridBagLayout());
        this.formatPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.filesOfTypeLabel.setHorizontalAlignment(4);
        this.filesOfTypeLabel.setText("Format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.formatPanel.add((Component)this.filesOfTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 250;
        this.formatPanel.add((Component)this.filterComboBox, gridBagConstraints);
        this.formatSpringPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.formatPanel.add((Component)this.formatSpringPanel, gridBagConstraints);
        this.controlsPanel.add(this.formatPanel);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(6, 20, 0, 20));
        this.newFolderButton.setText("New Folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.buttonsPanel.add((Component)this.newFolderButton, gridBagConstraints);
        this.cancelOpenPanel.setLayout(new GridLayout(1, 0, 8, 0));
        this.cancelButton.setText("Cancel");
        this.cancelOpenPanel.add(this.cancelButton);
        this.approveButton.setText("Open");
        this.cancelOpenPanel.add(this.approveButton);
        this.buttonsPanel.add((Component)this.cancelOpenPanel, new GridBagConstraints());
        this.controlsPanel.add(this.buttonsPanel);
        fc.add((Component)this.controlsPanel, "South");
        int dividerSize = UIManager.getInt("FileChooser.splitPaneDividerSize");
        if (dividerSize != 0) {
            this.splitPane.setDividerSize(dividerSize);
        }
        this.splitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        this.separator.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 0, 3, 0));
        if (UIManager.getBoolean("FileChooser.enforceQuaquaTreeUI")) {
            this.sidebarTree.setUI((TreeUI)QuaquaTreeUI.createUI(this.sidebarTree));
        }
        this.sidebarTree.putClientProperty("Quaqua.Tree.style", "sideBar");
        this.sidebarTree.setRequestFocusEnabled(false);
        this.sidebarTree.getSelectionModel().setSelectionMode(1);
        int h = this.fileNameLabel.getPreferredSize().height;
        this.fileNameLabel.setMinimumSize(new Dimension(0, h));
        this.fileNameLabel.setPreferredSize(new Dimension(0, h));
        this.fileNameLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.fileNameTextField.getPreferredSize().height;
        this.fileNameTextField.setPreferredSize(new Dimension(0, h));
        this.fileNameTextField.setMinimumSize(new Dimension(0, h));
        this.fileNameTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.directoryComboBox.getPreferredSize().height;
        this.directoryComboBox.setPreferredSize(new Dimension(0, h));
        this.directoryComboBox.setMinimumSize(new Dimension(0, h));
        this.directoryComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        Dimension d = new Dimension(28, 25);
        Dimension d2 = new Dimension(29, 25);
        h = this.navigationButtonsPanel.getPreferredSize().height;
        this.navigationButtonsPanel.setMinimumSize(new Dimension(0, h));
        this.navigationButtonsPanel.setPreferredSize(new Dimension(0, h));
        this.navigationButtonsPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.filesOfTypeLabel.getPreferredSize().height;
        this.filesOfTypeLabel.setMinimumSize(new Dimension(0, h));
        this.filesOfTypeLabel.setPreferredSize(new Dimension(0, h));
        this.filesOfTypeLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.filterComboBox.getPreferredSize().height;
        this.filterComboBox.setPreferredSize(new Dimension(0, h));
        this.filterComboBox.setMinimumSize(new Dimension(0, h));
        this.filterComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        LeopardFileRenderer fileRenderer = new LeopardFileRenderer(fc, UIManager.getIcon("Browser.expandingIcon"), UIManager.getIcon("Browser.expandedIcon"), UIManager.getIcon("Browser.selectedExpandingIcon"), UIManager.getIcon("Browser.selectedExpandedIcon"), UIManager.getIcon("Browser.focusedSelectedExpandingIcon"), UIManager.getIcon("Browser.focusedSelectedExpandedIcon"));
        this.browser.setColumnCellRenderer(fileRenderer);
        if (fc.isMultiSelectionEnabled()) {
            this.browser.setSelectionMode(4);
        } else {
            this.browser.setSelectionMode(1);
        }
        this.browser.setModel(this.getTreeModel());
        this.browser.setPrototypeCellValue(this.getFileSystemTreeModel().getPrototypeValue());
        this.browser.addTreeSelectionListener(this.createBrowserSelectionListener(fc));
        this.browser.addMouseListener(this.createDoubleClickListener(fc));
        this.browser.setFixedCellWidth(170);
        this.browserScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 2, 3, 2));
        this.browser.setShowCellTipOrigin((Point)UIManager.get("FileChooser.cellTipOrigin"));
        this.browser.setShowCellTips(true);
        this.sidebarScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 2, 3, 2));
        this.formatPanel.setVisible(fc.getChoosableFileFilters().length > 1);
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        } else {
            this.accessoryPanel.setVisible(false);
        }
        this.separator.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 0, 3, 0));
        this.newFolderButton.setText(this.newFolderButtonText);
        this.newFolderButton.setToolTipText(this.newFolderToolTipText);
        this.fileNameLabel.setText(this.fileNameLabelText);
        this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        if (!fc.getControlButtonsAreShown()) {
            this.cancelButton.setVisible(false);
            this.approveButton.setVisible(false);
        }
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.sidebarTreeModel = new SidebarTreeModel(fc, new TreePath(this.getFileSystemTreeModel().getRoot()), this.getFileSystemTreeModel());
        this.sidebarTree.setModel(this.sidebarTreeModel);
        this.sidebarTree.setCellRenderer(this.createSidebarCellRenderer(fc));
        for (int i = this.sidebarTree.getRowCount() - 1; i >= 0; --i) {
            this.sidebarTree.expandRow(i);
        }
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.filterComboBox.setModel(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.newFolderButton.addActionListener(this.getNewFolderAction());
        this.fileNameTextField.addFocusListener(new SaveTextFocusListener());
        this.fileNameTextField.setDocument(new FilenameDocument());
        this.fileNameTextField.getDocument().addDocumentListener(new SaveTextDocumentListener());
        this.fileNameTextField.addActionListener(this.getApproveSelectionAction());
        this.sidebarTree.addTreeSelectionListener(this.createSidebarSelectionListener(fc));
        this.browserScrollPane.setFocusable(false);
        this.browserScrollPane.getVerticalScrollBar().setFocusable(false);
        this.browserScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.sidebarScrollPane.setFocusable(false);
        this.sidebarScrollPane.getVerticalScrollBar().setFocusable(false);
        this.sidebarScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.fileTransferHandler = new FileTransferHandler(fc);
        Component[] dropComponents = new Component[]{fc, this.accessoryPanel, this.approveButton, this.browser, this.browserScrollPane, this.buttonsPanel, this.cancelButton, this.controlsPanel, this.directoryComboBox, this.fileNameLabel, this.fileNamePanel, this.fileNameSpringPanel, this.fileNameTextField, this.filesOfTypeLabel, this.filterComboBox, this.formatPanel, this.formatSpringPanel, this.mainPanel, this.navigationButtonsPanel, this.navigationPanel, this.navigationSpringPanel, this.newFolderButton, this.separator, this.splitPane, this.viewsPanel, this.sidebarTree, this.sidebarScrollPane};
        for (int i = 0; i < dropComponents.length; ++i) {
            new DropTarget(dropComponents[i], 1, this.fileTransferHandler);
        }
        boolean isSave = fc.getDialogType() == 1 || fc.getDialogType() == 2;
        this.fileNameTextField.setEnabled(isSave);
        this.fileNamePanel.setVisible(isSave);
        this.doPreviewComponentChanged(null);
        this.updateApproveButtonState();
        this.splitPane.setPreferredSize(new Dimension(518, 298));
        this.splitPane.setMinimumSize(new Dimension(400, 80));
        ActionMap am = this.mainPanel.getActionMap();
        InputMap im = this.mainPanel.getInputMap(2);
        for (int i = 0; i < this.KEYSTROKES.length; ++i) {
            im.put(this.KEYSTROKES[i], this.KEYSTROKES[i]);
            am.put(this.KEYSTROKES[i], this.keyListenerAction);
        }
        this.controlsPanel.setActionMap(am);
        this.controlsPanel.setInputMap(2, im);
        this.fileNamePanel.setActionMap(am);
        this.fileNamePanel.setInputMap(2, im);
        Dimension ps = fc.getPreferredSize();
        fc.setBounds(0, 0, ps.width, ps.height);
        fc.doLayout();
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.model.dispose();
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.ancestorListener = this.createAncestorListener(fc);
        if (this.ancestorListener != null) {
            fc.addAncestorListener(this.ancestorListener);
        }
        fc.addPropertyChangeListener(this.filterComboBoxModel);
    }

    @Override
    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        if (this.ancestorListener != null) {
            fc.removeAncestorListener(this.ancestorListener);
        }
        fc.removePropertyChangeListener(this.filterComboBoxModel);
    }

    private Locale getLocale() {
        try {
            return this.getFileChooser().getLocale();
        }
        catch (IllegalComponentStateException e) {
            return Locale.getDefault();
        }
    }

    @Override
    protected void installDefaults(JFileChooser fc) {
        super.installDefaults(fc);
        Object value = UIManager.get("FileChooser.fileHidingEnabled");
        boolean booleanValue = value instanceof Boolean ? (Boolean)value : true;
        fc.setFileHidingEnabled(booleanValue);
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        Locale l;
        super.installStrings(fc);
        try {
            l = this.getLocale();
        }
        catch (IllegalComponentStateException e) {
            l = Locale.getDefault();
        }
        this.chooseButtonText = UIManager.getString("FileChooser.chooseButtonText");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString("FileChooser.fileNameLabelText");
        this.cancelButtonText = UIManager.getString("FileChooser.cancelButtonText");
        this.cancelButtonToolTipText = UIManager.getString("FileChooser.cancelToolTipText");
        this.newFolderErrorText = this.getString("FileChooser.newFolderErrorText", l, "Error occured during folder creation");
        this.newFolderExistsErrorText = this.getString("FileChooser.newFolderExistsErrorText", l, "That name is already taken");
        this.newFolderButtonText = this.getString("FileChooser.newFolderButtonText", l, "New Folder");
        this.newFolderTitleText = this.getString("FileChooser.newFolderTitleText", l, "New Folder");
        this.newFolderDialogPrompt = this.getString("FileChooser.newFolderPromptText", l, "Name of new folder:");
        this.newFolderDefaultName = this.getString("FileChooser.untitledFolderName", l, "untitled folder");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
    }

    @Override
    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    private String getString(String string, Locale l, String defaultValue) {
        String value = UIManager.getString(string);
        return value == null ? defaultValue : value;
    }

    protected AncestorListener createAncestorListener(JFileChooser fc) {
        return new FileChooserAncestorListener();
    }

    @Override
    public void createModel() {
        JFileChooser fc = this.getFileChooser();
        fc.setFileSystemView(QuaquaFileSystemView.getQuaquaFileSystemView());
        this.fileView = UIManager.getBoolean("FileChooser.speed") ? new BasicFileChooserUI.BasicFileView(this) : QuaquaFileSystemView.getQuaquaFileSystemView().createFileView(fc);
        fc.setFileView(this.fileView);
        this.model = new FileSystemTreeModel(fc);
        this.subtreeModel = new SubtreeTreeModel(this.model);
        this.subtreeModel.setPathToRoot(this.model.toPath(new File(QuaquaManager.getProperty("user.home")), null));
    }

    public SubtreeTreeModel getTreeModel() {
        return this.subtreeModel;
    }

    public FileSystemTreeModel getFileSystemTreeModel() {
        return this.model;
    }

    private File[] getSelectedFiles() {
        JFileChooser fc = this.getFileChooser();
        if (fc.isMultiSelectionEnabled()) {
            File[] selectedFiles = fc.getSelectedFiles();
            ArrayList<File> list = new ArrayList<File>(selectedFiles.length);
            for (int i = 0; i < selectedFiles.length; ++i) {
                if (selectedFiles[i] == null) continue;
                if (selectedFiles[i].isAbsolute()) {
                    list.add(selectedFiles[i]);
                    continue;
                }
                list.add(new File(fc.getCurrentDirectory(), selectedFiles[i].getName()));
            }
            return list.toArray(new File[list.size()]);
        }
        File f = fc.getSelectedFile();
        if (f == null) {
            return new File[0];
        }
        if (f.isAbsolute()) {
            return new File[]{f};
        }
        return new File[]{new File(fc.getCurrentDirectory(), f.getName())};
    }

    private void updateSelection() {
        JFileChooser fc = this.getFileChooser();
        File[] files = this.getSelectedFiles();
        TreePath fullPath = null;
        boolean isAtLeastOneFileSelected = false;
        boolean isAtLeastOneDirSelected = false;
        if (files.length != 0) {
            FileSystemTreeModel.Node node;
            TreePath[] paths = new TreePath[files.length];
            ArrayList<Serializable> list = new ArrayList<Serializable>(paths.length);
            TreePath commonParentPath = null;
            for (int i = 0; i < files.length; ++i) {
                TreePath parentPath;
                TreePath selectionPath;
                FileSystemTreeModel.Node node2;
                boolean isDirectory;
                File file = files[i];
                if (!file.isAbsolute()) {
                    file = new File(fc.getCurrentDirectory(), file.getPath());
                }
                boolean bl = isDirectory = !(node2 = (FileSystemTreeModel.Node)(fullPath = this.model.toPath(file, selectionPath = this.subtreeModel.toFullPath(this.browser.getSelectionPath()))).getLastPathComponent()).isLeaf();
                if (isDirectory) {
                    isAtLeastOneDirSelected = true;
                } else {
                    isAtLeastOneFileSelected = true;
                }
                if (files.length != 1 && isDirectory && !fc.isDirectorySelectionEnabled()) continue;
                TreePath subPath = this.getTreeModel().toSubPath(fullPath);
                TreePath treePath = parentPath = subPath == null ? null : subPath.getParentPath();
                if (list.isEmpty()) {
                    commonParentPath = parentPath;
                }
                if ((parentPath != null || commonParentPath != null) && (parentPath == null || commonParentPath == null || !parentPath.equals(commonParentPath))) continue;
                list.add(subPath);
            }
            if (list.isEmpty() && files.length > 0) {
                list.add(fc.getFileSystemView().getParentDirectory(files[0]));
            }
            if (!this.subtreeModel.isDescendant(fullPath)) {
                this.subtreeModel.setPathToRoot(new TreePath(this.model.getRoot()));
                this.browser.setSelectionPath(fullPath);
                this.sidebarTree.clearSelection();
            } else {
                this.browser.setSelectionPaths(list.toArray(new TreePath[list.size()]));
            }
            if (files.length == 1 && ((node = (FileSystemTreeModel.Node)fullPath.getLastPathComponent()).isLeaf() || !files[0].exists())) {
                this.setFileName(files[0].getName());
            }
        }
        if (fullPath != null && fullPath.getPathCount() > 0) {
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)fullPath.getLastPathComponent();
            this.directoryComboBoxModel.setPath(node.isLeaf() ? fullPath.getParentPath() : fullPath);
        }
        if (files.length == 1) {
            this.ensureFileIsVisible(fc, files[0]);
        }
        this.updateApproveButtonState();
    }

    private boolean isFileNameFieldValid() {
        String string = this.getFileName();
        return string != null && !string.equals("");
    }

    private boolean isFileNameFieldVisible() {
        JFileChooser fc = this.getFileChooser();
        return fc.getDialogType() == 1 || fc.getDialogType() == 2;
    }

    private void updateApproveButtonState() {
        JFileChooser fc = this.getFileChooser();
        if (fc.getControlButtonsAreShown()) {
            File[] files = this.getSelectedFiles();
            boolean isEnabled = true;
            boolean isSaveDialog = fc.getDialogType() == 1;
            boolean isFileSelected = false;
            boolean isDirectorySelected = false;
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].exists()) continue;
                if (files[i].isDirectory() && fc.isTraversable(files[i])) {
                    isDirectorySelected = true;
                } else {
                    isFileSelected = true;
                }
                if (isEnabled &= isSaveDialog || fc.accept(files[i])) continue;
                System.err.println("ACCEPT? " + fc.accept(files[i]) + " " + files[i]);
            }
            switch (fc.getFileSelectionMode()) {
                case 0: {
                    isEnabled &= isFileSelected || this.isFileNameFieldVisible() && this.isFileNameFieldValid();
                    break;
                }
                case 1: {
                    isEnabled &= !isFileSelected;
                    break;
                }
                case 2: {
                    isEnabled &= true;
                }
            }
            this.setApproveButtonEnabled(isEnabled);
        }
    }

    private void setApproveButtonEnabled(boolean isEnabled) {
        JFileChooser fc = this.getFileChooser();
        if (fc.getControlButtonsAreShown()) {
            JRootPane rp;
            this.approveButton.setEnabled(isEnabled);
            if (isEnabled && (rp = this.approveButton.getRootPane()) != null) {
                rp.setDefaultButton(this.approveButton);
            }
        }
    }

    private void updateApproveButtonText() {
        JFileChooser fc = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
    }

    private void updateFileChooserFromBrowser() {
        JFileChooser fc = this.getFileChooser();
        TreePath[] paths = this.browser.getSelectionPaths();
        boolean count = false;
        File[] files = new File[paths == null ? 0 : paths.length];
        ArrayList<File> list = new ArrayList<File>(files.length);
        for (int i = 0; i < files.length; ++i) {
            boolean isDirectory;
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)paths[i].getLastPathComponent();
            File file = node.lazyGetResolvedFile();
            if (file == null || !fc.accept(file)) continue;
            boolean bl = isDirectory = !node.isLeaf();
            if (files.length != 1 && isDirectory && !fc.isDirectorySelectionEnabled()) continue;
            list.add(file);
        }
        if (fc.isMultiSelectionEnabled()) {
            fc.setSelectedFiles(list.toArray(new File[list.size()]));
        } else {
            fc.setSelectedFile(list.size() > 0 ? (File)list.get(0) : null);
        }
    }

    protected TreeSelectionListener createBrowserSelectionListener(JFileChooser fc) {
        return new BrowserSelectionListener();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        this.updateSelection();
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.updateSelection();
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        TreePath dirPath;
        File dir = (File)e.getNewValue();
        TreePath selectionPath = this.browser.getSelectionPath() == null ? null : this.subtreeModel.toFullPath(this.browser.getSelectionPath());
        TreePath fullDirPath = dirPath = this.model.toPath(dir, selectionPath);
        if (!this.subtreeModel.getPathToRoot().isDescendant(dirPath)) {
            FileInfo sidebarFileInfo = null;
            TreePath sidebarSelectionPath = null;
            Enumeration<TreeNode> i = ((DefaultMutableTreeNode)this.sidebarTree.getModel().getRoot()).preorderEnumeration();
            while (i.hasMoreElements()) {
                FileInfo info;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.nextElement();
                if (!(node instanceof FileInfo) || (info = (FileInfo)((Object)node)).getResolvedFile() == null || !info.getResolvedFile().equals(dir)) continue;
                sidebarFileInfo = info;
                sidebarSelectionPath = new TreePath(node.getPath());
                break;
            }
            if (sidebarFileInfo != null) {
                TreePath sidebarPath = this.model.toPath(sidebarFileInfo.getResolvedFile(), selectionPath);
                this.subtreeModel.setPathToRoot(sidebarPath);
                this.sidebarTree.setSelectionPath(sidebarSelectionPath);
            } else {
                this.subtreeModel.setPathToRoot(new TreePath(this.model.getRoot()));
                this.sidebarTree.clearSelection();
            }
        }
        dirPath = this.subtreeModel.toSubPath(dirPath);
        this.directoryComboBoxModel.setPath(fullDirPath);
        this.browser.setSelectionPath(dirPath);
        this.browser.ensurePathIsVisible(dirPath);
        this.model.lazyInvalidatePath(dirPath);
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
        this.model.invalidateAll();
        if (this.getFileChooser().isShowing()) {
            this.model.validatePath(this.subtreeModel.toFullPath(this.browser.getSelectionPath()));
            this.browser.repaint();
            this.browser.updatePreviewColumn();
        }
    }

    private void doFileViewChanged(PropertyChangeEvent e) {
        this.model.invalidateAll();
        if (this.getFileChooser().isShowing()) {
            this.model.validatePath(this.subtreeModel.toFullPath(this.browser.getSelectionPath()));
            this.browser.repaint();
            this.browser.updatePreviewColumn();
        }
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.updateApproveButtonText();
        this.updateApproveButtonState();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.browser.setSelectionMode(4);
        } else {
            this.browser.setSelectionMode(1);
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doChoosableFilterChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        boolean isChooserVisible = ((FileFilter[])e.getNewValue()).length > 1;
        this.formatPanel.setVisible(isChooserVisible);
        this.model.invalidateAll();
        this.updateApproveButtonState();
        if (fc.isShowing()) {
            this.model.validatePath(this.subtreeModel.toFullPath(this.browser.getSelectionPath()));
            this.browser.repaint();
            this.browser.updatePreviewColumn();
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
            this.accessoryPanel.setVisible(accessory != null);
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        boolean isSave = this.isFileNameFieldVisible();
        this.fileNameTextField.setEnabled(isSave);
        this.fileNamePanel.setVisible(isSave);
        this.doPreviewComponentChanged(null);
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    private void doFileSystemViewChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        this.model = new FileSystemTreeModel(fc);
        this.subtreeModel = new SubtreeTreeModel(this.model);
        this.browser.setModel(this.getTreeModel());
        this.sidebarTreeModel = new SidebarTreeModel(fc, new TreePath(this.getFileSystemTreeModel().getRoot()), this.getFileSystemTreeModel());
        this.sidebarTree.setModel(this.sidebarTreeModel);
    }

    private void doPreviewComponentChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        final Component pv = (Component)fc.getClientProperty("Quaqua.FileChooser.preview");
        if (pv != null) {
            this.browser.setPreviewRenderer(new BrowserPreviewRenderer(){

                @Override
                public Component getPreviewRendererComponent(JBrowser browser, TreePath[] paths) {
                    return pv;
                }
            });
            this.browser.setPreviewColumnWidth(Math.max(this.browser.getFixedCellWidth(), pv.getPreferredSize().width));
        } else {
            boolean isSave = this.isFileNameFieldVisible();
            this.browser.setPreviewRenderer(isSave ? null : new FilePreview(fc));
            this.browser.setPreviewColumnWidth(this.browser.getFixedCellWidth());
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(final JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                QuaquaLionFileChooserUI.this.isAdjusting++;
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    QuaquaLionFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    QuaquaLionFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    QuaquaLionFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    QuaquaLionFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("FileSystemViewChanged")) {
                    QuaquaLionFileChooserUI.this.doFileSystemViewChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    QuaquaLionFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    QuaquaLionFileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    QuaquaLionFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ChoosableFileFilterChangedProperty")) {
                    QuaquaLionFileChooserUI.this.doChoosableFilterChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    QuaquaLionFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    QuaquaLionFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    QuaquaLionFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    QuaquaLionFileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("fileViewChanged")) {
                    QuaquaLionFileChooserUI.this.doFileViewChanged(e);
                } else if (s.equals("Quaqua.FileChooser.preview")) {
                    QuaquaLionFileChooserUI.this.doPreviewComponentChanged(e);
                } else if (!s.equals("componentOrientation") && s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    QuaquaLionFileChooserUI.this.ensurePathIsVisible(QuaquaLionFileChooserUI.this.subtreeModel.toFullPath(QuaquaLionFileChooserUI.this.browser.getSelectionPath()));
                    if (fc.getDialogType() == 1) {
                        QuaquaLionFileChooserUI.this.fileNameTextField.selectAll();
                        QuaquaLionFileChooserUI.this.fileNameTextField.requestFocus();
                    } else {
                        QuaquaLionFileChooserUI.this.browser.requestFocus();
                    }
                }
                QuaquaLionFileChooserUI.this.isAdjusting--;
            }
        };
    }

    protected void removeControlButtons() {
        this.cancelButton.setVisible(false);
        this.approveButton.setVisible(false);
    }

    protected void addControlButtons() {
        this.cancelButton.setVisible(true);
        this.approveButton.setVisible(true);
    }

    private void ensurePathIsVisible(TreePath path) {
        if (!this.subtreeModel.isDescendant(path.getPath())) {
            ++this.isAdjusting;
            if (((FileSystemTreeModel.Node)path.getLastPathComponent()).isLeaf()) {
                this.subtreeModel.setPathToRoot(path.getParentPath().getPath());
            } else {
                this.subtreeModel.setPathToRoot(path.getPath());
            }
            --this.isAdjusting;
        }
        this.browser.ensurePathIsVisible(path);
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (!(this.fileNameTextField == null || this.fileNameTextField.hasFocus() || filename != null && this.fileNameTextField.getText().equals(filename))) {
            this.fileNameTextField.setText(filename);
        }
    }

    @Override
    public void setRootDirectory(File file) {
        if (file != null) {
            JFileChooser fc = this.getFileChooser();
            if (file.isDirectory()) {
                ++this.isAdjusting;
                TreePath fullPath = this.getFileSystemTreeModel().toPath(file, this.subtreeModel.getPathToRoot());
                this.subtreeModel.setPathToRoot(fullPath);
                this.getFileSystemTreeModel().lazyInvalidatePath(fullPath);
                if (fc.isTraversable(file)) {
                    fc.setCurrentDirectory(file);
                }
                TreePath dirPath = this.subtreeModel.toSubPath(fullPath);
                this.browser.setSelectionPath(dirPath);
                this.browser.ensurePathIsVisible(dirPath);
                this.directoryComboBoxModel.setPath(fullPath);
                --this.isAdjusting;
            }
        }
    }

    private DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    private SidebarRenderer createSidebarCellRenderer(JFileChooser fc) {
        return new SidebarRenderer();
    }

    protected TreeSelectionListener createSidebarSelectionListener(JFileChooser fc) {
        return new SidebarSelectionListener();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    private void maybeApproveSelection(boolean allowDirectories) {
        JFileChooser fc = this.getFileChooser();
        File selectedFile = null;
        File[] selectedFiles = null;
        String filename = null;
        if (this.isFileNameFieldVisible() && (filename = this.getFileName()).equals("")) {
            filename = null;
        }
        if (fc.isMultiSelectionEnabled()) {
            TreePath[] selectedPaths = this.browser.getSelectionPaths();
            if (filename != null) {
                File f = new File(((FileSystemTreeModel.Node)selectedPaths[0].getLastPathComponent()).getResolvedFile().getParent(), filename);
                selectedFiles = new File[]{f};
            } else {
                ArrayList<File> a = new ArrayList<File>();
                for (int i = 0; i < selectedPaths.length; ++i) {
                    File f = ((FileSystemTreeModel.Node)selectedPaths[i].getLastPathComponent()).getResolvedFile();
                    a.add(f);
                }
                if (a.size() > 0) {
                    selectedFiles = a.toArray(new File[a.size()]);
                }
            }
            if (!allowDirectories && selectedFiles.length == 1 && selectedFiles[0].isDirectory()) {
                return;
            }
        } else {
            TreePath selectionPath = this.browser.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)this.browser.getSelectionPath().getLastPathComponent();
            selectedFile = node.getResolvedFile();
            if (filename != null) {
                selectedFile = new File(!node.isLeaf() ? selectedFile : selectedFile.getParentFile(), filename);
            } else if (fc.getFileSelectionMode() == 0 && !node.isLeaf()) {
                return;
            }
        }
        if (selectedFiles != null || selectedFile != null) {
            if (selectedFiles != null) {
                fc.setSelectedFiles(selectedFiles);
            } else if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(new File[]{selectedFile});
            } else {
                fc.setSelectedFile(selectedFile);
            }
            fc.approveSelection();
        } else {
            if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(null);
            } else {
                fc.setSelectedFile(null);
            }
            fc.cancelSelection();
        }
    }

    @Override
    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
        if (this.browser.getSelectionPaths() != null) {
            TreePath[] paths = this.browser.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                if (!((FileSystemTreeModel.Node)paths[i].getLastPathComponent()).getFile().equals(f)) continue;
                this.browser.ensurePathIsVisible(paths[i]);
                return;
            }
        } else {
            TreePath fullPath = this.getFileSystemTreeModel().toPath(f, this.subtreeModel.getPathToRoot());
            TreePath subPath = this.getTreeModel().toSubPath(fullPath);
            if (subPath == null) {
                ++this.isAdjusting;
                this.getTreeModel().setPathToRoot(new Object[]{fullPath.getPathComponent(0)});
                --this.isAdjusting;
                subPath = fullPath;
            }
            this.ensurePathIsVisible(fullPath);
        }
    }

    @Override
    public String getApproveButtonText(JFileChooser fc) {
        String buttonText = fc.getApproveButtonText();
        if (buttonText != null) {
            return buttonText;
        }
        if (fc.isDirectorySelectionEnabled() && this.chooseButtonText != null) {
            return this.chooseButtonText;
        }
        if (fc.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        if (fc.isShowing() && this.browser.getSelectionPath() != null) {
            this.model.lazyInvalidatePath(this.browser.getSelectionPath());
            this.model.validatePath(this.browser.getSelectionPath());
        }
    }

    @Override
    public void clearIconCache() {
        try {
            this.fileView.getClass().getMethod("clearIconCache", new Class[0]).invoke((Object)this.fileView, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected MouseListener createDoubleClickListener(JFileChooser fc) {
        return new DoubleClickListener();
    }

    protected class QuaquaApproveSelectionAction
    extends AbstractAction {
        protected QuaquaApproveSelectionAction() {
            super("approveSelection");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QuaquaLionFileChooserUI.this.maybeApproveSelection(true);
        }
    }

    private class SidebarSelectionListener
    implements TreeSelectionListener {
        private SidebarSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            FileInfo info;
            File file;
            if (QuaquaLionFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            if (QuaquaLionFileChooserUI.this.sidebarTree != null && QuaquaLionFileChooserUI.this.sidebarTree.getSelectionPath() != null && QuaquaLionFileChooserUI.this.sidebarTree.getSelectionPath().getLastPathComponent() instanceof FileInfo && (file = (info = (FileInfo)QuaquaLionFileChooserUI.this.sidebarTree.getSelectionPath().getLastPathComponent()).lazyGetResolvedFile()) != null) {
                QuaquaLionFileChooserUI.this.setRootDirectory(file);
                QuaquaLionFileChooserUI.this.isAdjusting++;
                JFileChooser fc = QuaquaLionFileChooserUI.this.getFileChooser();
                if (file.isDirectory() && fc.isTraversable(file)) {
                    fc.setCurrentDirectory(file);
                } else if (fc.isMultiSelectionEnabled()) {
                    fc.setSelectedFiles(new File[]{file});
                } else {
                    fc.setSelectedFile(file);
                }
                QuaquaLionFileChooserUI.this.isAdjusting--;
            }
        }
    }

    private class FileChooserAncestorListener
    implements AncestorListener {
        private FileChooserAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            if (QuaquaLionFileChooserUI.this.model != null) {
                QuaquaLionFileChooserUI.this.model.setAutoValidate(UIManager.getBoolean("FileChooser.autovalidate"));
                QuaquaLionFileChooserUI.this.model.validatePath(QuaquaLionFileChooserUI.this.browser.getSelectionPath());
                if (QuaquaLionFileChooserUI.this.sidebarTreeModel != null) {
                    QuaquaLionFileChooserUI.this.sidebarTreeModel.lazyValidate();
                }
            }
            QuaquaLionFileChooserUI.this.updateApproveButtonState();
            JFileChooser fc = QuaquaLionFileChooserUI.this.getFileChooser();
            if (fc.getSelectedFile() != null) {
                QuaquaLionFileChooserUI.this.ensureFileIsVisible(fc, fc.getSelectedFile());
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            if (QuaquaLionFileChooserUI.this.model != null) {
                QuaquaLionFileChooserUI.this.model.setAutoValidate(false);
                QuaquaLionFileChooserUI.this.model.stopValidation();
                if (QuaquaLionFileChooserUI.this.browser.getSelectionPath() != null) {
                    QuaquaLionFileChooserUI.this.model.invalidatePath(QuaquaLionFileChooserUI.this.browser.getSelectionPath());
                }
                QuaquaLionFileChooserUI.this.clearIconCache();
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    protected class SaveTextDocumentListener
    implements DocumentListener {
        protected SaveTextDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentevent) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentevent) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentevent) {
        }

        private void textChanged() {
            if (QuaquaLionFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFileChooser fc = QuaquaLionFileChooserUI.this.getFileChooser();
                    FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)QuaquaLionFileChooserUI.this.browser.getSelectionPath().getLastPathComponent();
                    File file = node.getResolvedFile();
                    if (QuaquaLionFileChooserUI.this.fileNameTextField.getText().length() != 0) {
                        if (!node.isLeaf()) {
                            QuaquaLionFileChooserUI.this.updateApproveButtonState();
                            return;
                        }
                        file = new File(fc.getFileSystemView().getParentDirectory(file), QuaquaLionFileChooserUI.this.fileNameTextField.getText());
                    }
                    if (fc.isMultiSelectionEnabled()) {
                        fc.setSelectedFiles(new File[]{file});
                    } else {
                        fc.setSelectedFile(file);
                    }
                    QuaquaLionFileChooserUI.this.updateApproveButtonState();
                }
            });
        }
    }

    protected class SaveTextFocusListener
    implements FocusListener {
        protected SaveTextFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusevent) {
            QuaquaLionFileChooserUI.this.updateApproveButtonState();
        }

        @Override
        public void focusLost(FocusEvent focusevent) {
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        private String showNewFolderDialog() {
            JOptionPane optionPane = new JOptionPane(QuaquaLionFileChooserUI.this.newFolderDialogPrompt, -1, 2);
            optionPane.setWantsInput(true);
            optionPane.putClientProperty("PrivateQuaqua.OptionPane.InputFieldDocument", new FilenameDocument());
            optionPane.setInitialSelectionValue(QuaquaLionFileChooserUI.this.newFolderDefaultName);
            optionPane.setOptions(new Object[]{UIManager.getString("FileChooser.createFolderButtonText"), UIManager.getString("FileChooser.cancelButtonText")});
            optionPane.setInitialValue(UIManager.getString("FileChooser.createFolderButtonText"));
            JDialog dialog = optionPane.createDialog(QuaquaLionFileChooserUI.this.getFileChooser(), QuaquaLionFileChooserUI.this.newFolderTitleText);
            dialog.setVisible(true);
            dialog.dispose();
            return optionPane.getValue() == UIManager.getString("FileChooser.createFolderButtonText") ? (String)optionPane.getInputValue() : null;
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            JFileChooser fc = QuaquaLionFileChooserUI.this.getFileChooser();
            String newFolderName = this.showNewFolderDialog();
            if (newFolderName != null) {
                File newFolder;
                FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)QuaquaLionFileChooserUI.this.browser.getSelectionPath().getLastPathComponent();
                File currentFile = node.getResolvedFile();
                if (node.isLeaf()) {
                    currentFile = currentFile.getParentFile();
                }
                if ((newFolder = new File(currentFile, newFolderName)).exists()) {
                    JOptionPane.showMessageDialog(fc, QuaquaLionFileChooserUI.this.newFolderExistsErrorText, QuaquaLionFileChooserUI.this.newFolderTitleText, 0);
                    return;
                }
                try {
                    if (!newFolder.mkdir() && !newFolder.isDirectory()) {
                        throw new IOException("Couldn't create folder \"" + newFolder.getName() + "\".");
                    }
                    fc.rescanCurrentDirectory();
                    fc.setCurrentDirectory(newFolder);
                    if (fc.isMultiSelectionEnabled()) {
                        fc.setSelectedFiles(new File[]{newFolder});
                    } else {
                        fc.setSelectedFile(newFolder);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(fc, QuaquaLionFileChooserUI.this.newFolderErrorText, QuaquaLionFileChooserUI.this.newFolderTitleText, 0);
                }
            }
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        protected DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JFileChooser fc = QuaquaLionFileChooserUI.this.getFileChooser();
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && fc.getDialogType() != 1) {
                for (TreePath tp : QuaquaLionFileChooserUI.this.browser.getSelectionPaths()) {
                    FileSystemTreeModel.Node n = (FileSystemTreeModel.Node)tp.getLastPathComponent();
                    if (fc.accept(n.getFile())) continue;
                    return;
                }
                QuaquaLionFileChooserUI.this.maybeApproveSelection(false);
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (QuaquaLionFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            FileSystemTreeModel.Node chosenNode = (FileSystemTreeModel.Node)QuaquaLionFileChooserUI.this.directoryComboBox.getSelectedItem();
            if (chosenNode != null) {
                File dir = chosenNode.getResolvedFile();
                QuaquaLionFileChooserUI.this.setRootDirectory(dir);
            }
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = QuaquaLionFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                QuaquaLionFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = QuaquaLionFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    QuaquaLionFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return QuaquaLionFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return QuaquaLionFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    protected static class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private Border border = new EmptyBorder(1, 0, 1, 0);

        protected FilterComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            this.setBorder(this.border);
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        TreePath path;
        FileSystemTreeModel.Node selectedDirectory = null;
        JFileChooser chooser = QuaquaLionFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        private void setPath(TreePath path) {
            if (this.path != null && this.path.getPathCount() > 0) {
                this.fireIntervalRemoved(this, 0, this.path.getPathCount() - 1);
            }
            this.path = path;
            if (this.path.getPathCount() > 0) {
                this.fireIntervalAdded(this, 0, this.path.getPathCount() - 1);
            }
            this.setSelectedItem(this.path.getLastPathComponent());
        }

        @Override
        public void setSelectedItem(Object selectedItem) {
            FileSystemTreeModel.Node node;
            this.selectedDirectory = node = (FileSystemTreeModel.Node)selectedItem;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.path == null ? 0 : this.path.getPathCount();
        }

        @Override
        public Object getElementAt(int index) {
            return this.path.getPathComponent(this.path.getPathCount() - index - 1);
        }
    }

    private static class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        private IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(c, g, x + this.depth * 10, y);
                } else {
                    this.icon.paintIcon(c, g, x, y);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon == null ? this.depth * 10 : this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon == null ? 0 : this.icon.getIconHeight();
        }
    }

    private static class SidebarRenderer
    extends DefaultTreeCellRenderer {
        public SidebarRenderer() {
            if (UIManager.getBoolean("FileChooser.enforceQuaquaTreeUI")) {
                this.setUI((LabelUI)QuaquaLabelUI.createUI(this));
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean cellHasFocus) {
            super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, false);
            if (value != null && value instanceof FileInfo) {
                FileInfo info = (FileInfo)value;
                this.setText(info.getUserName());
                if (this.isSpecialFolder(info)) {
                    this.setIcon(this.getSpecialFolderIcon(info));
                } else {
                    this.setIcon(info.getIcon());
                }
            }
            this.putClientProperty("Quaqua.selected", isSelected);
            return this;
        }

        private Icon getSpecialFolderIcon(FileInfo info) {
            File file = info.getFile();
            if (file == null) {
                return UIManager.getIcon("FileChooser.sideBarIcon.GenericFolder");
            }
            Icon icon = UIManager.getIcon("FileChooser.sideBarIcon." + file.getName());
            if (icon == null) {
                icon = file.getParentFile() != null && file.getParentFile().getPath().equals("/Volumes") ? UIManager.getIcon("FileChooser.sideBarIcon.GenericVolume") : (file.getParentFile() != null && file.getParentFile().getPath().equals("/Users") ? UIManager.getIcon("FileChooser.sideBarIcon.Home") : UIManager.getIcon("FileChooser.sideBarIcon.GenericFolder"));
            }
            return icon;
        }

        private boolean isSpecialFolder(FileInfo info) {
            return true;
        }
    }

    static class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        private Border border = new EmptyBorder(1, 0, 1, 0);
        IndentIcon ii = new IndentIcon();
        private JSeparator separator = new JSeparator();

        public DirectoryComboBoxRenderer() {
            this.separator.setPreferredSize(new Dimension(9, 9));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                super.getListCellRendererComponent((JList<?>)list, value, index, false, cellHasFocus);
                this.setText((String)value);
                this.setPreferredSize(new Dimension(10, 14));
                return this;
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setPreferredSize(null);
            if (value instanceof File) {
                this.setText(value + " " + index);
                return this;
            }
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)value;
            if (node == null) {
                return this.separator;
            }
            this.setText(node.getUserName());
            this.ii.icon = node.getIcon();
            this.ii.depth = 0;
            this.setIcon(this.ii);
            this.setBorder(this.border);
            return this;
        }
    }

    protected class BrowserSelectionListener
    implements TreeSelectionListener {
        protected BrowserSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (QuaquaLionFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            TreePath path = QuaquaLionFileChooserUI.this.browser.getSelectionPath();
            if (path != null) {
                QuaquaLionFileChooserUI.this.model.lazyInvalidatePath(path);
                QuaquaLionFileChooserUI.this.model.validatePath(path);
            }
            QuaquaLionFileChooserUI.this.updateFileChooserFromBrowser();
        }
    }
}

