/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.GetItem64;
import org.gvsig.tools.util.GetItemByKey;
import org.gvsig.tools.util.GetItemByKeyWithGetKeys;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.tools.util.GetKeys;
import org.gvsig.tools.util.Size;
import org.gvsig.tools.util.Size64;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonUtils {
    private static void add(JsonArrayBuilder builder, Object value) throws CoercionException {
        String s;
        if (value == null) {
            builder.addNull();
            return;
        }
        GetItemWithSize64 value_list = JsonUtils.toList(value);
        if (value_list != null) {
            builder.add((JsonValue)JsonUtils.toJsonArray(value_list));
            return;
        }
        GetItemByKeyWithGetKeys<String, Object> value_dict = JsonUtils.toDict(value);
        if (value_dict != null) {
            builder.add((JsonValue)JsonUtils.toJsonObject(value_dict));
            return;
        }
        if (value instanceof Integer) {
            builder.add(((Integer)value).intValue());
        } else if (value instanceof Byte) {
            builder.add(((Integer)value).intValue());
        } else if (value instanceof Long) {
            builder.add(((Long)value).longValue());
        } else if (value instanceof BigDecimal) {
            builder.add((BigDecimal)value);
        } else if (value instanceof String) {
            builder.add((String)value);
        } else if (value instanceof Boolean) {
            builder.add(((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            builder.add(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            builder.add(((Double)value).doubleValue());
        } else if (value instanceof Date) {
            s = DateTimeFormatter.ISO_DATE.format(new java.util.Date(((java.util.Date)value).getTime()).toInstant());
            builder.add(s);
        } else if (value instanceof Time) {
            s = DateTimeFormatter.ISO_TIME.format(new java.util.Date(((java.util.Date)value).getTime()).toInstant());
            builder.add(s);
        } else if (value instanceof Timestamp) {
            s = DateTimeFormatter.ISO_DATE_TIME.format(new java.util.Date(((java.util.Date)value).getTime()).toInstant());
            builder.add(s);
        } else if (value instanceof java.util.Date) {
            s = DateTimeFormatter.ISO_DATE_TIME.format(new java.util.Date(((java.util.Date)value).getTime()).toInstant());
            builder.add(s);
        } else if (value instanceof JsonValue) {
            builder.add((JsonValue)value);
        } else if (value instanceof JsonArrayBuilder) {
            builder.add((JsonArrayBuilder)value);
        } else if (value instanceof JsonObjectBuilder) {
            builder.add((JsonObjectBuilder)value);
        } else {
            s = value.toString();
            builder.add(s);
        }
    }

    private static void add(JsonObjectBuilder builder, String name, Object value) throws CoercionException {
        String s;
        if (value == null) {
            builder.addNull(name);
            return;
        }
        GetItemWithSize64 value_list = JsonUtils.toList(value);
        if (value_list != null) {
            builder.add(name, (JsonValue)JsonUtils.toJsonArray(value_list));
            return;
        }
        GetItemByKeyWithGetKeys<String, Object> value_dict = JsonUtils.toDict(value);
        if (value_dict != null) {
            builder.add(name, (JsonValue)JsonUtils.toJsonObject(value_dict));
            return;
        }
        if (value instanceof Integer) {
            builder.add(name, ((Integer)value).intValue());
        } else if (value instanceof Byte) {
            builder.add(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            builder.add(name, ((Long)value).longValue());
        } else if (value instanceof BigDecimal) {
            builder.add(name, (BigDecimal)value);
        } else if (value instanceof String) {
            builder.add(name, (String)value);
        } else if (value instanceof Boolean) {
            builder.add(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            builder.add(name, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            builder.add(name, ((Double)value).doubleValue());
        } else if (value instanceof Date) {
            s = DateTimeFormatter.ISO_DATE.format(new java.util.Date(((java.util.Date)value).getTime()).toInstant());
            builder.add(name, s);
        } else if (value instanceof Time) {
            s = DateTimeFormatter.ISO_TIME.format(new java.util.Date(((java.util.Date)value).getTime()).toInstant());
            builder.add(name, s);
        } else if (value instanceof Timestamp) {
            s = DateTimeFormatter.ISO_DATE_TIME.format(new java.util.Date(((java.util.Date)value).getTime()).toInstant());
            builder.add(name, s);
        } else if (value instanceof java.util.Date) {
            s = DateTimeFormatter.ISO_DATE_TIME.format(new java.util.Date(((java.util.Date)value).getTime()).toInstant());
            builder.add(name, s);
        } else if (value instanceof JsonValue) {
            builder.add(name, (JsonValue)value);
        } else if (value instanceof JsonArrayBuilder) {
            builder.add(name, (JsonArrayBuilder)value);
        } else if (value instanceof JsonObjectBuilder) {
            builder.add(name, (JsonObjectBuilder)value);
        } else {
            s = value.toString();
            builder.add(name, s);
        }
    }

    private static JsonArray toJsonArray(String s) {
        StringReader r = new StringReader(s);
        JsonReader jsonreader = Json.createReader((Reader)r);
        return jsonreader.readArray();
    }

    private static JsonArray toJsonArray(GetItemWithSize64 list) throws CoercionException {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (long i = 0L; i < list.size64(); ++i) {
            Object element = list.get64(i);
            JsonUtils.add(builder, element);
        }
        return builder.build();
    }

    private static JsonObject toJsonObject(String s) {
        StringReader r = new StringReader(s);
        JsonReader jsonreader = Json.createReader((Reader)r);
        return jsonreader.readObject();
    }

    private static JsonObject toJsonObject(GetItemByKeyWithGetKeys<String, Object> dict) throws CoercionException {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (String name : dict.getKeys()) {
            if (name == null) continue;
            Object element = dict.get((Object)name);
            JsonUtils.add(builder, name, element);
        }
        return builder.build();
    }

    private static GetItemWithSize64 toList(final Object value) {
        Object list = null;
        if (value instanceof List) {
            list = new GetItemWithSize64<Object>(){

                public long size64() {
                    return ((List)value).size();
                }

                public Object get64(long index) {
                    return ((List)value).get((int)index);
                }
            };
        } else if (value instanceof Object[]) {
            list = new GetItemWithSize64<Object>(){

                public long size64() {
                    return ((Object[])value).length;
                }

                public Object get64(long index) {
                    return ((Object[])value)[(int)index];
                }
            };
        } else if (value instanceof GetItemWithSize64) {
            list = (GetItemWithSize64)value;
        } else if (value instanceof GetItem && value instanceof Size) {
            list = new GetItemWithSize64<Object>(){

                public long size64() {
                    return ((Size)value).size();
                }

                public Object get64(long index) {
                    return ((GetItem)value).get((int)index);
                }
            };
        } else if (value instanceof GetItem64 && value instanceof Size64) {
            list = new GetItemWithSize64<Object>(){

                public long size64() {
                    return ((Size64)value).size64();
                }

                public Object get64(long index) {
                    return ((GetItem64)value).get64((long)((int)index));
                }
            };
        } else if (value instanceof Iterable) {
            final ArrayList values = new ArrayList();
            for (Object v : (Iterable)value) {
                values.add(v);
            }
            list = new GetItemWithSize64<Object>(){

                public long size64() {
                    return values.size();
                }

                public Object get64(long index) {
                    return values.get((int)index);
                }
            };
        }
        return list;
    }

    private static GetItemByKeyWithGetKeys<String, Object> toDict(final Object value) {
        Object dict = null;
        if (value instanceof Map) {
            dict = new GetItemByKeyWithGetKeys<String, Object>(){

                public Object get(String k) {
                    return ((Map)value).get(k);
                }

                public List<String> getKeys() {
                    return new ArrayList<String>(((Map)value).keySet());
                }
            };
        } else if (value instanceof GetItemByKey && value instanceof GetKeys) {
            dict = new GetItemByKeyWithGetKeys<String, Object>(){

                public Object get(String k) {
                    return ((GetItemByKey)value).get((Object)k);
                }

                public List<String> getKeys() {
                    return ((GetKeys)value).getKeys();
                }
            };
        }
        return dict;
    }

    private static Object get(JsonValue jsonvalue) {
        Object value = null;
        switch (jsonvalue.getValueType()) {
            case ARRAY: 
            case OBJECT: {
                value = jsonvalue;
                break;
            }
            case NULL: {
                value = null;
                break;
            }
            case FALSE: {
                value = false;
                break;
            }
            case TRUE: {
                value = true;
                break;
            }
            case STRING: {
                value = jsonvalue.toString();
                break;
            }
            case NUMBER: {
                JsonNumber n = (JsonNumber)jsonvalue;
                if (n.isIntegral()) {
                    BigInteger bi = n.bigIntegerValue();
                    try {
                        value = bi.intValueExact();
                    }
                    catch (ArithmeticException ex) {
                        try {
                            value = bi.longValueExact();
                        }
                        catch (ArithmeticException ex2) {
                            value = bi;
                        }
                    }
                    break;
                }
                try {
                    double d = n.doubleValue();
                    if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                        value = n.bigDecimalValue();
                        break;
                    }
                    value = d;
                    break;
                }
                catch (Exception ex) {
                    value = n.bigDecimalValue();
                }
            }
        }
        return value;
    }

    public static Object getitem(JsonArray jsonArray, int index) {
        JsonValue x = (JsonValue)jsonArray.get(index);
        return JsonUtils.get(x);
    }

    public static Object getitem(JsonObject jsonObject, String name) {
        JsonValue x = (JsonValue)jsonObject.get((Object)name);
        return JsonUtils.get(x);
    }

    public static JsonStructure toJson(Object value) throws CoercionException {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonStructure) {
            return (JsonStructure)value;
        }
        if (value instanceof JSONArray) {
            JsonArray r = JsonUtils.toJsonArray(value.toString());
            return r;
        }
        if (value instanceof JSONObject) {
            JsonObject r = JsonUtils.toJsonObject(value.toString());
            return r;
        }
        GetItemWithSize64 value_list = JsonUtils.toList(value);
        if (value_list != null) {
            return JsonUtils.toJsonArray(value_list);
        }
        GetItemByKeyWithGetKeys<String, Object> value_dict = JsonUtils.toDict(value);
        if (value_dict != null) {
            return JsonUtils.toJsonObject(value_dict);
        }
        StringReader reader = new StringReader(value.toString());
        JsonReader jsonreader = Json.createReader((Reader)reader);
        return jsonreader.read();
    }

    public static JsonArray toJsonArray(Object value) throws CoercionException {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonArray) {
            return (JsonArray)value;
        }
        if (value instanceof JSONArray) {
            JsonArray r = JsonUtils.toJsonArray(value.toString());
            return r;
        }
        try {
            GetItemWithSize64 list = JsonUtils.toList(value);
            JsonArray r = list == null ? JsonUtils.toJsonArray(value.toString()) : JsonUtils.toJsonArray(list);
            return r;
        }
        catch (Exception e) {
            throw new CoercionException((Throwable)e);
        }
    }

    public static JsonObject toJsonObject(Object value) throws CoercionException {
        if (value == null || value instanceof JsonObject) {
            return (JsonObject)value;
        }
        if (value instanceof JSONObject) {
            JsonObject r = JsonUtils.toJsonObject(value.toString());
            return r;
        }
        try {
            GetItemByKeyWithGetKeys<String, Object> dict = JsonUtils.toDict(value);
            JsonObject r = dict == null ? JsonUtils.toJsonObject(value.toString()) : JsonUtils.toJsonObject(dict);
            return r;
        }
        catch (Exception e) {
            throw new CoercionException((Throwable)e);
        }
    }

    public static String toString(JsonStructure jsonstructure) {
        if (jsonstructure instanceof JsonObject) {
            StringWriter sw = new StringWriter();
            JsonWriter jsonwriter = Json.createWriter((Writer)sw);
            jsonwriter.writeObject((JsonObject)jsonstructure);
            return ((Object)sw).toString();
        }
        if (jsonstructure instanceof JsonArray) {
            StringWriter sw = new StringWriter();
            JsonWriter jsonwriter = Json.createWriter((Writer)sw);
            jsonwriter.writeArray((JsonArray)jsonstructure);
            return ((Object)sw).toString();
        }
        return null;
    }
}

