/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SignUtil {
    public static final int SIGN_OK = 0;
    public static final int SIGN_FAIL = 1;
    public static final int NOT_SIGNED = 2;
    private PublicKey pubKey = null;
    private PrivateKey privKey = null;

    public static void main(String[] args) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, FileNotFoundException {
        new SignUtil().doMain(args);
    }

    private void doMain(String[] args) {
        try {
            if ("sign".equalsIgnoreCase(this.getCommand(args))) {
                if (!this.canSign()) {
                    System.out.println("Can't locate private key to sign.");
                    return;
                }
                this.sign(this.getArg1AsFile(args));
                System.out.println("File " + this.getArg1(args) + " signed.");
                return;
            }
            if ("verify".equalsIgnoreCase(this.getCommand(args))) {
                if (!this.canVerify()) {
                    System.out.println("Can't locate public key to verify.");
                    return;
                }
                switch (this.verify(this.getArg1AsFile(args))) {
                    case 2: {
                        System.out.println("NOT SIGNED");
                        break;
                    }
                    case 1: {
                        System.out.println("SIGN FAIL");
                        break;
                    }
                    case 0: {
                        System.out.println("SIGN OK");
                        break;
                    }
                    default: {
                        System.out.println("ERROR");
                    }
                }
                return;
            }
            if ("generateKeys".equalsIgnoreCase(this.getCommand(args))) {
                this.generateKeys();
                System.out.println("Generate keys ok");
                return;
            }
            System.out.println("Usage: SignUtil sign|verify|generateKeys\n  sign file\n  verify file\n  generateKeys\n");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private String getCommand(String[] args) {
        if (args.length >= 1) {
            return args[0];
        }
        return null;
    }

    private File getArg1AsFile(String[] args) {
        if (args.length >= 2) {
            return new File(args[1]);
        }
        return null;
    }

    private String getArg1(String[] args) {
        if (args.length >= 2) {
            return args[1];
        }
        return null;
    }

    public SignUtil() {
        this.loadPrivateKey();
        this.loadPublicKey();
    }

    public SignUtil(byte[] publicKey) {
        this.loadPrivateKey();
        this.loadPublicKey(publicKey);
    }

    private void loadPrivateKey() {
        File home = new File(System.getProperty("user.home"));
        File keyfile = new File(home, ".gvsig-keys" + File.separatorChar + "key.private");
        if (keyfile.exists()) {
            try {
                this.loadPrivateKey(keyfile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private PrivateKey loadPrivateKey(File key) {
        try {
            byte[] rawkey = this.loadFileAsByteArray(new FileInputStream(key));
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(rawkey);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
            this.privKey = keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            this.privKey = null;
        }
        return this.privKey;
    }

    private PublicKey loadPublicKey() {
        File home = new File(System.getProperty("user.home"));
        File keyfile = new File(home, ".gvsig-keys" + File.separatorChar + "key.public");
        if (keyfile.exists()) {
            return this.loadPublicKey(this.loadFileAsByteArray(keyfile));
        }
        return null;
    }

    private PublicKey loadPublicKey(byte[] rawkey) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(rawkey);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
            this.pubKey = keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            this.pubKey = null;
        }
        return this.pubKey;
    }

    private PublicKey getPublicKey() {
        return this.pubKey;
    }

    private PrivateKey getPrivateKey() {
        return this.privKey;
    }

    private byte[] loadFileAsByteArray(InputStream in) {
        byte[] alldata;
        try {
            alldata = new byte[in.available()];
            in.read(alldata);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return alldata;
    }

    private byte[] loadFileAsByteArray(File file) {
        try {
            return this.loadFileAsByteArray(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getData(byte[] alldata) {
        BufferedReader reader = new BufferedReader(new StringReader(new String(alldata)));
        StringWriter writer = new StringWriter();
        try {
            String line;
            boolean inSignature = false;
            while ((line = reader.readLine()) != null) {
                if (inSignature) {
                    if (!line.startsWith("## END SIGNATURE")) continue;
                    inSignature = false;
                    continue;
                }
                if (line.startsWith("## BEGIN SIGNATURE")) {
                    inSignature = true;
                    continue;
                }
                writer.append(line);
                writer.append("\n");
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return writer.toString();
    }

    private byte[] getSignature(byte[] alldata) {
        BufferedReader reader = new BufferedReader(new StringReader(new String(alldata)));
        StringWriter writer = new StringWriter();
        try {
            String line;
            boolean inSignature = false;
            while ((line = reader.readLine()) != null) {
                if (inSignature) {
                    if (line.startsWith("## END SIGNATURE")) {
                        inSignature = false;
                        continue;
                    }
                    writer.append(line);
                    writer.append("\n");
                    continue;
                }
                if (!line.startsWith("## BEGIN SIGNATURE")) continue;
                inSignature = true;
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String s = writer.toString();
        if (s.length() < 1) {
            return null;
        }
        Base64 coder = new Base64(60);
        return coder.decode(s);
    }

    public void sign(File file) {
        Base64 coder = new Base64(60);
        try {
            String data = this.getData(this.loadFileAsByteArray(file));
            Signature dsa = Signature.getInstance("SHA1withDSA", "SUN");
            dsa.initSign(this.getPrivateKey());
            dsa.update(data.getBytes());
            String sig = coder.encodeAsString(dsa.sign());
            String[] lines = sig.split("\n");
            FileWriter fw = new FileWriter(file);
            fw.append(data);
            fw.append("## BEGIN SIGNATURE\n");
            for (int i = 0; i < lines.length; ++i) {
                fw.append("## ");
                fw.append(lines[i]);
                fw.append("\n");
            }
            fw.append("## END SIGNATURE\n");
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int verify(File file) {
        return this.verify(this.loadFileAsByteArray(file));
    }

    public int verify(byte[] alldata) {
        try {
            String data = this.getData(alldata);
            byte[] signature = this.getSignature(alldata);
            if (signature == null) {
                return 2;
            }
            Signature dsa = Signature.getInstance("SHA1withDSA", "SUN");
            dsa.initVerify(this.getPublicKey());
            dsa.update(data.getBytes());
            if (!dsa.verify(signature)) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
    }

    public void generateKeys() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA", "SUN");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            keyGen.initialize(1024, random);
            KeyPair pair = keyGen.generateKeyPair();
            PrivateKey privKey = pair.getPrivate();
            PublicKey pubKey = pair.getPublic();
            FileOutputStream fos = new FileOutputStream("key.private");
            fos.write(privKey.getEncoded());
            fos.close();
            fos = new FileOutputStream("key.public");
            fos.write(pubKey.getEncoded());
            fos.close();
            System.out.println("Generados los ficheros key.private y key.public en la carpeta corriente.");
            System.out.println("Por defecto la aplicaccion las buscara en la carpeta $HOME/.gvsig-keys .");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean canSign() {
        return this.getPrivateKey() != null;
    }

    public boolean canVerify() {
        return this.getPublicKey() != null;
    }
}

