/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing.threads;

import java.util.ArrayList;
import java.util.Iterator;
import org.gvsig.utils.swing.threads.IMonitorableTask;

public class MonitorableTaskQueue
implements IMonitorableTask {
    private ArrayList taskQueue = new ArrayList();
    private boolean canceled = false;
    private IMonitorableTask currentTask = null;

    public void addTask(IMonitorableTask task) {
        this.taskQueue.add(task);
    }

    @Override
    public int getInitialStep() {
        return 0;
    }

    @Override
    public int getFinishStep() {
        int lastStep = 0;
        if (this.isDefined()) {
            for (int i = 0; i < this.taskQueue.size(); ++i) {
                IMonitorableTask task = (IMonitorableTask)this.taskQueue.get(i);
                lastStep += task.getFinishStep();
            }
        } else {
            lastStep += this.taskQueue.size();
        }
        return lastStep;
    }

    @Override
    public int getCurrentStep() {
        int currentStep = 0;
        for (int i = 0; i < this.taskQueue.size(); ++i) {
            IMonitorableTask task = (IMonitorableTask)this.taskQueue.get(i);
            if (task == this.currentTask) {
                if (this.isDefined()) {
                    currentStep += this.currentTask.getCurrentStep();
                    break;
                }
                currentStep = i;
                break;
            }
            if (!this.isDefined()) continue;
            currentStep += this.currentTask.getFinishStep();
        }
        return currentStep++;
    }

    @Override
    public String getStatusMessage() {
        if (this.currentTask != null) {
            return this.currentTask.getStatusMessage();
        }
        return "Waiting for new tasks...";
    }

    @Override
    public String getNote() {
        if (this.currentTask != null) {
            return this.currentTask.getNote();
        }
        return "";
    }

    @Override
    public boolean isDefined() {
        for (int i = 0; i < this.taskQueue.size(); ++i) {
            IMonitorableTask task = (IMonitorableTask)this.taskQueue.get(i);
            if (task.isDefined()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void cancel() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.canceled = true;
    }

    @Override
    public void run() throws Exception {
        System.out.println("lanzando procesos encolados...");
        Iterator taskIterator = this.taskQueue.iterator();
        while (taskIterator.hasNext() && !this.canceled) {
            this.currentTask = (IMonitorableTask)taskIterator.next();
            System.out.println("proceso " + this.currentTask.toString());
            this.currentTask.run();
        }
        System.out.println("Se finalizo la cola de procesos");
    }

    @Override
    public boolean isCanceled() {
        if (this.currentTask != null) {
            return this.currentTask.isCanceled();
        }
        return false;
    }

    @Override
    public boolean isFinished() {
        if (this.currentTask != null) {
            return this.currentTask.isFinished();
        }
        return false;
    }

    @Override
    public void finished() {
    }
}

