/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.utils.swing.wizard.Step;
import org.gvsig.utils.swing.wizard.WizardControl;
import org.gvsig.utils.swing.wizard.WizardEvent;
import org.gvsig.utils.swing.wizard.WizardListener;

public class Wizard
extends JPanel
implements WizardControl {
    private JPanel jPanel = null;
    private JButton btnBack = null;
    private JButton btnNext = null;
    private JButton btnFinish = null;
    private JButton btnCancel = null;
    private ArrayList steps = new ArrayList();
    private int currentStep = 0;
    private JPanel pnlSteps = null;
    private ArrayList listeners = new ArrayList();

    public Wizard(String backText, String nextText, String finishText, String cancelText) {
        this.initialize(backText, nextText, finishText, cancelText);
    }

    public void addWizardListener(WizardListener listener) {
        this.listeners.add(listener);
    }

    public void removeWizardListener(WizardListener listener) {
        this.listeners.remove(listener);
    }

    private void callCancelListener() {
        for (WizardListener element : this.listeners) {
            element.cancel(new WizardEvent(this, this.currentStep));
        }
    }

    private void callFinishListener() {
        for (WizardListener element : this.listeners) {
            element.finished(new WizardEvent(this, this.currentStep));
        }
    }

    private void callNextListener() {
        for (WizardListener element : this.listeners) {
            element.next(new WizardEvent(this, this.currentStep));
        }
    }

    private void callBackListener() {
        for (WizardListener element : this.listeners) {
            element.back(new WizardEvent(this, this.currentStep));
        }
    }

    private void initialize(String backText, String nextText, String finishText, String cancelText) {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.add((Component)this.getJPanel(backText, nextText, finishText, cancelText), "South");
        this.add((Component)this.getPnlSteps(), "Center");
    }

    public void addStep(Step s) {
        if (!(s instanceof JComponent)) {
            throw new RuntimeException("Step must be a visual component (descend from JComponent)");
        }
        this.getPnlSteps().add((Component)((JComponent)((Object)s)), "Center");
        this.steps.add(s);
        this.disableButtons();
        s.init(this);
    }

    private void disableButtons() {
        this.btnNext.setEnabled(false);
        this.btnBack.setEnabled(false);
        this.btnFinish.setEnabled(false);
    }

    @Override
    public void enableNext(boolean enabled) {
        if (this.currentStep == this.steps.size() - 1) {
            this.btnFinish.setEnabled(enabled);
        } else {
            this.btnNext.setEnabled(enabled);
        }
    }

    @Override
    public void enableBack(boolean enabled) {
        if (this.currentStep != 0) {
            this.btnBack.setEnabled(enabled);
        }
    }

    private JPanel getJPanel(String backText, String nextText, String finishText, String cancelText) {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getBtnBack(backText), null);
            this.jPanel.add((Component)this.getBtnNext(nextText), null);
            this.jPanel.add((Component)this.getBtnFinish(finishText), null);
            this.jPanel.add((Component)this.getBtnCancel(cancelText), null);
        }
        return this.jPanel;
    }

    private JButton newJButton(String text) {
        return ToolsSwingLocator.getUsabilitySwingManager().createJButton(text);
    }

    public JButton getBtnBack(String text) {
        if (this.btnBack == null) {
            this.btnBack = this.newJButton(text);
            this.btnBack.setText(text);
            this.btnBack.setMargin(new Insets(2, 2, 2, 2));
            this.btnBack.setEnabled(false);
            this.btnBack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.backStep();
                }
            });
        }
        return this.btnBack;
    }

    public JButton getBtnNext(String text) {
        if (this.btnNext == null) {
            this.btnNext = this.newJButton(text);
            this.btnNext.setText(text);
            this.btnNext.setMargin(new Insets(2, 2, 2, 2));
            this.btnNext.setEnabled(false);
            this.btnNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.nextStep();
                }
            });
        }
        return this.btnNext;
    }

    public JButton getBtnFinish(String text) {
        if (this.btnFinish == null) {
            this.btnFinish = this.newJButton(text);
            this.btnFinish.setMargin(new Insets(2, 2, 2, 2));
            this.btnFinish.setText(text);
            this.btnFinish.setEnabled(false);
            this.btnFinish.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.callFinishListener();
                }
            });
        }
        return this.btnFinish;
    }

    public JButton getBtnCancel(String text) {
        if (this.btnCancel == null) {
            this.btnCancel = this.newJButton(text);
            this.btnCancel.setMargin(new Insets(2, 2, 2, 2));
            this.btnCancel.setText(text);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.callCancelListener();
                }
            });
        }
        return this.btnCancel;
    }

    private JPanel getPnlSteps() {
        if (this.pnlSteps == null) {
            this.pnlSteps = new JPanel();
            this.pnlSteps.setLayout(new CardLayout());
        }
        return this.pnlSteps;
    }

    @Override
    public void nextStep() {
        ++this.currentStep;
        ((CardLayout)this.getPnlSteps().getLayout()).next(this.getPnlSteps());
        this.disableButtons();
        this.callNextListener();
    }

    @Override
    public void backStep() {
        --this.currentStep;
        ((CardLayout)this.getPnlSteps().getLayout()).previous(this.getPnlSteps());
        this.disableButtons();
        this.callBackListener();
    }

    @Override
    public void cancel() {
        this.callCancelListener();
    }

    @Override
    public void finish() {
        this.callFinishListener();
    }

    public Step[] getSteps() {
        return this.steps.toArray(new Step[0]);
    }

    @Override
    public Step getCurrentStep() {
        return this.getSteps()[this.currentStep];
    }
}

