/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.exolab.castor.util.ObjectFactory;

public class DefaultObjectFactory
implements ObjectFactory {
    public Object createInstance(Class type) throws IllegalAccessException, InstantiationException {
        return type.newInstance();
    }

    public Object createInstance(Class type, Object[] args) throws IllegalAccessException, InstantiationException {
        if (args == null || args.length == 0) {
            return type.newInstance();
        }
        return this.createInstance(type, null, args);
    }

    public Object createInstance(Class type, Class[] argTypes, Object[] args) throws IllegalAccessException, InstantiationException {
        if (args == null || args.length == 0) {
            return type.newInstance();
        }
        if (argTypes == null) {
            argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) {
                    String err = "null arguments to constructor not accepted if the 'argTypes' array is null.";
                    throw new IllegalStateException(this.getClass().getName() + ": " + err);
                }
                argTypes[i] = args[i].getClass();
            }
        } else if (argTypes.length != args.length) {
            String err = "The argument type array must be the same length as argument value array.";
            throw new IllegalArgumentException(this.getClass().getName() + ": " + err);
        }
        try {
            Constructor cons = type.getConstructor(argTypes);
            return cons.newInstance(args);
        }
        catch (NoSuchMethodException nsmx) {
            String err = "unable to find matching public constructor for class: " + type.getName();
            err = err + " with argument types: ";
            for (int i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    err = err + ", ";
                }
                err = err + argTypes[i].getName();
            }
            throw new InstantiationException(err);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(ite.getMessage());
        }
    }
}

