/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableCodes;
import org.gvsig.expressionevaluator.Optimizer;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.DefaultCodeBuilder;
import org.gvsig.expressionevaluator.impl.DefaultInterpreter;

public class DefaultOptimizer
implements Optimizer {
    private final OptimizerSymbolTable symbolTable;
    private Interpreter interpreter;
    private CodeBuilder codeBuilder;
    protected ExpressionEvaluatorManager manager;

    public DefaultOptimizer(ExpressionEvaluatorManager manager) {
        this.manager = manager;
        this.symbolTable = new OptimizerSymbolTable();
    }

    public DefaultOptimizer(ExpressionEvaluatorManager manager, SymbolTable symbolTable) {
        this(manager);
        this.symbolTable.setSymbolTable(symbolTable);
    }

    public void setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable.setSymbolTable(symbolTable);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public Interpreter getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = new DefaultInterpreter();
            this.interpreter.setSymbolTable((SymbolTable)this.symbolTable);
        }
        return this.interpreter;
    }

    public CodeBuilder getCodeBuilder() {
        if (this.codeBuilder == null) {
            this.codeBuilder = new DefaultCodeBuilder(this.manager);
        }
        return this.codeBuilder;
    }

    public Code optimize(SymbolTable symbolTable, Code code) {
        this.setSymbolTable(symbolTable);
        return this.optimize(code);
    }

    public Code optimize(Code code) {
        code = this.doOptimize(code);
        return code;
    }

    private Code doOptimize(Code code) {
        if (code == null) {
            return null;
        }
        switch (code.code()) {
            case 2: {
                Code.Callable caller = (Code.Callable)code;
                Function function = caller.function();
                if (function == null) {
                    function = this.getSymbolTable().function(caller.name());
                    caller.function(function);
                }
                if (function instanceof Optimizer.FunctionOptimizer) {
                    return ((Optimizer.FunctionOptimizer)caller.function()).optimize((Optimizer)this, caller);
                }
                switch (caller.type()) {
                    case 1: {
                        Code op1 = this.doOptimize((Code)caller.parameters().get(0));
                        Code op2 = this.doOptimize((Code)caller.parameters().get(1));
                        if (function != null && function.allowConstantFolding()) {
                            if (op1.code() == 0 && op2.code() == 0) {
                                Object value = this.getInterpreter().run(code);
                                Code.Constant newCode = this.getCodeBuilder().constant(value);
                                return newCode;
                            }
                            Code.Callable newCode = this.getCodeBuilder().operator(caller.name(), op1, op2);
                            return newCode;
                        }
                    }
                    case 2: {
                        Code op1 = this.doOptimize((Code)caller.parameters().get(0));
                        if (function != null && function.allowConstantFolding() && op1.code() == 0) {
                            Object value = this.getInterpreter().run(code);
                            Code.Constant newCode = this.getCodeBuilder().constant(value);
                            return newCode;
                        }
                        return code;
                    }
                }
                MutableCodes newArgs = null;
                boolean canOptimize = true;
                if (caller.parameters() != null) {
                    newArgs = this.getCodeBuilder().args();
                    Codes parameters = caller.parameters();
                    for (int i = 0; i < parameters.size(); ++i) {
                        Code arg = (Code)parameters.get(i);
                        if (arg == null) {
                            newArgs.add(null);
                            continue;
                        }
                        Code newArg = this.doOptimize(arg);
                        newArgs.add(newArg);
                        if (newArg.code() == 0) continue;
                        canOptimize = false;
                    }
                }
                if (canOptimize && function != null && function.allowConstantFolding()) {
                    Object value = this.getInterpreter().run(code);
                    Code.Constant newCode = this.getCodeBuilder().constant(value);
                    return newCode;
                }
                Code.Callable newCode = this.getCodeBuilder().function(caller.name(), caller.type(), (Codes)newArgs);
                return newCode;
            }
        }
        return code;
    }

    private static class OptimizerSymbolTable
    implements SymbolTable {
        private SymbolTable symbolTable;

        public SymbolTable getSymbolTable() {
            return this.symbolTable;
        }

        public void setSymbolTable(SymbolTable symbolTable) {
            this.symbolTable = symbolTable;
        }

        public String getName() {
            return "Optimizer";
        }

        public boolean addSymbolTable(SymbolTable symbolTable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean containsSymbolTable(SymbolTable symbolTable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean removeSymbolTable(SymbolTable symbolTable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Function function(String name) {
            return this.symbolTable.function(name);
        }

        public boolean exists(String name) {
            return false;
        }

        public Object value(String name) {
            return null;
        }

        public boolean isSQLCompatible(String name) {
            return false;
        }

        public Collection<String> variables() {
            return Collections.EMPTY_LIST;
        }

        public Collection<Function> functions() {
            return this.symbolTable.functions();
        }

        public Collection<Function> localfunctions() {
            return this.symbolTable.functions();
        }

        public SymbolTable clone() throws CloneNotSupportedException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Iterator<Function> iterator() {
            return this.symbolTable.iterator();
        }

        public Collection<String> localvariables() {
            return null;
        }
    }
}

