/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.date;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class DateDiffFunction
extends AbstractFunction {
    public DateDiffFunction() {
        super("Date", "DATEDIFF", Range.is((Comparable)Integer.valueOf(3)), "Returns the difference between two dates", "DATEDIFF({{interval}}, date1, date2)", new String[]{"interval - a string with the value year,month,day,hour,minute,second or millisecond.", "date1 - a Date", "date2 - a Date"}, "Long");
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        String interval = this.getStr(args, 0);
        LocalDateTime date1 = this.getLocalDateTime(args, 1);
        LocalDateTime date2 = this.getLocalDateTime(args, 2);
        if (date1 == null || date2 == null) {
            return null;
        }
        switch (interval.toLowerCase()) {
            case "millisecond": 
            case "ms": {
                Duration d = Duration.between(date1, date2);
                return d.toMillis();
            }
            case "second": 
            case "ss": 
            case "s": {
                Duration d = Duration.between(date1, date2);
                return d.getSeconds();
            }
            case "minute": 
            case "mi": 
            case "n": {
                Duration d = Duration.between(date1, date2);
                return d.toMinutes();
            }
            case "hour": 
            case "hh": {
                Duration d = Duration.between(date1, date2);
                return d.toHours();
            }
            case "day": 
            case "dy": 
            case "y": {
                Duration d = Duration.between(date1, date2);
                return d.toDays();
            }
            case "month": 
            case "mm": 
            case "m": {
                Period p = Period.between(date1.toLocalDate(), date2.toLocalDate());
                return (long)p.getMonths();
            }
            case "year": 
            case "yyyy": 
            case "yy": {
                Period p = Period.between(date1.toLocalDate(), date2.toLocalDate());
                return (long)p.getYears();
            }
        }
        throw new IllegalArgumentException("Unsupported interval '" + interval + "'.");
    }
}

