/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class IncrFunction
extends AbstractFunction {
    public IncrFunction() {
        super("Numeric", "INCR", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), "Increase the value of the indicated identifier and return its value.", "INCR('CONTADOR#1')", new String[]{"identifier name - the identifier used as counter.", "first value - Optional. The value with which the identifier must be initialized in its first use. By default zero", "step - Optional. The value used to increase the identifier. By default one"}, "Long", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        String identifierName = this.getStr(args, 0);
        long firstValue = 0L;
        long increment = 1L;
        switch (args.length) {
            default: {
                break;
            }
            case 2: {
                firstValue = this.getLong(args, 1);
                break;
            }
            case 3: {
                firstValue = this.getLong(args, 1);
                increment = this.getLong(args, 2);
            }
        }
        MutableSymbolTable symbolTable = (MutableSymbolTable)interpreter.getSymbolTable();
        long value = symbolTable.exists(identifierName) ? ((Number)symbolTable.value(identifierName)).longValue() + increment : firstValue;
        symbolTable.setVar(identifierName, (Object)value);
        return value;
    }
}

