/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import java.math.BigDecimal;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class ModFunction
extends AbstractFunction {
    public ModFunction() {
        super("Numeric", "MOD", Range.is((Comparable)Integer.valueOf(2)), "Returns the remainder of a number divided by another number.\n", "MOD({{a}}, b)", null, "Integer", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object op1 = args[0];
        Object op2 = args[1];
        int type = this.getType(op1, op2);
        if ((type & 0x100) == 256) {
            BigDecimal value = this.getBigDecimal(op1, 1).remainder(this.getBigDecimal(op2, 2));
            return value;
        }
        if ((type & 8) == 8) {
            double value = this.getDouble(op1, 1) % this.getDouble(op2, 2);
            return value;
        }
        if ((type & 4) == 4) {
            double value = this.getFloat(op1, 1) % this.getFloat(op2, 2);
            return value;
        }
        if ((type & 2) == 2) {
            long value = this.getLong(op1, 1) % this.getLong(op2, 2);
            return value;
        }
        if ((type & 1) == 1) {
            int value = this.getInt(op1, 1) % this.getInt(op2, 2);
            return value;
        }
        throw new IllegalArgumentException("Types not allowed in '" + this.name() + "' operand.");
    }
}

