/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.operator;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.math.util.MathUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.operator.AbstractBinaryOperator;

public class IsOperator
extends AbstractBinaryOperator {
    public IsOperator() {
        super("Boolean", "IS", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public Object call(Interpreter interpreter, Object op1, Object op2) {
        int type = this.getType(op1, op2);
        if ((type & 0x80) == 128) {
            return op1 == op2;
        }
        if ((type & 0x100) == 256) {
            boolean value = this.getBigDecimal(op1, 1).compareTo(this.getBigDecimal(op2, 2)) == 0;
            return value;
        }
        if ((type & 8) == 8) {
            boolean value = MathUtils.compareTo((double)((Number)op1).doubleValue(), (double)((Number)op2).doubleValue(), (double)(interpreter.getAccuracy() == null ? (double)1.110223E-16f : interpreter.getAccuracy())) == 0;
            return value;
        }
        if ((type & 4) == 4) {
            boolean value = MathUtils.compareTo((double)((Number)op1).floatValue(), (double)((Number)op2).floatValue(), (double)(interpreter.getAccuracy() == null ? (double)1.110223E-16f : interpreter.getAccuracy())) == 0;
            return value;
        }
        if ((type & 2) == 2) {
            boolean value = ((Number)op1).longValue() == ((Number)op2).longValue();
            return value;
        }
        if ((type & 1) == 1) {
            boolean value = ((Number)op1).intValue() == ((Number)op2).intValue();
            return value;
        }
        if (op2 instanceof Comparable && op2 instanceof Comparable) {
            boolean value = ObjectUtils.compare((Comparable)((Comparable)op1), (Comparable)((Comparable)op2)) == 0;
            return value;
        }
        throw new IllegalArgumentException("Types not allowed in '" + this.name() + "' operand.");
    }
}

