/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.expressionevaluator.spi.JsonUtils;
import org.gvsig.json.Json;
import org.gvsig.tools.util.GetItemByKey;
import org.gvsig.tools.util.GetItemWithSize;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

public class CreateChartPanelFunction
extends AbstractFunction {
    public CreateChartPanelFunction() {
        super("Programming", "CREATE_CHARTPANEL", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), "", "CREATE_CHARTPANEL({{string}})", null, "ChartPanel", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Object obj = this.getObject(args, 0);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof JsonObject)) {
            obj = JsonUtils.toJsonObject((Object)obj);
        }
        Iterable<GetItemByKey> dataset = null;
        if (args.length > 0) {
            dataset = CreateChartPanelFunction.getIterable(this.getObject(args, 1));
        }
        JsonObject jsonobj = (JsonObject)obj;
        JFreeChart graph = CreateChartPanelFunction.createGraph(jsonobj, dataset);
        ChartPanel graphpanel = CreateChartPanelFunction.createGraphPanel(jsonobj, graph);
        return graphpanel;
    }

    public static Iterable<GetItemByKey> getIterable(Object dataset) {
        if (dataset instanceof GetItemWithSize) {
            final GetItemWithSize values = (GetItemWithSize)dataset;
            return new Iterable<GetItemByKey>(){

                @Override
                public Iterator<GetItemByKey> iterator() {
                    return new Iterator<GetItemByKey>(){
                        int n = 0;

                        @Override
                        public boolean hasNext() {
                            return this.n < values.size();
                        }

                        @Override
                        public GetItemByKey next() {
                            return (GetItemByKey)values.get(this.n++);
                        }
                    };
                }
            };
        }
        if (dataset instanceof Iterable) {
            return (Iterable)dataset;
        }
        throw new ExpressionRuntimeException("dataset type not supported");
    }

    public static ChartPanel createGraphPanel(JsonObject json, JFreeChart graph) {
        ChartPanel chartPanel = new ChartPanel(graph);
        chartPanel.setPreferredSize(new Dimension(json.getInt("witdh", 360), json.getInt("height", 200)));
        return chartPanel;
    }

    public static BufferedImage createChartImage(JsonObject json, JFreeChart chart) {
        BufferedImage image = chart.createBufferedImage(CreateChartPanelFunction.getInt((JsonValue)json.get((Object)"witdh"), 360), CreateChartPanelFunction.getInt((JsonValue)json.get((Object)"height"), 200), null);
        return image;
    }

    private static CategoryDataset getCategoryDataset(JsonArray datasetJson) {
        if (datasetJson == null) {
            throw new IllegalArgumentException("Parameter dataset required.");
        }
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        for (JsonValue jsonValue : datasetJson) {
            JsonArray element = (JsonArray)jsonValue;
            double value = element.getJsonNumber(0).doubleValue();
            String field1 = element.getString(1, null);
            String field2 = element.getString(2, null);
            ds.addValue(value, (Comparable)((Object)field1), (Comparable)((Object)field2));
        }
        return ds;
    }

    private static CategoryDataset getCategoryDataset(Iterable<GetItemByKey> dataset, String valueName, String fieldName1, String fieldName2) {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        for (GetItemByKey element : dataset) {
            try {
                ds.addValue(NumberUtils.toDouble((String)Objects.toString(element.get((Object)valueName), null), (double)Double.NaN), (Comparable)((Object)Objects.toString(element.get((Object)fieldName1), null)), (Comparable)((Object)Objects.toString(element.get((Object)fieldName2), null)));
            }
            catch (Exception ex) {
                throw new RuntimeException("Not able to retrieve values", ex);
            }
        }
        return ds;
    }

    private static PlotOrientation getOrientation(String orientation) {
        if (StringUtils.isBlank((CharSequence)orientation)) {
            return PlotOrientation.VERTICAL;
        }
        switch (orientation.toUpperCase()) {
            case "HORIZONTAL": {
                return PlotOrientation.HORIZONTAL;
            }
        }
        return PlotOrientation.VERTICAL;
    }

    private static boolean getBoolean(JsonValue value) {
        if (value == null) {
            return false;
        }
        String s = Objects.toString(Json.toObject((JsonValue)value), null);
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        return BooleanUtils.toBoolean((String)s);
    }

    private static int getInt(JsonValue value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        Object o = Json.toObject((JsonValue)value);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return NumberUtils.createInteger((String)Objects.toString(o, null));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static JFreeChart createGraph(JsonObject json, Iterable<GetItemByKey> dataset) {
        String chartType;
        switch (chartType = json.getString("chartType").toLowerCase()) {
            case "boxandwhisker": {
                String valueField = json.getString("valueField");
                HashMap tree = new HashMap();
                String field1 = json.getString("field1");
                String field2 = json.getString("field2");
                for (GetItemByKey getItemByKey : dataset) {
                    ArrayList<Double> list;
                    String rowValue = Objects.toString(getItemByKey.get((Object)field1), null);
                    String colValue = Objects.toString(getItemByKey.get((Object)field2), null);
                    double elementValue = NumberUtils.toDouble((String)Objects.toString(getItemByKey.get((Object)valueField), null));
                    if (tree.containsKey(rowValue)) {
                        HashMap colTree = (HashMap)tree.get(rowValue);
                        if (colTree.containsKey(colValue)) {
                            ((List)colTree.get(colValue)).add(elementValue);
                            continue;
                        }
                        list = new ArrayList();
                        list.add(elementValue);
                        colTree.put(colValue, list);
                        continue;
                    }
                    HashMap e = new HashMap();
                    list = new ArrayList<Double>();
                    list.add(elementValue);
                    e.put(colValue, list);
                    tree.put(rowValue, e);
                }
                DefaultBoxAndWhiskerCategoryDataset ds = new DefaultBoxAndWhiskerCategoryDataset();
                for (String rowKey : tree.keySet()) {
                    for (String colKey : ((HashMap)tree.get(rowKey)).keySet()) {
                        ds.add((List)((HashMap)tree.get(rowKey)).get(colKey), (Comparable)((Object)rowKey), (Comparable)((Object)colKey));
                    }
                }
                JFreeChart jFreeChart = ChartFactory.createBoxAndWhiskerChart((String)json.getString("title", ""), (String)json.getString("categoryAxisLabel", ""), (String)json.getString("valueAxisLabel", ""), (BoxAndWhiskerCategoryDataset)ds, (boolean)json.getBoolean("legend", true));
                return jFreeChart;
            }
            case "barchart": {
                CategoryDataset ds = dataset == null ? CreateChartPanelFunction.getCategoryDataset(json.getJsonArray("dataset")) : CreateChartPanelFunction.getCategoryDataset(dataset, json.getString("valueField"), json.getString("field1"), json.getString("field2"));
                JFreeChart barChart = ChartFactory.createBarChart((String)json.getString("title", ""), (String)json.getString("categoryAxisLabel", ""), (String)json.getString("valueAxisLabel", ""), (CategoryDataset)ds, (PlotOrientation)CreateChartPanelFunction.getOrientation(json.getString("orientation", null)), (boolean)CreateChartPanelFunction.getBoolean((JsonValue)json.get((Object)"legend")), (boolean)false, (boolean)false);
                return barChart;
            }
            case "linechart": {
                CategoryDataset ds = dataset == null ? CreateChartPanelFunction.getCategoryDataset(json.getJsonArray("dataset")) : CreateChartPanelFunction.getCategoryDataset(dataset, json.getString("valueField"), json.getString("field1"), json.getString("field2"));
                JFreeChart barChart = ChartFactory.createLineChart((String)json.getString("title", ""), (String)json.getString("categoryAxisLabel", ""), (String)json.getString("valueAxisLabel", ""), (CategoryDataset)ds, (PlotOrientation)CreateChartPanelFunction.getOrientation(json.getString("orientation", null)), (boolean)CreateChartPanelFunction.getBoolean((JsonValue)json.get((Object)"legend")), (boolean)false, (boolean)false);
                return barChart;
            }
        }
        throw new IllegalArgumentException("Unknown chart type:" + chartType);
    }
}

