/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.expressionevaluator.spi.JsonUtils;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.GetItem64;
import org.gvsig.tools.util.GetItemByKey;
import org.gvsig.tools.util.PropertiesSupport;

public class GetitemFunction
extends AbstractFunction {
    public GetitemFunction() {
        super("Programming", "GETITEM", Range.is((Comparable)Integer.valueOf(2)), null, "GETITEM({{object}}, index_or_key)", null, "Object", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Object value;
        Object obj = this.getObject(args, 0);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            List l = (List)obj;
            int index = this.getInt(args, 1);
            if (index < 0) {
                index = l.size() + index;
            }
            value = l.get(index);
        } else if (obj instanceof Object[]) {
            Object[] a = (Object[])obj;
            int index = this.getInt(args, 1);
            if (index < 0) {
                index = a.length + index;
            }
            value = a[index];
        } else if (obj instanceof CharSequence) {
            CharSequence s = (CharSequence)obj;
            int index = this.getInt(args, 1);
            if (index < 0) {
                index = s.length() + index;
            }
            value = s.subSequence(index, index + 1);
        } else if (obj instanceof Map) {
            Map m = (Map)obj;
            Object index = this.getObject(args, 1);
            value = m.get(index);
        } else if (obj instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)obj;
            int index = this.getInt(args, 1);
            if (index < 0) {
                index = jsonArray.size() + index;
            }
            value = JsonUtils.getitem((JsonArray)jsonArray, (int)index);
        } else if (obj instanceof JsonObject) {
            JsonObject jsonobj = (JsonObject)obj;
            String name = this.getStr(args, 1);
            value = JsonUtils.getitem((JsonObject)jsonobj, (String)name);
        } else if (obj instanceof GetItem) {
            GetItem l = (GetItem)obj;
            int index = this.getInt(args, 1);
            value = l.get(index);
        } else if (obj instanceof GetItem64) {
            GetItem64 l = (GetItem64)obj;
            long index = this.getLong(args, 1);
            value = l.get64(index);
        } else if (obj instanceof GetItemByKey) {
            GetItemByKey l = (GetItemByKey)obj;
            Object key = this.getObject(args, 1);
            value = l.get(key);
        } else if (obj instanceof PropertiesSupport) {
            PropertiesSupport l = (PropertiesSupport)obj;
            String propName = this.getStr(args, 1);
            value = l.getProperty(propName);
        } else {
            throw new ExpressionRuntimeException("The GETITEM function require a String, List or Map and a received a '" + obj.getClass().getSimpleName() + "'.");
        }
        return value;
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        StringBuilder builder = new StringBuilder();
        Code arg0 = (Code)args.get(0);
        Code arg1 = (Code)args.get(1);
        builder.append(arg0.toString(formatter));
        builder.append("[");
        builder.append(arg1.toString(formatter));
        builder.append("]");
        return builder.toString();
    }
}

