/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.wizard;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.Files;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.impl.creation.DefaultMakePluginPackageWizard;
import org.gvsig.installer.swing.impl.creation.panel.DefaultOutputPanel;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectOutputFileWizard
extends DefaultOutputPanel
implements OptionPanel {
    private static final long serialVersionUID = 555020268506822671L;
    private DefaultMakePluginPackageWizard installerCreationWizard;
    private static final Logger logger = LoggerFactory.getLogger(SelectOutputFileWizard.class);

    public SelectOutputFileWizard(DefaultMakePluginPackageWizard installerCreationWizard) {
        this.installerCreationWizard = installerCreationWizard;
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.swingInstallerManager.getText("_output_options");
    }

    public void lastPanel() {
    }

    public void nextPanel() throws NotContinueWizardException {
        try {
            File file = this.getPackageFile();
            File filePath = new File(file.getParent());
            if (!filePath.exists()) {
                JOptionPane.showMessageDialog(this.installerCreationWizard, this.swingInstallerManager.getText("_the_package_file_folder_does_not_exist") + ": " + filePath);
                throw new NotContinueWizardException("", null, false);
            }
            if (this.isCreatePackageIndex()) {
                URL url = this.getDownloadURL();
                if (url == null) {
                    throw new NotContinueWizardException("", null, false);
                }
                this.installerCreationWizard.setDownloadURL(url);
                File indexFile = this.getPackageIndexFile();
                File indexFilePath = new File(indexFile.getParent());
                if (!indexFilePath.exists()) {
                    JOptionPane.showMessageDialog(this.installerCreationWizard, this.swingInstallerManager.getText("_the_package_index_file_folder_does_not_exist") + ": " + indexFilePath);
                    throw new NotContinueWizardException("", null, false);
                }
                this.installerCreationWizard.setIndexOutputStream(new FileOutputStream(indexFile));
            }
            this.installerCreationWizard.setOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            logger.info(this.swingInstallerManager.getText("Create output file exception"), (Throwable)e);
            JOptionPane.showMessageDialog(this.installerCreationWizard, this.swingInstallerManager.getText("_create_output_file_exception"));
        }
    }

    public void updatePanel() {
        this.setPackageFile(this.getDefaultPackageBundleFile());
        this.setPackageIndexFile(this.getDefaultPackageIndexBundleFile());
    }

    private File getDefaultPackageBundleFile() {
        File installsFolder = this.installerCreationWizard.getInstallFolder();
        if (!Files.isWritable(installsFolder.toPath())) {
            installsFolder = ToolsLocator.getFoldersManager().getHome();
        }
        PackageInfo info = this.installerCreationWizard.getSelectedPackageInfo();
        String fileName = InstallerLocator.getInstallerManager().getPackageFileName(info);
        return new File(installsFolder, fileName);
    }

    private File getDefaultPackageIndexBundleFile() {
        File installsFolder = this.installerCreationWizard.getInstallFolder();
        PackageInfo info = this.installerCreationWizard.getSelectedPackageInfo();
        String fileName = InstallerLocator.getInstallerManager().getPackageIndexFileName(info);
        return new File(installsFolder, fileName);
    }

    @Override
    protected PackageInfo getPackageInfo() {
        PackageInfo info = this.installerCreationWizard.getSelectedPackageInfo();
        return info;
    }
}

