/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution;

import java.awt.BorderLayout;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.execution.PackageFilter;
import org.gvsig.installer.swing.impl.execution.InstallWizardPanel_ext;
import org.gvsig.installer.swing.impl.execution.panel.SelectBundlesPanel;
import org.gvsig.installer.swing.impl.execution.wizard.AddBundlesWizardPage;
import org.gvsig.installer.swing.impl.execution.wizard.DownloadProgressWizardPage;
import org.gvsig.installer.swing.impl.execution.wizard.InstallersWizardPage;
import org.gvsig.installer.swing.impl.execution.wizard.ProgressWizardPage;
import org.gvsig.installer.swing.impl.execution.wizard.SelectBundlesWizardPage;
import org.gvsig.installer.swing.impl.execution.wizard.SelectPackagesWizardPage;
import org.gvsig.installer.swing.impl.execution.wizard.TypicalOrAdvancedWizardPage;
import org.gvsig.installer.swing.impl.wizard.AbstractInstallerWizardPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInstallWizardPanel
extends AbstractInstallerWizardPanel
implements InstallWizardPanel_ext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInstallWizardPanel.class);
    private static final long serialVersionUID = 554068938842141497L;
    private static final int TYPICAL_MODE = 0;
    private static final int ADVANCED_MODE = 1;
    private int installationMode = 1;
    private boolean skipTypicalOrAdvancedWizardPage = false;
    private boolean skipSelectBundleWizardPage = false;
    private boolean selectDefaultPackages;
    private final I18nManager i18nManager = ToolsLocator.getI18nManager();
    private PackageFilter packageFilter;
    private InstallPackageService installerExecutionService = null;
    private SelectBundlesWizardPage selectInstallersWizard = null;
    private InstallersWizardPage installersWizard = null;
    private SelectPackagesWizardPage selectPluginsWizard = null;
    private ProgressWizardPage progressWizard = null;
    private DownloadProgressWizardPage downloadProgressWizard = null;
    private TypicalOrAdvancedWizardPage typicalOrAdvancedWizard = null;
    private AddBundlesWizardPage addBundlesWizard;

    public DefaultInstallWizardPanel(File applicationFolder, File installFolder) {
        super(applicationFolder, installFolder);
    }

    public JComponent asJComponent() {
        if (this.needInitilization()) {
            this.initComponents();
        }
        return this;
    }

    @Override
    public InstallPackageService getInstallerExecutionService() {
        if (this.needInitilization()) {
            this.initComponents();
        }
        return this.installerExecutionService;
    }

    private boolean needInitilization() {
        return this.selectPluginsWizard == null;
    }

    @Override
    protected void initComponents() {
        if (this.needInitilization()) {
            try {
                this.installerExecutionService = InstallerLocator.getInstallerManager().getInstallPackageService();
            }
            catch (InstallPackageServiceException ex) {
                LOG.warn("Can't create the InstallerExecutionService.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            List downloadURLs = SwingInstallerLocator.getSwingInstallerManager().getDefaultDownloadUrlAndLabels();
            this.selectInstallersWizard = new SelectBundlesWizardPage(this, downloadURLs);
            this.addBundlesWizard = new AddBundlesWizardPage(this);
            this.typicalOrAdvancedWizard = new TypicalOrAdvancedWizardPage(this);
            this.selectPluginsWizard = new SelectPackagesWizardPage(this);
            this.progressWizard = new ProgressWizardPage(this);
            this.downloadProgressWizard = new DownloadProgressWizardPage(this);
            this.installersWizard = new InstallersWizardPage(this);
            this.addWizards();
            this.setFinishButtonEnabled(false);
            this.setLayout(new BorderLayout());
            super.initComponents();
        }
    }

    private void addWizards() {
        this.addOptionPanel(this.typicalOrAdvancedWizard);
        this.addOptionPanel(this.selectInstallersWizard);
        this.addOptionPanel(this.addBundlesWizard);
        this.addOptionPanel(this.installersWizard);
        this.addOptionPanel(this.selectPluginsWizard);
        this.addOptionPanel(this.downloadProgressWizard);
        this.addOptionPanel(this.progressWizard);
    }

    @Override
    public SelectBundlesPanel getBundlesPanel() {
        if (this.needInitilization()) {
            this.initComponents();
        }
        return this.selectInstallersWizard;
    }

    @Override
    public void installFromDefaultDirectory() throws InstallPackageServiceException {
        if (this.needInitilization()) {
            this.initComponents();
        }
        this.getWizardComponents().removeWizardPanel(0);
        this.installerExecutionService.addBundlesFromDirectory(this.getInstallFolder(), null);
        this.selectPluginsWizard.updatePanel();
    }

    @Override
    public List<PackageInfo> getPackagesToInstall() {
        if (this.needInitilization()) {
            this.initComponents();
        }
        return this.selectPluginsWizard.getPackagesToInstall();
    }

    public void setSelectDefaultPackages(boolean isActivated) {
        this.selectDefaultPackages = isActivated;
    }

    public boolean getSelectDefaultPackages() {
        return this.selectDefaultPackages;
    }

    @Override
    public void setSkipSelectPackagesWizardPage(boolean skip) {
        if (skip) {
            this.installationMode = 0;
            this.selectDefaultPackages = true;
        } else {
            this.installationMode = 1;
        }
    }

    @Override
    public boolean getSkipSelectPackagesWizardPage() {
        return this.installationMode == 0;
    }

    public boolean getSkipTypicalOrAdvancedWizardPage() {
        return this.skipTypicalOrAdvancedWizardPage;
    }

    public void setSkipTypicalOrAdvancedWizardPage(boolean skip) {
        this.skipTypicalOrAdvancedWizardPage = skip;
        if (skip) {
            this.installationMode = 0;
        }
    }

    public void setSkipSelectBundleWizardPage(boolean skip) {
        this.skipSelectBundleWizardPage = skip;
    }

    public boolean getSkipSelectBundleWizardPage() {
        if (!this.getSkipTypicalOrAdvancedWizardPage() && this.installationMode == 0) {
            return true;
        }
        return this.skipSelectBundleWizardPage;
    }

    @Override
    public boolean needsToRestartApplicationAfterFinish() {
        return true;
    }

    @Override
    public String getTranslation(String key) {
        return this.i18nManager.getTranslation(key);
    }

    public PackageFilter getPackageFilter() {
        return this.packageFilter;
    }

    public void setPackageFilter(PackageFilter type) {
        this.packageFilter = type;
    }
}

