/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.border;

import com.jeta.forms.components.border.TitledBorderLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class TitledBorderLabelUI
extends ComponentUI {
    protected static final int VERTICAL_PADDING = 2;

    private boolean calcIntersection(Rectangle rect, int x, int y, int width, int height) {
        int x1 = Math.max(x, rect.x);
        int y1 = Math.max(y, rect.y);
        int x2 = Math.min(x + width, rect.x + rect.width);
        int y2 = Math.min(y + height, rect.y + rect.height);
        rect.setBounds(x1, y1, x2 - x1, y2 - y1);
        return rect.width > 0 && rect.height > 0;
    }

    public Dimension getPreferredSize(JComponent c) {
        TitledBorderLabel label;
        String title;
        if (c instanceof TitledBorderLabel && (title = (label = (TitledBorderLabel)c).getText()) != null) {
            Font font = label.getFont();
            FontMetrics metrics = label.getFontMetrics(font);
            int line_height = metrics.getHeight() + 4;
            int line_width = metrics.stringWidth(title) + 10;
            return new Dimension(line_width, line_height);
        }
        return new Dimension(10, 10);
    }

    public void paint(Graphics g, JComponent c) {
        Border border = UIManager.getBorder("TitledBorder.border");
        if (c instanceof TitledBorderLabel && border != null) {
            TitledBorderLabel bordercomp = (TitledBorderLabel)c;
            String title = bordercomp.getText();
            if (title == null) {
                title = "";
            }
            int width = c.getWidth();
            int height = c.getHeight();
            Font oldfont = g.getFont();
            Color oldcolor = g.getColor();
            Insets insets = border.getBorderInsets(c);
            g.setFont(bordercomp.getFont());
            FontMetrics fm = g.getFontMetrics();
            int stringWidth = fm.stringWidth(title);
            int border_y = fm.getAscent() / 2 + 2;
            int text_y = border_y - fm.getDescent() + (insets.top + fm.getAscent() + fm.getDescent()) / 2;
            int text_x = 0;
            int justification = bordercomp.getTitleJustification();
            if (c.getComponentOrientation().isLeftToRight()) {
                if (justification == 5) {
                    justification = 3;
                }
            } else if (justification == 4 || justification == 0) {
                justification = 3;
            }
            text_x = justification == 3 ? width - (stringWidth + insets.right + insets.left) : (justification == 2 ? (width - stringWidth) / 2 : insets.left);
            Rectangle clip = new Rectangle();
            Rectangle oldclip = g.getClipBounds();
            if (title.length() == 0) {
                border.paintBorder(c, g, -12, border_y, width + 24, height + 12);
            } else {
                clip.setBounds(oldclip);
                if (this.calcIntersection(clip, 0, 0, text_x - 1, height)) {
                    g.setClip(clip);
                    border.paintBorder(c, g, -12, border_y, width, height + 12);
                }
                clip.setBounds(oldclip);
                if (this.calcIntersection(clip, text_x + stringWidth + 1, 0, width - (text_x + stringWidth + 1), height)) {
                    g.setClip(clip);
                    border.paintBorder(c, g, 0, border_y, width + 12, height + 12);
                }
                g.setClip(oldclip);
                g.setColor(bordercomp.getTitleColor());
                g.drawString(title, text_x, text_y);
            }
            g.setFont(oldfont);
            g.setColor(oldcolor);
        }
    }
}

