/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.colors;

import com.jeta.forms.colormgr.ColorManager;
import com.jeta.forms.components.colors.ColorSelectorUtils;
import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.registry.JETARegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorDefinitionView
extends JETAPanel {
    private FormPanel m_view;
    private ColorProperty m_color_prop = new ColorProperty();
    private ColorDefinitionController m_controller;
    private JComboBox m_key_combo;
    private Component m_color_well;
    private JSpinner m_factor_spinner;
    private JSpinner m_bright_spinner;
    private static LinkedList m_color_cell_values;
    private static LookAndFeel m_look_and_feel;

    public ColorDefinitionView() {
        try {
            this.m_view = new FormPanel("com/jeta/forms/components/colors/colorSelection.jfrm");
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_view, "Center");
            this.m_color_well = this.m_view.getComponentByName("color.inkwell");
            this.m_key_combo = this.m_view.getComboBox("color.name.combo");
            this.m_key_combo.setRenderer(new ColorCellRenderer());
            this.m_key_combo.setName("color.name.combo");
            this.m_key_combo.removeAllItems();
            Collection cvalues = ColorDefinitionView.getColorCellValues();
            Iterator iter = cvalues.iterator();
            while (iter.hasNext()) {
                this.m_key_combo.addItem(iter.next());
            }
            this.m_factor_spinner = this.m_view.getSpinner("brighter.factor");
            SpinnerNumberModel model = new SpinnerNumberModel(0.7, 0.05, 1.0, 0.05);
            this.m_factor_spinner.setModel(model);
            this.m_bright_spinner = this.m_view.getSpinner("brighter.value");
            model = new SpinnerNumberModel(0, -10, 10, 1);
            this.m_bright_spinner.setModel(model);
            this.m_controller = new ColorDefinitionController();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ColorProperty getColorProperty() {
        try {
            ColorProperty cprop = new ColorProperty();
            cprop.setConstantColor(ColorSelectorUtils.getColor(this.m_color_well));
            cprop.setColorKey(this.getSelectedColorKey());
            Double bfactor = (Double)this.m_factor_spinner.getValue();
            cprop.setBrightnessFactor(bfactor.floatValue());
            Integer b = (Integer)this.m_bright_spinner.getValue();
            cprop.setBrightness(b);
            return cprop;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.m_color_prop;
        }
    }

    private static Collection getColorCellValues() {
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (m_look_and_feel != lf || m_color_cell_values == null) {
            if (m_color_cell_values == null) {
                m_color_cell_values = new LinkedList();
            }
            m_color_cell_values.clear();
            m_look_and_feel = lf;
            ColorManager cmgr = (ColorManager)JETARegistry.lookup("jeta.color.manager");
            Collection cnames = cmgr.getColorKeys();
            Iterator iter = cnames.iterator();
            while (iter.hasNext()) {
                String cname = (String)iter.next();
                m_color_cell_values.add(new ColorCellValue(cname, cmgr.getColor(cname, null)));
            }
        }
        return m_color_cell_values;
    }

    public String getSelectedColorKey() {
        ColorCellValue ccv = (ColorCellValue)this.m_key_combo.getSelectedItem();
        return ccv.getName();
    }

    public void prependColor(String key, Color c) {
        if (key == null) {
            return;
        }
        this.m_key_combo.insertItemAt(new ColorCellValue(key, c), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorProperty(ColorProperty cprop) {
        try {
            this.m_controller.setSilent(true);
            this.m_color_prop.setValue(cprop);
            String color_name = cprop.getColorKey();
            this.setSelectedColor(color_name);
            ColorSelectorUtils.setColor(this.m_color_well, cprop.getColor());
            this.m_factor_spinner.setValue(new Double(cprop.getBrightnessFactor()));
            this.m_bright_spinner.setValue(new Integer(cprop.getBrightness()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.m_controller.setSilent(false);
        }
    }

    public void setSelectedColor(String cname) {
        ComboBoxModel cmodel = this.m_key_combo.getModel();
        for (int index = 0; index < cmodel.getSize(); ++index) {
            if (!cmodel.getElementAt(index).equals(cname)) continue;
            this.m_key_combo.setSelectedIndex(index);
            return;
        }
        this.m_key_combo.setSelectedIndex(0);
    }

    public static class ColorCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ColorCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ColorCellValue ccv = (ColorCellValue)value;
            if (ccv == null) {
                this.setIcon(null);
                this.setText("");
            } else {
                this.setIcon(ccv.getIcon());
                this.setText(ccv.getName());
            }
            if (isSelected) {
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("ComboBox.background"));
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            return this;
        }
    }

    public static class ColorCellValue {
        String m_color_name;
        Color m_color;
        ColorLookup m_color_key = new ColorLookup();
        private static HashMap m_color_icons = new HashMap();

        public ColorCellValue(String cname, Color color) {
            this.m_color_name = cname;
            this.m_color = color;
            if (this.m_color_name == null) {
                this.m_color_name = "constant";
            }
        }

        public boolean equals(Object obj) {
            return this.m_color_name.equals(obj.toString());
        }

        public String getName() {
            return this.m_color_name;
        }

        public Icon getIcon() {
            if (this.m_color == null) {
                return null;
            }
            this.m_color_key.key = this.m_color.getRGB();
            Icon icon = (Icon)m_color_icons.get(this.m_color_key);
            if (icon == null) {
                int width = 12;
                int height = 12;
                BufferedImage bimage = new BufferedImage(width, height, 1);
                Graphics2D bg = bimage.createGraphics();
                bg.setColor(this.m_color);
                bg.fillRect(0, 0, width, height);
                bg.setColor(Color.black);
                bg.drawRect(0, 0, width - 1, height - 1);
                bg.dispose();
                icon = new ImageIcon(bimage);
                m_color_icons.put(new Integer(this.m_color.getRGB()), icon);
            }
            return icon;
        }

        public String toString() {
            return this.m_color_name;
        }
    }

    public static class ColorLookup {
        int key;

        public int hashCode() {
            return this.key;
        }
    }

    private class ColorDefinitionController {
        private boolean m_silent = false;

        public ColorDefinitionController() {
            ColorDefinitionView.this.m_key_combo.addActionListener(new ComboChangedAction());
            ColorSelectorUtils.addActionListener(ColorDefinitionView.this.m_color_well, new ColorWellClicked());
            ColorDefinitionView.this.m_factor_spinner.addChangeListener(new ColorChangedAction());
            ColorDefinitionView.this.m_bright_spinner.addChangeListener(new ColorChangedAction());
        }

        public void setSilent(boolean silent) {
            this.m_silent = silent;
        }

        public class ColorWellClicked
        implements ActionListener {
            public void actionPerformed(ActionEvent evt) {
                boolean silent = ColorDefinitionController.this.m_silent;
                if (!silent) {
                    ColorDefinitionController.this.setSilent(true);
                    ColorDefinitionView.this.m_key_combo.setSelectedIndex(0);
                    ColorDefinitionController.this.setSilent(silent);
                }
            }
        }

        public class ColorChangedAction
        implements ChangeListener {
            public void stateChanged(ChangeEvent e) {
            }
        }

        public class ComboChangedAction
        implements ActionListener {
            public void actionPerformed(ActionEvent evt) {
                boolean silent = ColorDefinitionController.this.m_silent;
                if (!silent) {
                    ColorDefinitionController.this.setSilent(true);
                    ColorDefinitionView.this.m_color_prop.setColorKey(ColorDefinitionView.this.getSelectedColorKey());
                    if (!ColorDefinitionView.this.m_color_prop.isConstant()) {
                        ColorSelectorUtils.setColor(ColorDefinitionView.this.m_color_well, ColorDefinitionView.this.m_color_prop.getColor());
                    }
                    ColorDefinitionController.this.setSilent(silent);
                }
            }
        }
    }
}

