/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.beans;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.JETAPropertyDescriptor;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.store.properties.JETAProperty;
import java.lang.reflect.Method;

public class DynamicPropertyDescriptor
implements JETAPropertyDescriptor {
    private String m_name;
    private Class m_type;
    private boolean m_preferred;
    private boolean m_transient = false;

    public DynamicPropertyDescriptor(String name, Class type, boolean pref, boolean istransient) {
        this.m_name = name;
        this.m_type = type;
        this.m_preferred = pref;
        this.m_transient = istransient;
    }

    public Object getPropertyValue(JETABean bean) throws FormException {
        return bean.getCustomProperty(this.getName());
    }

    public String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getShortDescription() {
        return this.getName();
    }

    public Class getPropertyEditorClass() {
        return null;
    }

    public Class getPropertyType() {
        return this.m_type;
    }

    public Method getWriteMethod() {
        return null;
    }

    public boolean isPreferred() {
        return this.m_preferred;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isTransient() {
        return this.m_transient;
    }

    public boolean isWritable() {
        return true;
    }

    public void setPropertyValue(JETABean bean, Object value) throws FormException {
        JETAProperty old_prop = bean.getCustomProperty(this.getName());
        FormUtils.safeAssert(old_prop != null);
        if (old_prop != null) {
            if (value instanceof JETAProperty && value.getClass() == old_prop.getClass()) {
                JETAProperty prop = (JETAProperty)value;
                if (!this.getName().equals(prop.getName())) {
                    System.out.println("DynamicPropertyDescriptor.setPropertyValue  getName(): " + this.getName() + "  prop.getName(): " + prop.getName());
                    FormUtils.safeAssert(false);
                }
                try {
                    if (FormUtils.isDesignMode()) {
                        prop = (JETAProperty)value.getClass().newInstance();
                        prop.setValue(value);
                        bean.setCustomProperty(this.getName(), prop);
                        prop.updateBean(bean);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            old_prop.setValue(value);
            old_prop.updateBean(bean);
        }
    }

    public void setPreferred(boolean bpref) {
        this.m_preferred = bpref;
    }
}

