/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.beans.factories;

import com.jeta.forms.gui.beans.BeanProperties;
import com.jeta.forms.gui.beans.DynamicBeanInfo;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.factories.BeanFactory;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.properties.CompoundBorderProperty;
import com.jeta.forms.store.properties.DefaultBorderProperty;
import com.jeta.forms.store.properties.ScrollBarsProperty;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;

public class JComponentBeanFactory
implements BeanFactory {
    private Class m_comp_class;
    private String m_short_name;
    private boolean m_scrollable = false;

    public JComponentBeanFactory(Class compClass) {
        this.setBeanClass(compClass);
    }

    public JETABean createBean(String compName, boolean instantiateBean, boolean setDefaults) throws FormException {
        Component comp = null;
        if (instantiateBean) {
            comp = this.instantiateBean();
            comp.setName(compName);
        }
        DynamicBeanInfo beaninfo = JComponentBeanFactory.createBeanInfo(this.m_comp_class);
        BeanProperties default_props = new BeanProperties(beaninfo);
        this.defineProperties(default_props);
        return new JETABean(comp, default_props);
    }

    public static DynamicBeanInfo createBeanInfo(Class compClass) throws FormException {
        try {
            BeanInfo info = Introspector.getBeanInfo(compClass);
            return new DynamicBeanInfo(info);
        }
        catch (Exception e) {
            FormsLogger.severe(e);
            if (e instanceof FormException) {
                throw (FormException)e;
            }
            throw new FormException(e);
        }
    }

    public Class getBeanClass() {
        return this.m_comp_class;
    }

    public void defineProperties(BeanProperties props) {
        CompoundBorderProperty prop = new CompoundBorderProperty();
        prop.addBorder(new DefaultBorderProperty());
        props.register(prop);
        if (this.isScrollable()) {
            props.register(new ScrollBarsProperty());
        }
    }

    public String getShortBeanClassName() {
        return this.m_short_name;
    }

    public Component instantiateBean() throws FormException {
        try {
            return (Component)this.m_comp_class.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FormException(e);
        }
    }

    public boolean isScrollable() {
        return this.m_scrollable;
    }

    public void setBeanClass(Class compClass) {
        this.m_comp_class = compClass;
        try {
            String name = compClass.getName();
            int pos = name.lastIndexOf(".");
            if (pos > 0) {
                name = name.substring(pos + 1, name.length());
            }
            this.m_short_name = name;
        }
        catch (Exception e) {
            this.m_short_name = compClass.getName();
        }
    }

    public void setScrollable(boolean scrollable) {
        this.m_scrollable = scrollable;
    }
}

