/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.beans.factories;

import com.jeta.forms.gui.beans.BeanProperties;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.factories.JComponentBeanFactory;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.store.properties.ItemsProperty;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;

public class ListBeanFactory
extends JComponentBeanFactory {
    private ListModel m_default_model;

    public ListBeanFactory() {
        super(JList.class);
        this.setScrollable(true);
    }

    public void defineProperties(BeanProperties props) {
        super.defineProperties(props);
        props.register(new ItemsProperty());
        props.removeProperty("selectedIndex");
    }

    private ListModel getDefaultListModel() {
        if (this.m_default_model == null) {
            this.m_default_model = new JList().getModel();
        }
        return this.m_default_model;
    }

    public JETABean createBean(String compName, boolean instantiateBean, boolean setDefaults) throws FormException {
        JETABean jbean = super.createBean(compName, instantiateBean, setDefaults);
        Component comp = jbean.getDelegate();
        if (comp instanceof JList) {
            JList list = (JList)comp;
            try {
                ListModel model = list.getModel();
                if (model == null) {
                    list.setModel(new DefaultListModel());
                } else {
                    ListModel defmodel = this.getDefaultListModel();
                    if (defmodel != null && defmodel.getClass() == model.getClass()) {
                        list.setModel(new DefaultListModel());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jbean;
    }
}

