/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.store.properties.effects.PaintProperty;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class CellPainter
extends JPanel {
    private GridView m_view;
    private FormComponent m_form;
    private Rectangle m_gc_rect = new Rectangle();

    public CellPainter(GridView view) {
        this.m_view = view;
        this.setOpaque(false);
    }

    public void paintComponent(Graphics g) {
        int row;
        Graphics2D g2 = (Graphics2D)g;
        Color old_c = g2.getColor();
        Paint old_paint = g2.getPaint();
        Rectangle clip_rect = g.getClipBounds();
        clip_rect.setBounds(clip_rect.x, clip_rect.y, clip_rect.width + 2, clip_rect.height + 2);
        g.setClip(clip_rect.x, clip_rect.y, clip_rect.width, clip_rect.height);
        int clip_x1 = clip_rect.x;
        int clip_x2 = clip_rect.x + clip_rect.width;
        int clip_y1 = clip_rect.y;
        int clip_y2 = clip_rect.y + clip_rect.height;
        int min_row = -1;
        int max_row = -1;
        int min_col = -1;
        int max_col = -1;
        for (row = 1; row <= this.m_view.getRowCount(); ++row) {
            int row_y1 = this.m_view.getRowOrgY(row);
            int row_y2 = row_y1 + this.m_view.getRowHeight(row);
            if (clip_y1 >= row_y1 && clip_y1 <= row_y2) {
                if (min_row < 0) {
                    min_row = row;
                    continue;
                }
                max_row = row;
                continue;
            }
            if (clip_y2 >= row_y1 && clip_y2 <= row_y2) {
                if (min_row < 0) {
                    min_row = row;
                    continue;
                }
                max_row = row;
                continue;
            }
            if (row_y1 < clip_y1 || row_y2 > clip_y2) continue;
            if (min_row < 0) {
                min_row = row;
                continue;
            }
            max_row = row;
        }
        for (int col = 1; col <= this.m_view.getColumnCount(); ++col) {
            int col_x1 = this.m_view.getColumnOrgX(col);
            int col_x2 = col_x1 + this.m_view.getColumnWidth(col);
            if (clip_x1 >= col_x1 && clip_x1 <= col_x2) {
                if (min_col < 0) {
                    min_col = col;
                    continue;
                }
                max_col = col;
                continue;
            }
            if (clip_x2 >= col_x1 && clip_x2 <= col_x2) {
                if (min_col < 0) {
                    min_col = col;
                    continue;
                }
                max_col = col;
                continue;
            }
            if (col_x1 < clip_x1 || col_x2 > clip_x2) continue;
            if (min_col < 0) {
                min_col = col;
                continue;
            }
            max_col = col;
        }
        if (min_row < 0 || min_col < 0) {
            return;
        }
        if (max_row < 0) {
            max_row = min_row;
        }
        if (max_col < 0) {
            max_col = min_col;
        }
        for (row = min_row; row <= max_row; ++row) {
            for (int col = min_col; col <= max_col; ++col) {
                Painter painter;
                PaintProperty pp = this.m_view.getPaintProperty(col, row);
                if (pp == null || (painter = pp.createPainter()) == null) continue;
                GridComponent gc = this.m_view.getGridComponent(col, row);
                if (gc == null) {
                    this.m_gc_rect.setBounds(this.m_view.getColumnOrgX(col), this.m_view.getRowOrgY(row), this.m_view.getColumnWidth(col), this.m_view.getRowHeight(row));
                } else {
                    this.m_gc_rect.setBounds(gc.getCellX(), gc.getCellY(), gc.getCellWidth(), gc.getCellHeight());
                }
                if (!this.m_gc_rect.intersects(clip_rect)) continue;
                painter.paint(this, g, this.m_gc_rect);
            }
        }
        g2.setColor(old_c);
        g2.setPaint(old_paint);
    }
}

