/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.jml;

import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.JETAPersistable;
import com.jeta.forms.store.jml.JMLException;
import com.jeta.forms.store.jml.JMLSerializer;
import com.jeta.forms.store.jml.JMLUtils;
import com.jeta.forms.store.jml.dom.JMLDocument;
import com.jeta.forms.store.jml.dom.JMLNode;
import com.jeta.forms.store.properties.JETAProperty;
import java.io.IOException;

public class JMLObjectOutput
implements JETAObjectOutput {
    private JMLDocument m_document;
    private JMLNode m_objnode;

    public JMLObjectOutput(JMLDocument document, JMLNode objNode) {
        this.m_document = document;
        this.m_objnode = objNode;
    }

    public void writeVersion(int version) throws IOException {
    }

    public void writeInt(String tagName, int value) throws IOException {
        try {
            this.m_objnode.appendChild(JMLUtils.createPropertyNode(this.m_document, tagName, String.valueOf(value)));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void writeObject(String tagName, Object obj) throws IOException {
        try {
            if (obj != null) {
                this.m_objnode.appendChild(JMLUtils.createPropertyNode(this.m_document, tagName, obj));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public void writeBoolean(String tagName, boolean bval) throws IOException {
        try {
            this.m_objnode.appendChild(JMLUtils.createPropertyNode(this.m_document, tagName, String.valueOf(bval)));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void writeFloat(String tagName, float fval) throws IOException {
        try {
            this.m_objnode.appendChild(JMLUtils.createPropertyNode(this.m_document, tagName, String.valueOf(fval)));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public JETAObjectOutput getSuperClassOutput(Class superClass) {
        if (superClass == JETAProperty.class) {
            return this;
        }
        JMLNode supernode = JMLUtils.createSuperClassNode(this.m_document, superClass);
        this.m_objnode.appendChild(supernode);
        return new JMLObjectOutput(this.m_document, supernode);
    }

    public void writeBoolean(String string, boolean value, boolean defaultValue) throws IOException {
        if (value != defaultValue) {
            this.writeBoolean(string, value);
        }
    }

    public void writeInt(String string, int value, int defaultValue) throws IOException {
        if (value != defaultValue) {
            this.writeInt(string, value);
        }
    }

    public void writeFloat(String string, float value, float defaultValue) throws IOException {
        if (value != defaultValue) {
            this.writeFloat(string, value);
        }
    }

    public static class XMLObjectOutputSerializer
    implements JMLSerializer {
        public JMLNode serialize(JMLDocument document, Object obj) throws JMLException {
            JETAPersistable persistable = (JETAPersistable)obj;
            JMLNode node = JMLUtils.createObjectNode(document, obj);
            JMLObjectOutput xoo = new JMLObjectOutput(document, node);
            try {
                persistable.write(xoo);
                return node;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new JMLException(e.getMessage());
            }
        }
    }
}

