/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.effects.ImagePainter;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.IconProperty;
import com.jeta.forms.store.properties.effects.PaintSupport;
import com.jeta.open.i18n.I18N;
import java.awt.Component;
import java.io.IOException;

public class ImageProperty
extends IconProperty
implements PaintSupport {
    static final long serialVersionUID = -9049185327280513748L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 5;
    public static final int VERSION = 1;
    private int m_halign;
    private int m_valign;
    private transient ImagePainter m_painter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Painter createPainter() {
        if (this.m_painter == null) {
            this.m_painter = new ImagePainter(this, this.getHorizontalAlignment(), this.getVerticalAlignment());
        }
        return this.m_painter;
    }

    public int getHorizontalAlignment() {
        return this.m_halign;
    }

    public int getVerticalAlignment() {
        return this.m_valign;
    }

    public void setHorizontalAlignment(int align) {
        this.m_halign = align;
        this.m_painter = null;
    }

    public void setValue(Object prop) {
        super.setValue(prop);
        if (prop instanceof ImageProperty) {
            ImageProperty tp = (ImageProperty)prop;
            this.m_halign = tp.m_halign;
            this.m_valign = tp.m_valign;
            this.m_painter = null;
        } else if (!(prop instanceof IconProperty) && !$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void setVerticalAlignment(int align) {
        this.m_valign = align;
        this.m_painter = null;
    }

    public void updateBean(JETABean jbean) {
        Component comp;
        super.updateBean(jbean);
        ImagePainter painter = (ImagePainter)this.createPainter();
        if (jbean != null && (comp = jbean.getDelegate()) instanceof Paintable) {
            ((Paintable)((Object)comp)).setBackgroundPainter(painter);
        }
    }

    public String toString() {
        return I18N.getLocalizedMessage("Image");
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_halign = in.readInt("halign");
        this.m_valign = in.readInt("valign");
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(IconProperty.class));
        out.writeVersion(1);
        out.writeInt("halign", this.m_halign);
        out.writeInt("valign", this.m_valign);
    }

    static {
        $assertionsDisabled = !ImageProperty.class.desiredAssertionStatus();
    }
}

