/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.CompoundBorderProperty;
import com.jeta.forms.store.properties.DefaultBorderProperty;
import com.jeta.forms.store.properties.JETAProperty;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ScrollBarsProperty
extends JETAProperty {
    static final long serialVersionUID = 9130862301613978006L;
    public static final int VERSION = 3;
    private int m_vert_policy = 20;
    private int m_horz_policy = 30;
    private String m_scroll_name;
    private CompoundBorderProperty m_scroll_border = null;
    public static final String PROPERTY_ID = "scollBars";

    public ScrollBarsProperty() {
        super(PROPERTY_ID);
        this.m_vert_policy = 20;
        this.m_horz_policy = 30;
    }

    public ScrollBarsProperty(int vertpolicy, int horzpolicy) {
        super(PROPERTY_ID);
        this.m_vert_policy = vertpolicy;
        this.m_horz_policy = horzpolicy;
    }

    public CompoundBorderProperty getBorderProperty() {
        return this.m_scroll_border;
    }

    public int getVerticalScrollBarPolicy() {
        return this.m_vert_policy;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.m_horz_policy;
    }

    public String getScrollName() {
        return this.m_scroll_name;
    }

    public boolean isScrollable() {
        boolean result = this.getVerticalScrollBarPolicy() != 21 || this.getHorizontalScrollBarPolicy() != 31;
        return result;
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        this.m_horz_policy = policy;
    }

    public void setVerticalScrollBarPolicy(int policy) {
        this.m_vert_policy = policy;
    }

    public void setScrollName(String scrollName) {
        this.m_scroll_name = scrollName;
    }

    public void setBorderProperty(CompoundBorderProperty prop) {
        if (prop == null) {
            this.m_scroll_border = null;
        } else {
            if (this.m_scroll_border == null) {
                this.m_scroll_border = new CompoundBorderProperty();
            }
            this.m_scroll_border.setValue(prop);
        }
    }

    public void setValue(Object prop) {
        if (prop instanceof ScrollBarsProperty) {
            ScrollBarsProperty sb = (ScrollBarsProperty)prop;
            this.m_vert_policy = sb.m_vert_policy;
            this.m_horz_policy = sb.m_horz_policy;
            this.m_scroll_name = sb.m_scroll_name;
            if (this.m_scroll_border == null) {
                this.m_scroll_border = new CompoundBorderProperty();
            }
            if (sb.m_scroll_border == null) {
                this.m_scroll_border.addBorder(new DefaultBorderProperty());
            } else {
                this.m_scroll_border.setValue(sb.m_scroll_border);
            }
        }
    }

    public void updateBean(JETABean bean) {
        Component comp = null;
        if (bean != null) {
            comp = bean.getDelegate();
        }
        bean.removeAll();
        if (this.isScrollable()) {
            JScrollPane scroll = null;
            Container c = comp.getParent();
            if (c instanceof JViewport) {
                scroll = (JScrollPane)c.getParent();
            } else {
                boolean bdesign = FormUtils.isDesignMode();
                Dimension pref_sz = new Dimension(80, 80);
                scroll = new JScrollPane(comp);
                scroll.setPreferredSize(pref_sz);
            }
            scroll.setHorizontalScrollBarPolicy(this.m_horz_policy);
            scroll.setVerticalScrollBarPolicy(this.m_vert_policy);
            if (comp.isOpaque()) {
                scroll.setOpaque(true);
            }
            if (this.m_scroll_name != null) {
                scroll.setName(this.m_scroll_name);
            }
            if (this.m_scroll_border != null) {
                try {
                    scroll.setBorder(this.m_scroll_border.createBorder(scroll));
                }
                catch (Exception e) {
                    FormsLogger.severe(e);
                }
            }
            bean.add((Component)scroll, "Center");
        } else {
            bean.add(comp, "Center");
        }
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_vert_policy = in.readInt("verticalpolicy");
        this.m_horz_policy = in.readInt("horizontalpolicy");
        if (version >= 2) {
            this.m_scroll_name = (String)in.readObject("scrollname");
        }
        if (version >= 3) {
            this.m_scroll_border = (CompoundBorderProperty)in.readObject("border");
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(3);
        out.writeInt("verticalpolicy", this.m_vert_policy);
        out.writeInt("horizontalpolicy", this.m_horz_policy);
        out.writeObject("scrollname", this.m_scroll_name);
        out.writeObject("border", this.m_scroll_border);
    }
}

