/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.support;

import com.jeta.forms.store.AbstractJETAPersistable;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import java.io.IOException;

public class Matrix
extends AbstractJETAPersistable {
    static final long serialVersionUID = -6465003684197543526L;
    public static final int VERSION = 1;
    private Object[] m_rows;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Matrix() {
        this.m_rows = new Object[0];
    }

    public Matrix(int rows, int cols) {
        this.m_rows = new Object[rows];
        for (int row = 0; row < rows; ++row) {
            this.m_rows[row] = new Object[cols];
        }
    }

    public int getRowCount() {
        return this.m_rows == null ? 0 : this.m_rows.length;
    }

    public int getColumnCount() {
        if (this.m_rows == null || this.m_rows.length == 0) {
            return 0;
        }
        Object[] row = (Object[])this.m_rows[0];
        if (row == null) {
            return 0;
        }
        return row.length;
    }

    public Object getValue(int row, int col) {
        Object[] rowdata;
        if (row >= 0 && row < this.getRowCount() && (rowdata = (Object[])this.m_rows[row]) != null && col >= 0 && col < rowdata.length) {
            return rowdata[col];
        }
        return null;
    }

    public void setValue(int row, int col, Object value) {
        Object[] rowdata;
        if (row >= 0 && row < this.getRowCount() && (rowdata = (Object[])this.m_rows[row]) != null && col >= 0 && col < rowdata.length) {
            rowdata[col] = value;
        }
    }

    public void insertRow(int row) {
        if (row > this.m_rows.length) {
            row = this.m_rows.length;
        }
        if (row < 0) {
            row = 0;
        }
        Object[] newdata = this.insertElement(this.m_rows, row);
        newdata[row] = new Object[this.getColumnCount()];
        this.m_rows = newdata;
    }

    public void insertColumn(int col) {
        if (col > this.getColumnCount()) {
            col = this.getColumnCount();
        }
        if (col < 0) {
            col = 0;
        }
        for (int row = 0; row < this.m_rows.length; ++row) {
            Object[] newrow;
            this.m_rows[row] = newrow = this.insertElement((Object[])this.m_rows[row], col);
        }
    }

    public void removeColumn(int col) {
        if (col > this.getColumnCount()) {
            col = this.getColumnCount();
        }
        if (col < 0) {
            col = 0;
        }
        for (int row = 0; row < this.m_rows.length; ++row) {
            Object[] newrow;
            this.m_rows[row] = newrow = this.deleteElement((Object[])this.m_rows[row], col);
        }
    }

    public void removeRow(int row) {
        if (row > this.m_rows.length) {
            row = this.m_rows.length;
        }
        if (row < 0) {
            row = 0;
        }
        Object[] newdata = this.deleteElement(this.m_rows, row);
        this.m_rows = newdata;
    }

    private Object[] insertElement(Object[] src, int index) {
        Object[] newdata = new Object[src.length + 1];
        System.arraycopy(src, 0, newdata, 0, index);
        if (src.length - index > 0) {
            System.arraycopy(src, index, newdata, index + 1, src.length - index);
        }
        return newdata;
    }

    private Object[] deleteElement(Object[] src, int index) {
        if (src.length - 1 < 0 && !$assertionsDisabled) {
            throw new AssertionError();
        }
        Object[] newdata = new Object[src.length - 1];
        System.arraycopy(src, 0, newdata, 0, index);
        if (src.length - index - 1 > 0) {
            System.arraycopy(src, index + 1, newdata, index, src.length - index - 1);
        }
        return newdata;
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        int version = in.readVersion();
        this.m_rows = (Object[])in.readObject("rows");
    }

    public void write(JETAObjectOutput out) throws IOException {
        out.writeVersion(1);
        out.writeObject("rows", this.m_rows);
    }

    static {
        $assertionsDisabled = !Matrix.class.desiredAssertionStatus();
    }
}

