/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.Boolean;

import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.Objects;
import javax.swing.JCheckBox;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormFieldWithValueList;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;

public class JDynFormFieldBoolean
extends AbstractJDynFormFieldWithValueList
implements JDynFormField,
FocusListener {
    private ItemListener itemListener;

    public JDynFormFieldBoolean(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
    }

    protected JCheckBox getJCheckBox() {
        return (JCheckBox)this.contents;
    }

    public void initComponent() {
        DynObjectValueItem[] availableValues = this.getDefinition().getAvailableValues();
        if (availableValues == null) {
            JCheckBox checkBox = this.getComponentsFactory().getJCheckBox(this.getDefinition(), null);
            this.contents = checkBox;
            this.itemListener = e -> this.fireFieldChangedEvent();
            checkBox.addItemListener(this.itemListener);
            this.contents.addFocusListener(this);
            if (this.getDefinition().isReadOnly()) {
                this.getJCheckBox().setEnabled(false);
            }
            this.setValue(this.getAssignedValue());
        } else {
            super.initComponent();
        }
    }

    public void setValue(Object value) {
        boolean s = false;
        if (value == null) {
            value = this.getDefinition().getDefaultValue();
            if (value != null) {
                s = (Boolean)value;
            }
        } else {
            s = (Boolean)value;
            try {
                this.getDefinition().validate(value);
                this.problemIndicator().clear();
            }
            catch (DynFieldValidateException e) {
                this.problemIndicator().set(e.getLocalizedMessage());
            }
        }
        if (this.contents instanceof JCheckBox) {
            JCheckBox checkBox = this.getJCheckBox();
            checkBox.removeItemListener(this.itemListener);
            checkBox.setSelected(s);
            checkBox.addItemListener(this.itemListener);
            this.assignedValue = value;
        } else {
            super.setValue((Object)s);
        }
    }

    public Object getValue() {
        Boolean value = null;
        if (this.contents instanceof JCheckBox) {
            boolean s = this.getJCheckBox().isSelected();
            value = s;
            try {
                this.getDefinition().validate((Object)value);
                this.problemIndicator().clear();
            }
            catch (DynFieldValidateException e) {
                throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, e.getLocalizedMessage());
            }
            return value;
        }
        return super.getValue();
    }

    public boolean isModified() {
        Boolean assigned = (Boolean)this.getAssignedValue();
        if (this.contents instanceof JCheckBox) {
            boolean value = this.getJCheckBox().isSelected();
            if (!value && assigned == null) {
                return false;
            }
            return !Objects.equals(value, assigned);
        }
        String s = this.getValueFromJComponent();
        if (StringUtils.isBlank((CharSequence)s)) {
            return assigned != null;
        }
        try {
            Object value = this.getDefinition().coerce((Object)s);
            return !Objects.equals(value, assigned);
        }
        catch (CoercionException e) {
            return true;
        }
    }
}

