/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.Password;

import java.awt.event.FocusListener;
import java.util.Map;
import java.util.Objects;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.util.MapBuilder;

public class JDynFormFieldPassword
extends AbstractJDynFormField
implements JDynFormField {
    private String assignedValue = null;
    private String crypt_algorithm = null;
    private DocumentListener documentListener;
    private static final Map<String, String> algorithms = new MapBuilder().add((Object)"SHA-512", (Object)"$6$").add((Object)"SHA-256", (Object)"$5$").add((Object)"MD5", (Object)"$1$").add((Object)"DES", (Object)"").build();

    public JDynFormFieldPassword(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = Objects.toString(value, null);
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    private JTextComponent getJTextComponent() {
        return (JTextComponent)this.contents;
    }

    public void initComponent() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        JTextComponent text = this.getComponentsFactory().getJPasswordField(this.getDefinition(), null);
        toolsSwingManager.addClearButton(text);
        this.contents = text;
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JDynFormFieldPassword.this.fireFieldChangedEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JDynFormFieldPassword.this.fireFieldChangedEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JDynFormFieldPassword.this.fireFieldChangedEvent();
            }
        };
        text.getDocument().addDocumentListener(this.documentListener);
        this.crypt_algorithm = this.getDefinition().getTags().getString("dynform.password.crypt", null);
        if (this.getDefinition().isReadOnly()) {
            this.getJTextComponent().setEditable(false);
        }
        this.getJTextComponent().addFocusListener((FocusListener)((Object)this));
        this.setValue(this.assignedValue);
    }

    public void setValue(Object value) {
        String s = Objects.toString(value, "");
        this.assignedValue = Objects.toString(value, null);
        this.getJTextComponent().setText(s);
        this.fixPreferredWidth(this.getJTextComponent());
        this.setTranslateEmptyToNull(value == null);
    }

    public Object getValue() {
        String s = this.getJTextComponent().getText();
        if (StringUtils.isNotBlank((CharSequence)this.crypt_algorithm) && !StringUtils.equals((CharSequence)s, (CharSequence)this.assignedValue)) {
            s = Crypt.crypt((String)s, (String)algorithms.getOrDefault(this.crypt_algorithm, ""));
        }
        return s;
    }

    public boolean hasValidValue() {
        return true;
    }

    public boolean isModified() {
        String value = this.getJTextComponent().getText();
        String assigned = (String)this.getAssignedValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return StringUtils.isNotBlank((CharSequence)assigned);
        }
        return !Objects.equals(value, assigned);
    }
}

