/*
 * Decompiled with CFR 0.152.
 */
package jwizardcomponent.frame;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jwizardcomponent.CancelAction;
import jwizardcomponent.DefaultJWizardComponents;
import jwizardcomponent.FinishAction;
import jwizardcomponent.JWizardComponents;
import jwizardcomponent.JWizardPanel;

public class JWizardFrame
extends JFrame {
    private JWizardComponents wizardComponents;
    private JPanel buttonPanel;
    private JLabel panelTitleLabel;

    public JWizardFrame() {
        this.init();
    }

    private void init() {
        this.wizardComponents = new DefaultJWizardComponents();
        this.wizardComponents.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JWizardFrame.this.setPanelTitle(((JWizardPanel)propertyChangeEvent.getNewValue()).getPanelTitle());
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createTitlePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)new JSeparator(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.getContentPane().add((Component)this.wizardComponents.getWizardPanelsContainer(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JSeparator(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.getContentPane().add((Component)this.createButtonPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.wizardComponents.setFinishAction(this.createFinishAction());
        this.wizardComponents.setCancelAction(this.createCancelAction());
        this.handleWindowClosing();
    }

    public JWizardComponents getWizardComponents() {
        return this.wizardComponents;
    }

    public void setWizardComponents(JWizardComponents jWizardComponents) {
        this.wizardComponents = jWizardComponents;
    }

    public void show() {
        this.wizardComponents.updateComponents();
        super.show();
    }

    protected void setPanelTitle(String string) {
        this.panelTitleLabel.setText(string);
    }

    protected JPanel createTitlePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.panelTitleLabel = new JLabel();
        this.panelTitleLabel.setHorizontalAlignment(10);
        jPanel.add(this.panelTitleLabel);
        return jPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout());
        jPanel.add(this.wizardComponents.getBackButton());
        jPanel.add(this.wizardComponents.getNextButton());
        jPanel.add(this.wizardComponents.getFinishButton());
        jPanel.add(this.wizardComponents.getCancelButton());
        return jPanel;
    }

    protected FinishAction createFinishAction() {
        return new FinishAction(this.wizardComponents){

            public void performAction() {
                System.out.println("FinishAction performed");
                JWizardFrame.this.dispose();
            }
        };
    }

    protected CancelAction createCancelAction() {
        return new CancelAction(this.wizardComponents){

            public void performAction() {
                System.out.println("CancelAction performed");
                JWizardFrame.this.dispose();
            }
        };
    }

    protected void handleWindowClosing() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JWizardFrame.this.wizardComponents.getCancelAction().performAction();
            }
        });
    }
}

